/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.motion;

import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viplugineclipse.viimplementation.util.WordSeparatorUtils;

public class MoveWordEnd
extends MotionCommand {
    private final boolean fullWord;
    private final WordSeparatorUtils wordSeparatorUtils;
    private final boolean inVisualMode;

    public MoveWordEnd(int counter, boolean fullWord, boolean inVisualMode) {
        super(counter);
        this.fullWord = fullWord;
        this.inVisualMode = inVisualMode;
        this.wordSeparatorUtils = this.viLayer.getWordSeparatorUtils();
    }

    @Override
    public void execute() {
        String text = this.document.get();
        int newCursor = this.editor.getCaretPosition();
        if (this.inVisualMode) {
            newCursor = Math.max(0, newCursor - 1);
        }
        newCursor = this.fullWord ? this.getEndOfCurrentWORD(this._counter, newCursor, text) : this.getEndOfCurrentWord(this._counter, newCursor, text);
        if (this.inVisualMode) {
            ++newCursor;
        }
        this.editor.setCaretPosition(newCursor);
        this.viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }

    private int getEndOfCurrentWord(int counter, int startPos, String text) {
        int newPos = startPos;
        int i = 0;
        while (i < counter) {
            newPos = this.wordSeparatorUtils.getEndOfCurrentWord(text, newPos, true, true);
            ++i;
        }
        return newPos;
    }

    private int getEndOfCurrentWORD(int counter, int startPos, String text) {
        int newPos = startPos;
        int i = 0;
        while (i < counter) {
            newPos = this.wordSeparatorUtils.getEndOfCurrentWORD(text, newPos);
            ++i;
        }
        return newPos;
    }
}

