/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.select;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class SelectLines
extends Command {
    private final int _lines;
    private final boolean _includeDelimiter;
    private final int _direction;
    public static final int UP = 0;
    public static final int DOWN = 1;

    public SelectLines(int lines, int direction, boolean includeDelimiter) {
        this._lines = lines;
        this._includeDelimiter = includeDelimiter;
        this._direction = direction;
    }

    public SelectLines(int direction, boolean includeDelimiter) {
        this._lines = this.document.getNumberOfLines();
        this._includeDelimiter = includeDelimiter;
        this._direction = direction;
    }

    @Override
    public void execute() {
        Line endLine;
        Line startLine;
        if (this.document.isEmpty()) {
            return;
        }
        int cursorPos = this.editor.getCaretPosition();
        if (this._direction == 1) {
            startLine = this.document.getLineOfOffset(cursorPos);
            int startLinePos = this.document.getLinePosOfOffset(cursorPos);
            int endLinePos = startLinePos + this._lines - 1;
            endLinePos = Math.min(endLinePos, this.document.getNumberOfLines() - 1);
            endLine = this.document.getLine(endLinePos);
        } else {
            int endLinePos = this.document.getLinePosOfOffset(cursorPos);
            endLine = this.document.getLine(endLinePos);
            int startLinePos = endLinePos - this._lines;
            if (startLinePos < 0) {
                startLinePos = 0;
            }
            startLine = this.document.getLine(startLinePos);
        }
        int start = startLine.getOffset();
        int length = endLine.getOffset() + endLine.getLength() - start;
        if (!this._includeDelimiter) {
            length -= endLine.getDelimiter().length();
        }
        this.selectionManager.setInternalSelection(start, length);
    }
}

