/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.select;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class SelectParagraph
extends Command {
    private int counter;
    private boolean inner;

    public SelectParagraph(int counter, boolean inner) {
        this.counter = counter;
        this.inner = inner;
    }

    @Override
    public void execute() {
        int startLinePos = this.document.getLinePosOfOffset(this.editor.getCaretPosition());
        String textOfLine = this.document.getTextOfLinePos(startLinePos);
        boolean startsOnEmptyLine = textOfLine.trim().length() == 0;
        Line startLine = this.document.getLine(startLinePos);
        Line endLine = this.document.getLine(startLinePos);
        boolean isPreviousLineEmpty = startsOnEmptyLine;
        startLine = startsOnEmptyLine ? this.document.getLine(this.getFirstEmptyLine(startLinePos)) : this.document.getLine(this.getFirstNonEmptyLine(startLinePos));
        if (this.inner) {
            int i = startLinePos + 1;
            while (i < this.document.getNumberOfLines()) {
                endLine = this.document.getLine(i);
                String lineText = this.document.getTextOfLine(endLine).trim();
                if (lineText.length() == 0) {
                    if (!isPreviousLineEmpty) {
                        --this.counter;
                        if (this.counter == 0) {
                            endLine = this.document.getLine(i - 1);
                            break;
                        }
                    }
                    isPreviousLineEmpty = true;
                } else {
                    if (isPreviousLineEmpty) {
                        --this.counter;
                        if (this.counter == 0) {
                            endLine = this.document.getLine(i - 1);
                            break;
                        }
                    }
                    isPreviousLineEmpty = false;
                }
                ++i;
            }
        } else {
            int i = startLinePos + 1;
            while (i < this.document.getNumberOfLines()) {
                endLine = this.document.getLine(i);
                String lineText = this.document.getTextOfLine(endLine).trim();
                if (lineText.length() == 0) {
                    if (!isPreviousLineEmpty) {
                        --this.counter;
                        if (this.counter == 0) break;
                    }
                    isPreviousLineEmpty = true;
                } else {
                    isPreviousLineEmpty = false;
                }
                ++i;
            }
        }
        this.selectionManager.setInternalSelection(startLine.getOffset(), endLine.getOffsetEnd() - startLine.getOffset());
    }

    private int getFirstEmptyLine(int startLinePos) {
        int i = startLinePos - 1;
        while (i >= 0) {
            boolean isEmptyLine;
            String textOfLine = this.document.getTextOfLinePos(i);
            boolean bl = isEmptyLine = textOfLine.trim().length() == 0;
            if (!isEmptyLine) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private int getFirstNonEmptyLine(int startLinePos) {
        int i = startLinePos - 1;
        while (i >= 0) {
            boolean isEmptyLine;
            String textOfLine = this.document.getTextOfLinePos(i);
            boolean bl = isEmptyLine = textOfLine.trim().length() == 0;
            if (isEmptyLine) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }
}

