/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.select;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectLines;
import com.mbartl.viplugineclipse.viimplementation.util.Region;

public class SelectToBookmark
extends Command {
    public static final int LINE = 0;
    public static final int CHARACTER = 1;
    private final int _pos;
    private final int _type;
    private final boolean _includeDelimiter;

    public SelectToBookmark(char mark, int type, boolean includeDelimiter) {
        this._pos = this.viLayer.getBookmarkHandler().getPosition(String.valueOf(mark));
        this._type = type;
        this._includeDelimiter = includeDelimiter;
    }

    @Override
    public void execute() {
        if (this._pos == -1) {
            return;
        }
        int startPos = this.editor.getCaretPosition();
        if (this._type == 0) {
            int lines;
            int direction;
            int startLine = this.document.getLinePosOfOffset(startPos);
            int endLine = this.document.getLinePosOfOffset(this._pos);
            if (endLine - startLine < 0) {
                direction = 0;
                lines = startLine - endLine;
            } else {
                direction = 1;
                lines = endLine - startLine + 1;
            }
            if (lines == -1) {
                return;
            }
            new SelectLines(lines, direction, this._includeDelimiter).execute();
        } else {
            Region region = new Region(startPos, this._pos - startPos);
            this.selectionManager.setInternalSelection(Region.normalize(region));
        }
    }
}

