/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.select;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class SelectToWordEnd
extends Command {
    private final int _counter;
    private final boolean _fullWord;
    private final boolean _selectUntilLastEndCharacter;

    public SelectToWordEnd(int counter, boolean fullWord, boolean selectUntilLastEndCharacter) {
        this._counter = counter;
        this._fullWord = fullWord;
        this._selectUntilLastEndCharacter = selectUntilLastEndCharacter;
    }

    @Override
    public void execute() {
        int start;
        int end = start = this.editor.getCaretPosition();
        String text = this.document.get();
        end = this._fullWord ? this.getEndOfCurrentWORD(this._counter, end, text) : this.getEndOfCurrentWord(this._counter, end, text);
        ++end;
        if (this._counter == 1) {
            Line line = this.document.getLineOfOffset(start);
            end = Math.min(end, line.getOffsetEndWithoutDelimiter());
        }
        int length = end - start;
        this.selectionManager.setInternalSelection(start, length);
    }

    private int getEndOfCurrentWord(int counter, int startPos, String text) {
        int newPos = startPos - 1;
        int i = 0;
        while (i < counter) {
            ++newPos;
            newPos = this.viLayer.getWordSeparatorUtils().getEndOfCurrentWord(text, newPos, this._selectUntilLastEndCharacter, false);
            ++i;
        }
        return newPos;
    }

    private int getEndOfCurrentWORD(int counter, int startPos, String text) {
        int newPos = startPos;
        int i = 0;
        while (i < counter) {
            newPos = this.viLayer.getWordSeparatorUtils().getEndOfCurrentWORD(text, newPos);
            ++i;
        }
        return newPos;
    }
}

