/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.select;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class SelectWord
extends Command {
    private final int counter;
    private final boolean forward;
    private final boolean word;
    private final boolean selectFromWordBegin;

    public SelectWord(int counter, boolean forward, boolean word, boolean selectFromWordBegin) {
        this.counter = counter;
        this.forward = forward;
        this.word = word;
        this.selectFromWordBegin = selectFromWordBegin;
    }

    @Override
    public void execute() {
        int length;
        int start = this.editor.getCaretPosition();
        if (this.selectFromWordBegin && (start = this.word ? this.viLayer.getWordSeparatorUtils().getPreviousWORD(this.document.get(), start + 1) : this.viLayer.getWordSeparatorUtils().getPreviousWord(this.document.get(), start + 1)) == -1) {
            start = 0;
        }
        if (this.forward) {
            length = this.selectWordForward(start, this.word);
        } else {
            length = this.selectWordBackward(start, this.word);
            start -= length;
        }
        this.selectionManager.setInternalSelection(start, length);
    }

    private int selectWordForward(int start, boolean fullWord) {
        int linePos;
        Line line;
        int end = start;
        String text = this.document.get();
        int i = 0;
        while (i < this.counter) {
            end = fullWord ? this.viLayer.getWordSeparatorUtils().getNextWORD(text, end) : this.viLayer.getWordSeparatorUtils().getNextWord(text, end);
            ++i;
        }
        if (this.counter == 1) {
            Line line2 = this.document.getLineOfOffset(start);
            end = Math.min(end, line2.getOffset() + line2.getLengthWithoutDelimiter());
        }
        if ((line = this.document.getLineOfOffset(end)).getOffset() == end && (linePos = this.document.getLinePosOfOffset(end)) > 0) {
            end = this.document.getLine(linePos - 1).getOffsetEndWithoutDelimiter();
        }
        return end - start;
    }

    private int selectWordBackward(int start, boolean fullWord) {
        String text = this.document.get();
        int end = start;
        end = Math.min(end, text.length() - 1);
        int i = 0;
        while (i < this.counter) {
            end = fullWord ? this.viLayer.getWordSeparatorUtils().getPreviousWORD(text, end) : this.viLayer.getWordSeparatorUtils().getPreviousWord(text, end);
            if (end == -1) {
                end = 0;
            }
            ++i;
        }
        return start - end;
    }
}

