/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.command.actions.select;

import com.mbartl.viplugineclipse.viimplementation.command.actions.Command;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectBlock;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectCharacters;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectCharactersBackwards;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectFullWord;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectLines;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectParagraph;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToBookmark;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToBottomLine;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToCharacter;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToCharacterBackward;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToLine;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToLineBegin;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToLineBeginNonBlank;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToLineEnd;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToMatchBrace;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToMiddleLine;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToNextBlankLine;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToPreviousBlankLine;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToTopLine;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectToWordEnd;
import com.mbartl.viplugineclipse.viimplementation.command.actions.select.SelectWord;
import com.mbartl.viplugineclipse.viimplementation.parser.ParsedCommand;

public class SelectionCommandFactory {
    private static final String ENTER = String.valueOf('\n');

    public static Command createCommand(ParsedCommand pc) {
        String m = pc.getModifier();
        int c = pc.getCounter();
        Command command = null;
        if (m.equals("<CD>") || m.equals("j") || m.equals(ENTER)) {
            command = new SelectLines(c + 1, 1, true);
        } else if (m.equals("<CU>") || m.equals("k")) {
            command = new SelectLines(c, 0, true);
        } else if (m.equals("w")) {
            command = new SelectWord(c, true, false, false);
        } else if (m.equals("W")) {
            command = new SelectWord(c, true, true, false);
        } else if (m.equals("b")) {
            command = new SelectWord(c, false, false, false);
        } else if (m.equals("B")) {
            command = new SelectWord(c, false, true, false);
        } else if (m.equals("e")) {
            command = new SelectToWordEnd(c, false, false);
        } else if (m.equals("E")) {
            command = new SelectToWordEnd(c, true, false);
        } else if (m.equals("H")) {
            command = new SelectToTopLine();
        } else if (m.equals("M")) {
            command = new SelectToMiddleLine();
        } else if (m.equals("L")) {
            command = new SelectToBottomLine();
        } else if (m.equals("$")) {
            command = new SelectToLineEnd(c);
        } else if (m.equals("0")) {
            command = new SelectToLineBegin();
        } else if (m.equals("^")) {
            command = new SelectToLineBeginNonBlank();
        } else if (m.equals("<CL>") || m.equals("l") || m.equals(" ")) {
            command = new SelectCharacters(c);
        } else if (m.equals("<CR>") || m.equals("h")) {
            command = new SelectCharactersBackwards(c);
        } else if (m.startsWith("'") && m.length() > 1) {
            command = new SelectToBookmark(m.charAt(1), 0, true);
        } else if (m.startsWith("`") && m.length() > 1) {
            command = new SelectToBookmark(m.charAt(1), 1, true);
        } else if (m.startsWith("t") && m.length() > 1) {
            command = new SelectToCharacter(c, m.charAt(1), false);
        } else if (m.startsWith("f") && m.length() > 1) {
            command = new SelectToCharacter(c, m.charAt(1), true);
        } else if (m.startsWith("T") && m.length() > 1) {
            command = new SelectToCharacterBackward(c, m.charAt(1), false);
        } else if (m.startsWith("F") && m.length() > 1) {
            command = new SelectToCharacterBackward(c, m.charAt(1), true);
        } else if (m.equals("}")) {
            command = new SelectToNextBlankLine(c);
        } else if (m.equals("{")) {
            command = new SelectToPreviousBlankLine(c);
        } else if (m.equals("%")) {
            command = new SelectToMatchBrace();
        } else if (m.equals("G")) {
            command = pc.isCounterUsed() ? new SelectToLine(c) : new SelectLines(1, true);
        } else if (m.equals("gg")) {
            command = pc.isCounterUsed() ? new SelectToLine(c) : new SelectLines(0, true);
        } else if (m.equals("aw")) {
            command = new SelectWord(c, true, false, true);
        } else if (m.equals("aW")) {
            command = new SelectWord(c, true, true, true);
        } else if (m.equals("iW")) {
            command = new SelectFullWord(c, true, true);
        } else if (m.equals("iw")) {
            command = new SelectFullWord(c, false, true);
        } else if (m.equals("ab")) {
            command = new SelectBlock(c, false, '(', ')');
        } else if (m.equals("ib")) {
            command = new SelectBlock(c, true, '(', ')');
        } else if (m.equals("a\"")) {
            command = new SelectBlock(c, false, '\"', '\"');
        } else if (m.equals("i\"")) {
            command = new SelectBlock(c, true, '\"', '\"');
        } else if (m.equals("a{")) {
            command = new SelectBlock(c, false, '{', '}');
        } else if (m.equals("i{")) {
            command = new SelectBlock(c, true, '{', '}');
        } else if (m.equals("a(")) {
            command = new SelectBlock(c, false, '(', ')');
        } else if (m.equals("i(")) {
            command = new SelectBlock(c, true, '(', ')');
        } else if (m.equals("a[")) {
            command = new SelectBlock(c, false, '[', ']');
        } else if (m.equals("i[")) {
            command = new SelectBlock(c, true, '[', ']');
        } else if (m.equals("a'") || m.equals("a'")) {
            command = new SelectBlock(c, false, '\'', '\'');
        } else if (m.equals("i'") || m.equals("i'")) {
            command = new SelectBlock(c, true, '\'', '\'');
        } else if ("ap".equals(m)) {
            command = new SelectParagraph(c, false);
        } else if ("ip".equals(m)) {
            command = new SelectParagraph(c, true);
        }
        return command;
    }
}

