/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.layer;

import com.mbartl.viplugineclipse.Buffer;
import com.mbartl.viplugineclipse.BufferEvaluator;
import com.mbartl.viplugineclipse.utils.ActionUtils;
import com.mbartl.viplugineclipse.viimplementation.command.actions.change.InsertString;
import com.mbartl.viplugineclipse.viimplementation.command.actions.change.ReplaceModeCharEntered;
import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.CheckValidCursorPosition;
import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.MoveLeft;
import com.mbartl.viplugineclipse.viimplementation.command.actions.motion.MoveRight;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.parser.Abbreviations;
import com.mbartl.viplugineclipse.viimplementation.parser.Mappings;
import com.mbartl.viplugineclipse.viimplementation.util.Macro;
import com.mbartl.viplugineclipse.viimplementation.util.ViKeyEvent;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;

public class KeyVerifier
implements VerifyKeyListener {
    private static final char DELETE = '\u007f';
    private static final char BACKSPACE = '\b';
    private static final int ESCAPE = 27;
    private static final int SPACE = 32;
    private final ViLayer layer;
    private final ITextViewerExtension extension;
    private String keySequence = "";
    private boolean inMapReplay = false;
    private Timer waitForMoreInputTimer;

    public KeyVerifier(ViLayer layer, ITextViewerExtension extension) {
        this.layer = layer;
        this.extension = extension;
    }

    public boolean acceptKey(ViKeyEvent e) {
        Macro macro = BufferEvaluator.getInstance().getMacro();
        if (macro != null) {
            macro.add(e);
        }
        if (e.getKeyChar() == '\u001b') {
            if (this.layer.isInCommandMode()) {
                BufferEvaluator.getInstance().clear();
                this.layer.setCaret();
            } else if (this.layer.isInInsertMode() || this.layer.isInReplaceMode()) {
                BufferEvaluator.getInstance().executeMultipleInsertModeCommand();
                new MoveLeft(1, false).execute();
                this.layer.switchToCommandMode();
                new CheckValidCursorPosition().execute();
            } else if (this.layer.isInAnyVisualMode()) {
                this.layer.switchToCommandMode();
            }
            e.consume();
        } else if (this.layer.isInCommandMode() || this.layer.isInAnyVisualMode()) {
            this.inCommandMode(e);
        } else if (this.layer.isInInsertMode()) {
            if (e.getKeyChar() == '\b' || e.getKeyChar() == '\u007f') {
                Buffer.getInstance().getInsertBuffer().append(e.getKeyChar());
            }
            if (this.inMapReplay) {
                if (e.getKeyChar() == '\b') {
                    BufferEvaluator.getInstance().appendAndEval("h");
                    BufferEvaluator.getInstance().appendAndEval("x");
                } else if (e.getKeyChar() == '\u007f') {
                    BufferEvaluator.getInstance().appendAndEval("x");
                } else {
                    this.applyAbbreviations(e);
                    new InsertString(String.valueOf(e.getKeyChar()), 0).execute();
                }
            } else {
                this.applyAbbreviations(e);
            }
        } else if (this.layer.isInReplaceMode() && e.getKeyChar() != '\u0000') {
            if (e.getKeyChar() == '\b') {
                BufferEvaluator.getInstance().appendAndEval("h");
            } else if (e.getKeyChar() == '\u007f') {
                BufferEvaluator.getInstance().appendAndEval("x");
            } else {
                new ReplaceModeCharEntered(e.getKeyChar()).execute();
                new MoveRight(1, 1).execute();
            }
            Buffer.getInstance().getInsertBuffer().append(e.getKeyChar());
            e.consume();
        }
        this.layer.setStatusLine();
        return e.isConsumed();
    }

    private void applyAbbreviations(ViKeyEvent e) {
        String string;
        String abb;
        Abbreviations abbreviations = Abbreviations.getInstance();
        if ((Character.isWhitespace(e.getKeyChar()) || abbreviations.hasWordBoundaryAbbreviations() && abbreviations.isWordBoundaryChar(e.getKeyChar())) && (abb = abbreviations.isAbbreviation(string = Buffer.getInstance().getInsertBuffer().toString())) != null) {
            String abbreviation = abbreviations.getAbbreviation(abb);
            int length = abb.length();
            int pos = this.layer.getEditor().getCaretPosition();
            this.layer.getDocument().replace(pos - length, length, abbreviation);
        }
    }

    private void inCommandMode(ViKeyEvent e) {
        BufferEvaluator bufferEvaluator = BufferEvaluator.getInstance();
        if (e.getKeyCode() == 40 && e.getModifiers() == 0) {
            bufferEvaluator.appendAndEval("<CD>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 38 && e.getModifiers() == 0) {
            bufferEvaluator.appendAndEval("<CU>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 37 && e.getModifiers() == 0) {
            bufferEvaluator.appendAndEval("<CL>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 39 && e.getModifiers() == 0) {
            bufferEvaluator.appendAndEval("<CR>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 0x1000006 && e.getModifiers() == 0) {
            bufferEvaluator.appendAndEval("<PageDown>");
            e.consume();
            return;
        }
        if (e.getKeyCode() == 0x1000005 && e.getModifiers() == 0) {
            bufferEvaluator.appendAndEval("<PageUp>");
            e.consume();
            return;
        }
        if (e.getKeyChar() == '\u0000' && e.getKeyCode() == 36) {
            bufferEvaluator.appendAndEval('0');
            e.consume();
            return;
        }
        if (e.getKeyChar() == '\u0000' && e.getKeyCode() == 35) {
            bufferEvaluator.appendAndEval('$');
            e.consume();
            return;
        }
        switch (e.getKeyChar()) {
            case '\b': {
                bufferEvaluator.backspacePressed();
                bufferEvaluator.eval();
                e.consume();
                break;
            }
            case '\u007f': {
                bufferEvaluator.deletePressed();
                bufferEvaluator.eval();
                e.consume();
                break;
            }
            case '\u0000': {
                break;
            }
            default: {
                bufferEvaluator.appendAndEval(e.getKeyChar());
                e.consume();
            }
        }
    }

    public boolean checkMappings(ViKeyEvent e, boolean realKeyPress) {
        int maptype;
        Mappings mappings = Mappings.getInstance();
        if (realKeyPress) {
            if (this.waitForMoreInputTimer != null) {
                this.waitForMoreInputTimer.cancel();
                this.waitForMoreInputTimer = null;
            }
            this.keySequence = String.valueOf(this.keySequence) + e.getKeyChar();
        }
        if ((maptype = this.getApplicableMapType()) == -1) {
            this.keySequence = "";
            return this.acceptKey(e);
        }
        if (realKeyPress && mappings.isAmbiguousMapCommand(maptype, this.keySequence)) {
            this.waitForMoreInputTimer = new Timer();
            this.waitForMoreInputTimer.schedule((TimerTask)new WaitForMoreInputThread(e), 800L);
            e.consume();
            return true;
        }
        if (mappings.isMapCommand(maptype, this.keySequence)) {
            this.inMapReplay = true;
            String mapCommand = mappings.getMapCommand(maptype, this.keySequence);
            if (mapCommand.startsWith("ECLIPSE:")) {
                ActionUtils.callHandlerAction(mapCommand.substring("ECLIPSE:".length()));
            } else {
                int j = 0;
                while (j < mapCommand.length()) {
                    ViKeyEvent event = new ViKeyEvent(mapCommand.charAt(j), 0, 0);
                    this.acceptKey(event);
                    ++j;
                }
            }
            e.consume();
            this.keySequence = "";
            this.inMapReplay = false;
            return true;
        }
        if (realKeyPress && mappings.isPartialMapCommand(maptype, this.keySequence)) {
            this.waitForMoreInputTimer = new Timer();
            this.waitForMoreInputTimer.schedule((TimerTask)new WaitForMoreInputThread(e), 800L);
            e.consume();
            return true;
        }
        if (this.keySequence.length() == 1) {
            this.keySequence = "";
            if (!realKeyPress) {
                this.inMapReplay = true;
            }
            boolean consumed = this.acceptKey(e);
            this.inMapReplay = false;
            return consumed;
        }
        this.inMapReplay = true;
        int j = 0;
        while (j < this.keySequence.length()) {
            ViKeyEvent event = new ViKeyEvent(this.keySequence.charAt(j), 0, 0);
            this.acceptKey(event);
            ++j;
        }
        this.keySequence = "";
        this.inMapReplay = false;
        return true;
    }

    private int getApplicableMapType() {
        if ((this.layer.isInAnyVisualMode() || this.layer.isInCommandMode()) && !Buffer.getInstance().isMappingUnsuiteable()) {
            return 0;
        }
        if (this.layer.isInInsertMode()) {
            return 1;
        }
        return -1;
    }

    public void register() {
        this.extension.prependVerifyKeyListener((VerifyKeyListener)this);
    }

    public void unregister() {
        this.extension.removeVerifyKeyListener((VerifyKeyListener)this);
    }

    public void verifyKey(VerifyEvent e) {
        ViKeyEvent keyEvent;
        if (e.keyCode == 262144 || e.keyCode == 65536 || e.keyCode == 131072) {
            return;
        }
        if (e.keyCode == 0x1000001) {
            e.keyCode = 38;
            this.layer.resetInsertBufferIfNotInCommandMode();
            this.layer.createUndoCheckpointInInsertOrReplaceMode();
        } else if (e.keyCode == 0x1000002) {
            e.keyCode = 40;
            this.layer.resetInsertBufferIfNotInCommandMode();
            this.layer.createUndoCheckpointInInsertOrReplaceMode();
        } else if (e.keyCode == 0x1000003) {
            e.keyCode = 37;
            this.layer.resetInsertBufferIfNotInCommandMode();
            this.layer.createUndoCheckpointInInsertOrReplaceMode();
        } else if (e.keyCode == 0x1000004) {
            e.keyCode = 39;
            this.layer.resetInsertBufferIfNotInCommandMode();
            this.layer.createUndoCheckpointInInsertOrReplaceMode();
        } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            e.keyCode = 0;
            e.character = (char)10;
        }
        if (e.character == '\'') {
            e.keyCode = 0;
        }
        if (e.keyCode == 0x1000007) {
            e.keyCode = 36;
            this.layer.resetInsertBufferIfNotInCommandMode();
            this.layer.createUndoCheckpointInInsertOrReplaceMode();
        }
        if (e.keyCode == 0x1000008) {
            e.keyCode = 35;
            this.layer.resetInsertBufferIfNotInCommandMode();
            this.layer.createUndoCheckpointInInsertOrReplaceMode();
        }
        if (this.layer.acceptKeyEvent(keyEvent = new ViKeyEvent(e.character, e.keyCode, e.stateMask))) {
            e.doit = false;
        }
    }

    private class WaitForMoreInputThread
    extends TimerTask {
        private ViKeyEvent e;

        public WaitForMoreInputThread(ViKeyEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    KeyVerifier.this.checkMappings(WaitForMoreInputThread.this.e, false);
                }
            });
        }
    }
}

