/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.layer;

import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.util.Line;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import com.mbartl.viplugineclipse.viimplementation.util.ViMode;
import java.util.Vector;

public class SelectionManager {
    private final ViLayer layer;
    private Region selection;
    private Region lastVisualSelection = null;
    private int positiveVisualAnchor;
    private int negativeVisualAnchor;
    private final EditorImplementation editor;

    public SelectionManager(ViLayer layer) {
        this.layer = layer;
        this.editor = layer.getEditor();
        this.setInternalSelection(this.editor.getCaretPosition(), 0);
    }

    public Region getSelection() {
        return this.selection;
    }

    public Vector<Region> getBlockSelections() {
        return this.editor.getBlockSelections();
    }

    public void resetSelection() {
        this.editor.setBlockSelection(false);
        this.selection = new Region(this.editor.getCaretPosition(), 0);
        this.layer.getEditor().setVisualSelection(this.editor.getCaretPosition(), this.editor.getCaretPosition());
    }

    public void activateVisualMode(ViMode mode) {
        int pos = this.editor.getCaretPosition();
        if (mode == ViMode.VISUAL_MODE) {
            this.positiveVisualAnchor = pos;
            this.negativeVisualAnchor = pos + 1;
        } else if (mode == ViMode.VISUAL_LINE_MODE) {
            Line line = this.layer.getDocument().getLineOfOffset(pos);
            this.positiveVisualAnchor = line.getOffset();
            this.negativeVisualAnchor = line.getOffsetEndWithoutDelimiter();
        } else if (mode == ViMode.VISUAL_BLOCK_MODE) {
            this.positiveVisualAnchor = pos;
            this.negativeVisualAnchor = pos + 1;
            this.editor.setBlockSelection(true);
        }
        this.setVisualSelection(this.positiveVisualAnchor, this.negativeVisualAnchor, true);
    }

    public void setVisualSelection(int start, int end, boolean forceRedraw) {
        this.lastVisualSelection = this.selection = Region.normalize(new Region(start, end - start));
        Region oldSelection = this.editor.getVisualSelection();
        if (forceRedraw || this.selection.getLength() < 3 || oldSelection.getOffset() != this.selection.getOffset() || oldSelection.getLength() != this.selection.getLength()) {
            this.layer.getEditor().setVisualSelection(start, end);
        }
    }

    public void setInternalSelection(int start, int length) {
        this.selection = new Region(start, length);
    }

    public void setInternalSelection(Region selection) {
        this.selection = selection;
    }

    public void updateVisualSelection(int caretPosition) {
        int visualAnchor = this.positiveVisualAnchor;
        if (visualAnchor == caretPosition) {
            if (caretPosition > this.lastVisualSelection.getOffset()) {
                this.editor.setCaretPosition(++caretPosition);
            } else {
                this.editor.setCaretPosition(--caretPosition);
            }
        }
        if (caretPosition <= this.positiveVisualAnchor) {
            visualAnchor = this.negativeVisualAnchor;
        }
        if (this.layer.isInVisualCharacterMode() || this.layer.isInVisualBlockMode() || PreferenceService.getInstance().getBoolean("visuallinemodeimproved")) {
            this.setVisualSelection(visualAnchor, caretPosition, false);
        } else if (this.layer.isInVisualLineMode()) {
            if (visualAnchor <= caretPosition) {
                int start = this.layer.getDocument().getLineOfOffset(this.positiveVisualAnchor).getOffset();
                int end = this.layer.getDocument().getLineOfOffset(caretPosition - 1).getOffsetEnd();
                this.setVisualSelection(start, end, false);
            } else {
                int start = this.layer.getDocument().getLineOfOffset(this.positiveVisualAnchor).getOffsetEnd();
                int end = this.layer.getDocument().getLineOfOffset(caretPosition).getOffset();
                this.setVisualSelection(start, end, false);
            }
        }
    }

    public void expandCurrentSelectionToFullLines() {
        this.setInternalSelection(this.expandSelectionToFullLines(this.selection));
    }

    public Region expandSelectionToFullLines(int start, int length) {
        return this.expandSelectionToFullLines(new Region(start, length));
    }

    public Region expandSelectionToFullLines(Region selection) {
        Region normSelection = Region.normalize(selection);
        int startOffset = normSelection.getOffset();
        int endOffset = Math.max(0, normSelection.getOffsetEnd() - 1);
        Line startLine = this.layer.getDocument().getLineOfOffset(startOffset);
        Line endLine = this.layer.getDocument().getLineOfOffset(endOffset);
        return new Region(startLine.getOffset(), endLine.getOffsetEnd() - startLine.getOffset());
    }

    public void selectAll() {
        this.setInternalSelection(0, this.layer.getDocument().getLength());
    }

    public boolean isCurrentSelectionCompleteLines() {
        Line startLine = this.layer.getDocument().getLineOfOffset(this.selection.getOffset());
        Line endLine = this.layer.getDocument().getLineOfOffset(this.selection.getOffsetEnd());
        return startLine.getOffset() == this.selection.getOffset() && endLine.getOffsetEndWithoutDelimiter() == this.selection.getOffsetEnd();
    }

    public void activateLastVisualSelection() {
        if (this.lastVisualSelection != null) {
            this.positiveVisualAnchor = this.lastVisualSelection.getOffset();
            this.negativeVisualAnchor = this.lastVisualSelection.getOffset() + 1;
            this.setVisualSelection(this.lastVisualSelection.getOffset(), this.lastVisualSelection.getOffsetEnd(), true);
        }
    }
}

