/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.layer;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Caret;

public class ViCaret {
    private final StyledText textWidget;
    private final Point originalSize;

    public ViCaret(StyledText textWidget) {
        Caret caret = textWidget.getCaret();
        this.originalSize = caret.getSize();
        caret.setImage(null);
        this.textWidget = textWidget;
    }

    private void setCaretWidth(int width) {
        if (!this.textWidget.isDisposed() && !this.textWidget.getCaret().isDisposed()) {
            this.textWidget.getCaret().setSize(width, this.textWidget.getCaret().getSize().y);
        }
    }

    public void setInsertMode() {
        this.setCaretWidth(2);
    }

    public void setCommandMode() {
        if (!this.textWidget.isDisposed() && !this.textWidget.getCaret().isDisposed()) {
            GC gc = new GC((Drawable)this.textWidget);
            this.setCaretWidth(gc.getFontMetrics().getAverageCharWidth());
            gc.dispose();
        }
    }

    public void restoreOriginalCaret() {
        if (!this.textWidget.isDisposed() && !this.textWidget.getCaret().isDisposed()) {
            this.textWidget.getCaret().setSize(this.originalSize);
        }
    }

    public void setVisualMode() {
        this.setCaretWidth(1);
    }
}

