/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.layer;

import com.mbartl.viplugineclipse.Buffer;
import com.mbartl.viplugineclipse.BufferEvaluator;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.util.ViKeyEvent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class ViCommandLine {
    private final TextModificationListener modifyListener = new TextModificationListener();
    private final TextTraverseListener traverseListener = new TextTraverseListener();
    private final TextKeyAdapter keyAdapter = new TextKeyAdapter();
    private final FontChangeListener fontChangeListener = new FontChangeListener();
    private volatile boolean isEnabled;
    private final Composite parent;
    private Composite container;
    private Text commandText;
    private Text modeText;
    private String lastCommand = "";
    private int insertPosition = 0;

    public ViCommandLine(Composite parent) {
        this.parent = parent;
        this.isEnabled = false;
    }

    public void setMessage(String message) {
        if (!this.isEnabled) {
            return;
        }
        this.commandText.removeModifyListener((ModifyListener)this.modifyListener);
        this.commandText.setText(message);
        if (message.startsWith(":") || message.startsWith("/") || message.startsWith("?")) {
            this.commandText.setEnabled(true);
            this.commandText.setFocus();
            this.commandText.setSelection(this.commandText.getText().length());
            this.commandText.addModifyListener((ModifyListener)this.modifyListener);
        } else {
            this.commandText.setEnabled(false);
        }
    }

    public void setMode(String mode) {
        if (!this.isEnabled) {
            return;
        }
        this.modeText.setText(mode);
        this.modeText.getParent().layout();
    }

    void sendCommand(String command) {
        int i = 0;
        while (i < command.length()) {
            this.sendCommand(command.charAt(i));
            ++i;
        }
        this.commandText.setSelection(this.insertPosition);
    }

    void sendCommand(char command) {
        ViKeyEvent e = new ViKeyEvent(command, 0, 0);
        ViLayer layer = ViLayerManager.getInstance().getCurrentLayer();
        layer.acceptKeyEvent(e);
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled == enabled) {
            return;
        }
        this.isEnabled = enabled;
        if (enabled) {
            Control[] children;
            if (this.parent != null && !this.parent.isDisposed() && (children = this.parent.getChildren()) != null) {
                GridLayout gl = new GridLayout(1, true);
                gl.verticalSpacing = 0;
                gl.horizontalSpacing = 0;
                gl.marginHeight = 0;
                gl.marginWidth = 0;
                this.parent.setLayout((Layout)gl);
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.setLayoutData((Object)new GridData(4, 4, true, true));
                    ++n2;
                }
                this.container = new Composite(this.parent, 0);
                this.container.setLayoutData((Object)new GridData(4, 4, true, false));
                gl = new GridLayout(2, false);
                gl.verticalSpacing = 0;
                gl.horizontalSpacing = 5;
                gl.marginHeight = 5;
                gl.marginWidth = 12;
                this.container.setLayout((Layout)gl);
                this.commandText = new Text(this.container, 2052);
                this.commandText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                this.commandText.setFont(JFaceResources.getTextFont());
                this.commandText.addTraverseListener((TraverseListener)this.traverseListener);
                this.commandText.addKeyListener((KeyListener)this.keyAdapter);
                this.commandText.addModifyListener((ModifyListener)this.modifyListener);
                this.commandText.setEnabled(false);
                this.commandText.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                this.modeText = new Text(this.container, 16779276);
                this.modeText.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
                this.modeText.setFont(JFaceResources.getTextFont());
                this.modeText.setText(" -- COMMAND -- ");
                this.modeText.setEnabled(true);
                JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fontChangeListener);
                this.parent.layout();
                this.commandText.addListener(9, new Listener(){

                    public void handleEvent(Event event) {
                        if (!ViCommandLine.this.commandText.isEnabled() && ViCommandLine.this.commandText.getText().startsWith("Pattern not found")) {
                            GC gc = event.gc;
                            String text = ViCommandLine.this.commandText.getText();
                            Rectangle bounds = ViCommandLine.this.commandText.getBounds();
                            gc.setBackground(Display.getDefault().getSystemColor(34));
                            gc.setForeground(DVTColorUtil.INSTANCE.getColor(255, 0, 0));
                            gc.fillRectangle(0, 0, bounds.width, bounds.height);
                            gc.drawText(text, 0, 0);
                        }
                    }
                });
            }
        } else {
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fontChangeListener);
            if (this.container != null) {
                this.container.dispose();
                if (!this.parent.isDisposed()) {
                    this.parent.layout();
                }
            }
            this.commandText = null;
            this.modeText = null;
            this.container = null;
        }
    }

    private class FontChangeListener
    implements IPropertyChangeListener {
        private FontChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.jface.textfont")) {
                Font font = JFaceResources.getTextFont();
                ViCommandLine.this.commandText.setFont(font);
                ViCommandLine.this.modeText.setFont(font);
                ViCommandLine.this.parent.layout();
            }
        }
    }

    private class TextKeyAdapter
    extends KeyAdapter {
        private TextKeyAdapter() {
        }

        public void keyPressed(KeyEvent event) {
            if (!ViCommandLine.this.commandText.isFocusControl()) {
                return;
            }
            String command = ViCommandLine.this.commandText.getText();
            if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                if (command.startsWith(":")) {
                    Buffer.getInstance().setCommand("");
                    ViCommandLine.this.sendCommand(String.valueOf(command) + "\n");
                } else {
                    ViCommandLine.this.sendCommand("\n");
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
            } else if (event.keyCode == 0x1000001) {
                ViCommandLine.this.sendCommand("<CU>");
                event.doit = false;
            } else if (event.keyCode == 0x1000002) {
                ViCommandLine.this.sendCommand("<CD>");
                event.doit = false;
            } else if (event.keyCode == 9) {
                ViCommandLine.this.commandText.insert("<TAB>");
            } else if (event.keyCode == 27) {
                ViCommandLine.this.sendCommand((char)event.keyCode);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
            }
        }
    }

    private class TextModificationListener
    implements ModifyListener {
        private TextModificationListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            ViCommandLine.this.insertPosition = text.getCaretPosition();
            String command = text.getText();
            if (text.isFocusControl()) {
                if (command.length() == 0) {
                    ViCommandLine.this.sendCommand('\u001b');
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
                } else if (command.startsWith("/") || command.startsWith("?")) {
                    if (command.length() == ViCommandLine.this.lastCommand.length() + 1 && ViCommandLine.this.lastCommand.equals(command.substring(0, command.length() - 1))) {
                        BufferEvaluator.getInstance().appendAndEval(command.substring(command.length() - 1));
                    } else if (command.length() == ViCommandLine.this.lastCommand.length() - 1 && command.equals(ViCommandLine.this.lastCommand.substring(0, ViCommandLine.this.lastCommand.length() - 1))) {
                        BufferEvaluator.getInstance().backspacePressed();
                        BufferEvaluator.getInstance().eval();
                    } else {
                        Buffer.getInstance().setCommand(command.substring(0, 1));
                        if (command.length() > 1) {
                            ViCommandLine.this.sendCommand(text.getText().substring(1));
                        }
                    }
                }
            }
            ViCommandLine.this.lastCommand = command;
        }
    }

    private class TextTraverseListener
    implements TraverseListener {
        private TextTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            switch (e.detail) {
                case 8: 
                case 16: {
                    e.doit = false;
                }
            }
        }
    }
}

