/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.layer;

import com.mbartl.viplugineclipse.BookMarkHandler;
import com.mbartl.viplugineclipse.Buffer;
import com.mbartl.viplugineclipse.BufferEvaluator;
import com.mbartl.viplugineclipse.DocumentAdapter;
import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.utils.MessageDialogUtils;
import com.mbartl.viplugineclipse.viimplementation.interfaces.IUndoManager;
import com.mbartl.viplugineclipse.viimplementation.layer.CursorInLinePosition;
import com.mbartl.viplugineclipse.viimplementation.layer.KeyVerifier;
import com.mbartl.viplugineclipse.viimplementation.layer.LayerInformation;
import com.mbartl.viplugineclipse.viimplementation.layer.SelectionManager;
import com.mbartl.viplugineclipse.viimplementation.layer.ViCaret;
import com.mbartl.viplugineclipse.viimplementation.util.ViKeyEvent;
import com.mbartl.viplugineclipse.viimplementation.util.ViMode;
import com.mbartl.viplugineclipse.viimplementation.util.WordSeparatorUtils;

public class ViLayer {
    private ViMode mode;
    private KeyVerifier keyListener = null;
    private final ViCaret caret;
    private final LayerInformation layerInformation;
    private final SelectionManager selectionManager;
    private final IUndoManager undoManager;
    private static long lastPopupTime = System.currentTimeMillis();
    private final CursorInLinePosition cursorInLinePosition;
    private final WordSeparatorUtils wordSeparatorUtils;
    private boolean suppressNextStatusLineMessage;

    public ViLayer(LayerInformation info) {
        this.layerInformation = info;
        this.mode = ViMode.COMMAND_MODE;
        this.selectionManager = new SelectionManager(this);
        this.undoManager = info.getUndoManager();
        this.caret = info.getCaret();
        this.cursorInLinePosition = new CursorInLinePosition(this.getEditor(), this.layerInformation.getDocument());
        String separators = PreferenceService.getInstance().getString("wordseparators");
        this.wordSeparatorUtils = new WordSeparatorUtils(separators);
        this.switchToCommandMode();
    }

    public void setStatusLine() {
        if (this.suppressNextStatusLineMessage) {
            this.suppressNextStatusLineMessage = false;
            return;
        }
        String message = "";
        String modeString = " -- COMMAND -- ";
        if (this.mode == ViMode.COMMAND_MODE) {
            message = Buffer.getInstance().getCommand();
        } else if (this.mode == ViMode.INSERT_MODE) {
            modeString = " -- INSERT -- ";
        } else if (this.mode == ViMode.VISUAL_MODE) {
            modeString = " -- VISUAL -- ";
            message = Buffer.getInstance().getCommand();
        } else if (this.mode == ViMode.VISUAL_LINE_MODE) {
            modeString = " -- VISUAL LINE -- ";
            message = Buffer.getInstance().getCommand();
        } else if (this.mode == ViMode.REPLACE_MODE) {
            modeString = " -- REPLACE -- ";
        }
        this.layerInformation.getStatusLineManager().setMode(modeString);
        this.layerInformation.getStatusLineManager().setMessage(message);
    }

    public void setCommandBufferStatusMessage(String message) {
        this.layerInformation.getStatusLineManager().setMessage(message);
        this.suppressNextStatusLineMessage = true;
    }

    public void switchToCommandMode() {
        this.mode = ViMode.COMMAND_MODE;
        this.undoManager.endCompoundChange();
        BufferEvaluator.getInstance().clear();
        this.selectionManager.resetSelection();
        this.setCaret();
    }

    public void switchToInsertMode() {
        this.getEditor().resetHighlighting();
        this.mode = ViMode.INSERT_MODE;
        Buffer.getInstance().setCommand("");
        this.undoManager.beginCompoundChange();
        Buffer.getInstance().setInsertBuffer(new StringBuffer(100));
        this.setCaret();
    }

    public void switchToReplaceMode() {
        this.getEditor().resetHighlighting();
        this.mode = ViMode.REPLACE_MODE;
        Buffer.getInstance().setCommand("");
        this.undoManager.beginCompoundChange();
        Buffer.getInstance().setInsertBuffer(new StringBuffer(100));
        this.setCaret();
    }

    public void switchToVisualMode(ViMode mode) {
        this.mode = mode;
        if (this.isInVisualLineMode() && PreferenceService.getInstance().getBoolean("visuallinemodeimproved")) {
            this.selectionManager.activateVisualMode(ViMode.VISUAL_MODE);
        } else {
            this.selectionManager.activateVisualMode(this.mode);
        }
        Buffer.getInstance().setCommand("");
        this.undoManager.beginCompoundChange();
        this.setCaret();
    }

    public void switchToVisualModeWithLastSelection(ViMode mode) {
        this.mode = mode;
        this.selectionManager.activateLastVisualSelection();
        Buffer.getInstance().setCommand("");
        this.undoManager.beginCompoundChange();
        this.setCaret();
    }

    public void unLoad() {
        if (PreferenceService.getInstance().getBoolean("vimcursor")) {
            this.caret.restoreOriginalCaret();
        }
        this.keyListener.unregister();
        this.layerInformation.getDocument().unregister();
    }

    public boolean isInInsertMode() {
        return this.mode == ViMode.INSERT_MODE;
    }

    public boolean isInAnyVisualMode() {
        return this.mode == ViMode.VISUAL_MODE || this.mode == ViMode.VISUAL_LINE_MODE || this.mode == ViMode.VISUAL_BLOCK_MODE;
    }

    public boolean isInVisualCharacterMode() {
        return this.mode == ViMode.VISUAL_MODE;
    }

    public boolean isInVisualBlockMode() {
        return this.mode == ViMode.VISUAL_BLOCK_MODE;
    }

    public boolean isInVisualLineMode() {
        return this.mode == ViMode.VISUAL_LINE_MODE;
    }

    public boolean isInCommandMode() {
        return this.mode == ViMode.COMMAND_MODE;
    }

    public boolean isInReplaceMode() {
        return this.mode == ViMode.REPLACE_MODE;
    }

    public void toggleVisualMode() {
        if (this.isInAnyVisualMode()) {
            this.switchToCommandMode();
        } else {
            this.switchToVisualMode(ViMode.VISUAL_MODE);
        }
    }

    public void toggleVisualLineMode() {
        if (this.isInVisualLineMode()) {
            this.switchToCommandMode();
        } else {
            this.switchToVisualMode(ViMode.VISUAL_LINE_MODE);
        }
    }

    public void resetInsertBufferIfNotInCommandMode() {
        if (this.isInInsertMode() || this.isInReplaceMode()) {
            Buffer.getInstance().setInsertBuffer(new StringBuffer(100));
        }
    }

    public EditorImplementation getEditor() {
        return this.layerInformation.getEditor();
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public DocumentAdapter getDocument() {
        return this.layerInformation.getDocument();
    }

    public boolean acceptKeyEvent(ViKeyEvent e) {
        long time;
        if (!ViLayerManager.getInstance().isFullVersion() && (time = System.currentTimeMillis()) - lastPopupTime > 300000L) {
            lastPopupTime = time;
            MessageDialogUtils.showDialog("No License available for ViPlugin", "ViPlugin for DVT is available only when a DVT project (e, SystemVerilog, VHDL) is opened!");
        }
        return this.keyListener.checkMappings(e, true);
    }

    public void setKeyListener(KeyVerifier keyListener) {
        this.keyListener = keyListener;
        this.keyListener.register();
    }

    public BookMarkHandler getBookmarkHandler() {
        return this.layerInformation.getBookmark();
    }

    public IUndoManager getUndoManager() {
        return this.undoManager;
    }

    public CursorInLinePosition getCursorInLinePosition() {
        return this.cursorInLinePosition;
    }

    public WordSeparatorUtils getWordSeparatorUtils() {
        return this.wordSeparatorUtils;
    }

    public ViMode getMode() {
        return this.mode;
    }

    public void toggleVisualBlockMode() {
        if (this.isInVisualBlockMode()) {
            this.switchToCommandMode();
        } else {
            this.switchToVisualMode(ViMode.VISUAL_BLOCK_MODE);
        }
    }

    public void setCaret() {
        if (PreferenceService.getInstance().getBoolean("vimcursor")) {
            if (this.isInAnyVisualMode()) {
                this.caret.setVisualMode();
            } else if (this.isInCommandMode()) {
                this.caret.setCommandMode();
            } else if (this.isInInsertMode() || this.isInReplaceMode()) {
                this.caret.setInsertMode();
            }
        }
    }

    public void createUndoCheckpointInInsertOrReplaceMode() {
        if (this.isInInsertMode() || this.isInReplaceMode()) {
            this.getUndoManager().endCompoundChange();
        }
    }
}

