/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.layer;

import com.mbartl.viplugineclipse.viimplementation.layer.ViCommandLine;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ViStatusLineManager {
    private static final HashMap<Composite, ViCommandLine> editorCommandLineMap = new HashMap();
    private static volatile boolean isEnabled = false;
    private static final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget == null) {
                return;
            }
            ViCommandLine commandLine = editorCommandLineMap.remove(e.widget);
            if (commandLine == null) {
                return;
            }
            commandLine.setEnabled(false);
        }
    };
    private final ViCommandLine commandLine;

    public static void setEnabled(boolean enabled) {
        isEnabled = enabled;
        for (Map.Entry<Composite, ViCommandLine> entry : editorCommandLineMap.entrySet()) {
            entry.getValue().setEnabled(enabled);
        }
    }

    public ViStatusLineManager(ITextEditor editor) {
        this.commandLine = this.createViCommandLine(editor);
        if (isEnabled) {
            this.commandLine.setEnabled(true);
        }
    }

    private ViCommandLine createViCommandLine(ITextEditor editor) {
        ViCommandLine commandLine = null;
        if (editor != null && editor instanceof AbstractTextEditor) {
            try {
                ITextViewer textViewer;
                StyledText widget;
                Composite parent;
                Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                getSourceViewerMethod.setAccessible(true);
                Object viewer = getSourceViewerMethod.invoke((Object)editor, new Object[0]);
                if (viewer != null && (parent = (widget = (textViewer = (ITextViewer)viewer).getTextWidget()).getParent()) != null && (parent = parent.getParent()) != null && (commandLine = editorCommandLineMap.get(parent)) == null) {
                    parent.addDisposeListener(disposeListener);
                    commandLine = new ViCommandLine(parent);
                    editorCommandLineMap.put(parent, commandLine);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return commandLine;
    }

    public void setMessage(String message) {
        if (isEnabled) {
            this.commandLine.setMessage(message);
        }
    }

    public void setMode(String mode) {
        if (isEnabled) {
            this.commandLine.setMode(mode);
        }
    }
}

