/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.parser;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.util.WordSeparatorUtils;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Abbreviations
implements IPropertyChangeListener {
    private static Abbreviations instance = null;
    private final HashMap<String, String> abbreviations = new HashMap();
    private boolean ignorePropertyChange = false;
    private boolean hasWordBoundaryAbbreviations = false;

    public static Abbreviations getInstance() {
        if (instance == null) {
            instance = new Abbreviations();
            instance.loadPreferences();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.addPropertyChangeListener((IPropertyChangeListener)instance);
        }
        return instance;
    }

    public void clear() {
        this.abbreviations.clear();
    }

    private void loadPreferences() {
        this.clear();
        String preference = PreferenceService.getInstance().getString("abbreviations");
        String[] stringArray = preference.split("\ufffd\ufffd");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String abbreviation = stringArray[n2];
            instance.setAbbreviation(abbreviation);
            ++n2;
        }
        this.computeHasWordBoundaryAbbreviations();
    }

    private void savePreferences() {
        this.ignorePropertyChange = true;
        String str = "";
        for (String key : this.abbreviations.keySet()) {
            str = String.valueOf(str) + key + " " + this.abbreviations.get(key) + "\ufffd\ufffd";
        }
        PreferenceService.getInstance().setString("abbreviations", str);
        this.ignorePropertyChange = false;
        this.computeHasWordBoundaryAbbreviations();
    }

    private void setAbbreviation(String abbreviation) {
        String filteredCommand = this.filterCommand(abbreviation);
        String[] split = filteredCommand.split(" ", 2);
        if (split.length == 2) {
            this.abbreviations.put(split[0], split[1]);
        }
    }

    public String filterCommand(String command) {
        String ESCAPE = String.valueOf('\u001b');
        String ENTER = String.valueOf('\n');
        command = command.replaceAll("<ESC>", ESCAPE);
        command = command.replaceAll("<ENTER>", ENTER);
        command = command.replaceAll("<CR>", ENTER);
        return command;
    }

    public String unfilterCommand(String command) {
        String ESCAPE = String.valueOf('\u001b');
        String ENTER = String.valueOf('\n');
        command = command.replaceAll(ESCAPE, "<ESC>");
        command = command.replaceAll(ENTER, "<ENTER>");
        return command;
    }

    public String isAbbreviation(String keySequence) {
        for (String key : this.abbreviations.keySet()) {
            if (!keySequence.endsWith(key) || Character.isJavaIdentifierPart(keySequence.charAt(keySequence.length() - key.length() - 1))) continue;
            String abbreviation = this.abbreviations.get(key);
            if (abbreviation != null && abbreviation.startsWith("\\W")) {
                int charBeforeKeyIndex = keySequence.length() - key.length() - 1;
                if (charBeforeKeyIndex >= 0) {
                    char charBeforeKey = keySequence.charAt(keySequence.length() - key.length() - 1);
                    if (!this.isWordBoundaryChar(charBeforeKey)) continue;
                    return key;
                }
                return key;
            }
            return key;
        }
        return null;
    }

    public String getAbbreviation(String key) {
        String abbreviation = this.abbreviations.get(key);
        if (abbreviation != null && abbreviation.startsWith("\\W")) {
            return abbreviation.substring(2);
        }
        return abbreviation;
    }

    public void addAbbreviation(String command) {
        this.setAbbreviation(command);
        this.savePreferences();
    }

    public void removeAbbreviation(String command) {
        this.abbreviations.remove(command);
        this.savePreferences();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!this.ignorePropertyChange) {
            this.loadPreferences();
        }
    }

    private void computeHasWordBoundaryAbbreviations() {
        if (this.abbreviations == null) {
            this.hasWordBoundaryAbbreviations = false;
        }
        for (String abbreviation : this.abbreviations.values()) {
            if (abbreviation == null || !abbreviation.startsWith("\\W")) continue;
            this.hasWordBoundaryAbbreviations = true;
            return;
        }
    }

    public boolean hasWordBoundaryAbbreviations() {
        return this.hasWordBoundaryAbbreviations;
    }

    public boolean isWordBoundaryChar(char ch) {
        return !WordSeparatorUtils.isWordCharacter(ch);
    }
}

