/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.parser;

import com.mbartl.viplugineclipse.viimplementation.parser.ParsedCommand;

public class CommandProperties {
    private static final String[] DELETECOMMANDS = new String[]{"c", "C", "d", "D", "S", "x", "X"};
    private static final String[] SIMPLEINSERTMODECOMMANDS = new String[]{"i", "I", "a", "A", "o", "O"};
    private static final String[] INSERTMODECOMMANDS = new String[]{"i", "I", "a", "A", "c", "C", "o", "O", "s", "S"};
    private static final String[] SHIFTCOMMANDS = new String[]{"<", ">"};
    private static final String[] INDENTCOMMANDS = new String[]{"="};
    private static final String[] YANKCOMMANDS = new String[]{"y", "Y"};
    private static final String[] CHANGECASECOMMANDS = new String[]{"~", "gu", "gU", "g~"};

    private static boolean isCommandOfType(String command, String[] type) {
        int i = 0;
        while (i < type.length) {
            if (command.startsWith(type[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void setCommandProperties(ParsedCommand pc) {
        pc.setIsDeleteCommand(CommandProperties.isCommandOfType(pc.getOperation(), DELETECOMMANDS));
        pc.setIsSimpleInsertModeCommand(CommandProperties.isCommandOfType(pc.getOperation(), SIMPLEINSERTMODECOMMANDS));
        pc.setIsInsertModeCommand(CommandProperties.isCommandOfType(pc.getOperation(), INSERTMODECOMMANDS));
        pc.setIsIndentCommand(CommandProperties.isCommandOfType(pc.getOperation(), INDENTCOMMANDS));
        pc.setIsShiftCommand(CommandProperties.isCommandOfType(pc.getOperation(), SHIFTCOMMANDS));
        pc.setIsYankCommand(CommandProperties.isCommandOfType(pc.getOperation(), YANKCOMMANDS));
        pc.setIsChangeCaseCommand(CommandProperties.isCommandOfType(pc.getOperation(), CHANGECASECOMMANDS));
    }
}

