/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.parser;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Mappings
implements IPropertyChangeListener {
    private static Mappings instance = null;
    private final HashMap<String, String> mapCommands = new HashMap();
    private final HashMap<String, String> imapCommands = new HashMap();
    private boolean ignorePropertyChange = false;
    public static final int MAP = 0;
    public static final int IMAP = 1;

    public static Mappings getInstance() {
        if (instance == null) {
            instance = new Mappings();
            instance.loadPreferences();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.addPropertyChangeListener((IPropertyChangeListener)instance);
        }
        return instance;
    }

    public void clear() {
        this.mapCommands.clear();
        this.imapCommands.clear();
    }

    private void loadPreferences() {
        String[] imapCommands;
        String[] mapCommands;
        this.clear();
        String preference = PreferenceService.getInstance().getString("map");
        String[] stringArray = mapCommands = preference.split("\ufffd\ufffd");
        int n = mapCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String mapping = stringArray[n2];
            instance.setMapping(0, mapping);
            ++n2;
        }
        preference = PreferenceService.getInstance().getString("imap");
        String[] stringArray2 = imapCommands = PreferenceService.getInstance().getString("imap").split("\ufffd\ufffd");
        int n3 = imapCommands.length;
        n = 0;
        while (n < n3) {
            String mapping = stringArray2[n];
            instance.setMapping(1, mapping);
            ++n;
        }
    }

    private void savePreferences() {
        this.ignorePropertyChange = true;
        String mapString = "";
        for (String key : this.mapCommands.keySet()) {
            mapString = String.valueOf(mapString) + key + " " + this.mapCommands.get(key) + "\ufffd\ufffd";
        }
        PreferenceService.getInstance().setString("map", mapString);
        mapString = "";
        for (String key : this.imapCommands.keySet()) {
            mapString = String.valueOf(mapString) + key + " " + this.imapCommands.get(key) + "\ufffd\ufffd";
        }
        PreferenceService.getInstance().setString("imap", mapString);
        this.ignorePropertyChange = false;
    }

    private void setMapping(int type, String mapCommand) {
        String filteredCommand = this.filterCommand(mapCommand);
        String[] split = filteredCommand.split(" ", 2);
        if (split.length == 2) {
            if (type == 0) {
                this.mapCommands.put(split[0], split[1]);
            } else {
                this.imapCommands.put(split[0], split[1]);
            }
        }
    }

    public String filterCommand(String command) {
        String ESCAPE = String.valueOf('\u001b');
        String ENTER = String.valueOf('\n');
        String TAB = String.valueOf('\t');
        command = command.replaceAll("<ESC>", ESCAPE);
        command = command.replaceAll("<ENTER>", ENTER);
        command = command.replaceAll("<CR>", ENTER);
        command = command.replaceAll("<TAB>", TAB);
        return command;
    }

    public String unfilterCommand(String command) {
        String ESCAPE = String.valueOf('\u001b');
        String ENTER = String.valueOf('\n');
        String TAB = String.valueOf('\t');
        command = command.replaceAll(ESCAPE, "<ESC>");
        command = command.replaceAll(ENTER, "<ENTER>");
        command = command.replaceAll(TAB, "<TAB>");
        return command;
    }

    public boolean isMapCommand(int maptype, String keySequence) {
        if (keySequence.length() > 1 && keySequence.endsWith(" ")) {
            keySequence = keySequence.substring(0, keySequence.length() - 1);
        }
        return this.getMapCommand(maptype, keySequence) != null;
    }

    public String getMapCommand(int maptype, String key) {
        HashMap<String, String> map = this.mapCommands;
        if (maptype == 1) {
            map = this.imapCommands;
        }
        if (key.length() > 1 && key.endsWith(" ")) {
            key = key.substring(0, key.length() - 1);
        }
        return map.get(key);
    }

    public boolean isPartialMapCommand(int maptype, String keySequence) {
        HashMap<String, String> map = this.mapCommands;
        if (maptype == 1) {
            map = this.imapCommands;
        }
        for (String key : map.keySet()) {
            if (!key.startsWith(keySequence) || key.equals(keySequence)) continue;
            return true;
        }
        return false;
    }

    public void addMapCommand(int maptype, String command) {
        this.setMapping(maptype, command);
        this.savePreferences();
    }

    public void removeMapCommand(int type, String command) {
        if (type == 0) {
            this.mapCommands.remove(command);
        } else {
            this.imapCommands.remove(command);
        }
        this.savePreferences();
    }

    public boolean isAmbiguousMapCommand(int maptype, String keySequence) {
        return this.getMapCommand(maptype, keySequence) != null && this.isPartialMapCommand(maptype, keySequence);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!this.ignorePropertyChange) {
            this.loadPreferences();
        }
    }
}

