/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.registers;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.registers.TextBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.startup.core.DVTLogger;

public class YankBufferHandler {
    private final Map<String, TextBuffer> registers = new HashMap<String, TextBuffer>();
    private String currentKey = "1";
    private final String ALL_KEYS = "123456789abcdefghijklmnopqrstuvwxyz*_+";
    private static YankBufferHandler instance = null;

    public static YankBufferHandler getInstance() {
        if (instance == null) {
            instance = new YankBufferHandler();
            instance.createBuffers();
            instance.loadRegistersFromPreferences();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveRegistersToPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        Base64.Encoder encoder = Base64.getEncoder();
        int i = 0;
        while (true) {
            block18: {
                if (i >= "123456789abcdefghijklmnopqrstuvwxyz*_+".length()) {
                    return;
                }
                String key = "123456789abcdefghijklmnopqrstuvwxyz*_+".substring(i, i + 1);
                TextBuffer register = this.registers.get(key);
                if (register != null) {
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            try {
                                try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                                    oos.writeObject(register);
                                    preferenceStore.putValue("REGISTER_" + key, encoder.encodeToString(bos.toByteArray()));
                                }
                                if (bos == null) break block18;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bos == null) throw throwable;
                                bos.close();
                                throw throwable;
                            }
                            bos.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public void loadRegistersFromPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        Base64.Decoder decoder = Base64.getDecoder();
        int i = 0;
        while (i < "123456789abcdefghijklmnopqrstuvwxyz*_+".length()) {
            String key = "123456789abcdefghijklmnopqrstuvwxyz*_+".substring(i, i + 1);
            String value = preferenceStore.getString("REGISTER_" + key);
            if (!value.isEmpty()) {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decoder.decode(value)));){
                        this.registers.put(key, (TextBuffer)ois.readObject());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    preferenceStore.putValue("REGISTER_" + key, "");
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    public TextBuffer getBuffer(String key) {
        boolean copytoclipboard = PreferenceService.getInstance().getBoolean("copytoclipboard");
        if (key.equals("*") || key.equals("+") || copytoclipboard && key.equals("1")) {
            ViLayer layer = ViLayerManager.getInstance().getCurrentLayer();
            String clipboardContent = layer.getEditor().getClipboardContent();
            if (clipboardContent == null) {
                return this.registers.get("1");
            }
            TextBuffer textBuffer = this.registers.get(key);
            textBuffer.fill(clipboardContent, layer.getDocument().get());
        }
        return this.registers.get(key);
    }

    public void setCurrentKey(String key) {
        this.currentKey = key;
    }

    public TextBuffer getCurrentBuffer() {
        return this.getBuffer(this.currentKey);
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    private void createBuffers() {
        int i = 0;
        while (i < "123456789abcdefghijklmnopqrstuvwxyz*_+".length()) {
            this.registers.put(String.valueOf("123456789abcdefghijklmnopqrstuvwxyz*_+".charAt(i)), new TextBuffer());
            ++i;
        }
    }

    public String getRegisters() {
        String message = "Registers:\n";
        for (String key : this.registers.keySet()) {
            String text;
            TextBuffer buffer = this.registers.get(key);
            if (buffer == null || (text = buffer.getText()).length() <= 0) continue;
            message = String.valueOf(message) + key + ": " + text + "\n";
        }
        return message;
    }

    public void rotateCutBuffers() {
        int i = 9;
        while (i > 0) {
            TextBuffer buffer = this.registers.get("" + (i - 1));
            if (buffer != null) {
                this.registers.put("" + i, new TextBuffer(buffer.getText(), buffer.getFullLines()));
            }
            --i;
        }
    }
}

