/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.search;

import com.mbartl.viplugineclipse.DocumentAdapter;
import com.mbartl.viplugineclipse.ViLayerManager;
import com.mbartl.viplugineclipse.viimplementation.layer.ViLayer;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.search.SearchFactory;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import java.util.Vector;

public class GetOccurences {
    public static Vector<Region> getAll(String text, String match, boolean global, Search.CaseSensitive caseSensitive) {
        Region startingSelection = new Region(0, text.length());
        return GetOccurences.get(text, startingSelection, match, global, caseSensitive);
    }

    public static Vector<Region> getInSelection(String text, String match, Region region, boolean global, Search.CaseSensitive caseInSensitive) {
        return GetOccurences.get(text, region, match, global, caseInSensitive);
    }

    private static Vector<Region> get(String text, Region startingSelection, String match, boolean global, Search.CaseSensitive caseInSensitive) {
        ViLayer viLayer = ViLayerManager.getInstance().getCurrentLayer();
        DocumentAdapter analyzer = viLayer.getDocument();
        Search search = SearchFactory.getNewRegExpSearch();
        int lastLineNr = -1;
        Vector<Integer> locations = new Vector<Integer>();
        Vector<Region> occurences = new Vector<Region>();
        long timestamp = System.currentTimeMillis();
        Region result = search.search(text, match, Search.Direction.FORWARD, startingSelection.getOffset() - 1, caseInSensitive, timestamp);
        while (result != null) {
            int foundOffset = result.getOffset();
            if (GetOccurences.isLocationPassed(locations, foundOffset)) break;
            locations.add(new Integer(foundOffset));
            if (foundOffset >= startingSelection.getOffset() && foundOffset <= startingSelection.getOffset() + startingSelection.getLength() - 1) {
                int lineNr = analyzer.getLinePosOfOffset(result.getOffset());
                if ((global || lastLineNr != lineNr) && !GetOccurences.isSubSelection(occurences, result)) {
                    occurences.add(result);
                    lastLineNr = lineNr;
                }
            }
            if (foundOffset > startingSelection.getOffset() + startingSelection.getLength()) break;
            result = search.searchNext(text, result.getOffset(), caseInSensitive, timestamp);
        }
        return occurences;
    }

    private static boolean isLocationPassed(Vector<Integer> locations, int foundOffset) {
        int i = 0;
        while (i < locations.size()) {
            Integer loc = locations.get(i);
            if (loc == foundOffset) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSubSelection(Vector<Region> occurences, Region selection) {
        int i = 0;
        while (i < occurences.size()) {
            Region region = occurences.get(i);
            int startPos = selection.getOffset();
            if (region.getOffset() <= startPos && selection.getOffset() <= region.getOffsetEnd() - 1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

