/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.search;

import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.search.SimpleSearch;
import com.mbartl.viplugineclipse.viimplementation.util.Region;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExSearch
extends Search {
    private long cachedTimestamp;
    private Pattern cachedPattern;
    private String cachedRegexText;

    @Override
    public Region search(String text, String regex, Search.Direction direction, Search.Mode mode, int startPos, Search.CaseSensitive caseSensitive, long timestamp) {
        Matcher matcher;
        if (regex == null || regex.length() == 0) {
            return null;
        }
        try {
            Pattern pattern;
            if (this.cachedTimestamp == timestamp && this.cachedRegexText != null && this.cachedRegexText.equals(regex)) {
                if (this.cachedPattern == null) {
                    throw new PatternSyntaxException("", regex, 0);
                }
                pattern = this.cachedPattern;
            } else {
                String regexCustom = regex.replace("\\|", "|");
                int i = regex.length() - 1;
                while (i >= 0) {
                    char ch = regex.charAt(i);
                    if (!Character.isWhitespace(ch)) {
                        if (ch != '|') break;
                        regexCustom = regex.substring(0, i);
                        break;
                    }
                    --i;
                }
                if (regexCustom.trim().isEmpty()) {
                    throw new PatternSyntaxException("", regex, 0);
                }
                pattern = Pattern.compile(regexCustom, this.getFlags(regexCustom, caseSensitive));
                this.cachedTimestamp = timestamp;
                this.cachedPattern = pattern;
                this.cachedRegexText = regex;
            }
            matcher = pattern.matcher(text);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            SimpleSearch search = new SimpleSearch();
            return search.search(text, regex, direction, mode, startPos, caseSensitive, timestamp);
        }
        int pos = startPos;
        if (direction == Search.Direction.FORWARD) {
            if (mode == Search.Mode.NEW || mode == Search.Mode.NEXT) {
                if (++pos > text.length() - 1) {
                    pos = 0;
                }
                return this.searchForward(matcher, text, pos);
            }
            if (--pos < 0) {
                pos = text.length() - 1;
            }
            return this.searchBackward(matcher, text, pos);
        }
        if (mode == Search.Mode.NEW || mode == Search.Mode.NEXT) {
            if (--pos < 0) {
                pos = text.length() - 1;
            }
            return this.searchBackward(matcher, text, pos);
        }
        if (++pos > text.length() - 1) {
            pos = 0;
        }
        return this.searchForward(matcher, text, pos);
    }

    private Region searchForward(Matcher matcher, String text, int startPos) {
        int idx = -1;
        String foundStr = "";
        if (matcher.find(startPos)) {
            idx = matcher.start();
            foundStr = matcher.group();
        } else if (PreferenceService.getInstance().getBoolean("wrapsearch") && matcher.find()) {
            idx = matcher.start();
            foundStr = matcher.group();
        }
        if (idx != -1) {
            return new Region(idx, foundStr.length());
        }
        return null;
    }

    private Region searchBackward(Matcher matcher, String text, int startPos) {
        int idx = -1;
        String foundStr = "";
        int newCursor = -1;
        while (matcher.find(++newCursor)) {
            newCursor = matcher.start();
            if (newCursor > startPos) break;
            idx = newCursor;
            foundStr = matcher.group();
        }
        if (idx == -1 && PreferenceService.getInstance().getBoolean("wrapsearch")) {
            newCursor = -1;
            while (matcher.find(++newCursor)) {
                idx = newCursor = matcher.start();
                foundStr = matcher.group();
            }
        }
        if (idx != -1) {
            return new Region(idx, foundStr.length());
        }
        return null;
    }

    private int getFlags(String regex, Search.CaseSensitive caseSensitive) {
        boolean ignoreCase = PreferenceService.getInstance().getBoolean("ignorecase");
        boolean smartCase = PreferenceService.getInstance().getBoolean("smartcase");
        int flags = 8;
        if (caseSensitive == Search.CaseSensitive.DEFAULT) {
            if (ignoreCase) {
                if (smartCase) {
                    int i = 0;
                    while (i < regex.length()) {
                        if (Character.isUpperCase(regex.charAt(i))) {
                            return flags;
                        }
                        ++i;
                    }
                }
                flags |= 2;
            }
        } else if (caseSensitive == Search.CaseSensitive.FALSE) {
            flags |= 2;
        }
        return flags;
    }
}

