/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.search;

import com.mbartl.viplugineclipse.viimplementation.util.Region;

public abstract class Search {
    private String _lastSearch = "";
    private Direction _lastDirection;

    protected Search() {
    }

    public Region searchNext(String text, int startPos, CaseSensitive caseSensitive, long timestamp) {
        if (this._lastSearch != null) {
            return this.search(text, this._lastSearch, this._lastDirection, Mode.NEXT, startPos, caseSensitive, timestamp);
        }
        return null;
    }

    public Region searchNext(String text, int startPos, long timestamp) {
        if (this._lastSearch != null) {
            return this.search(text, this._lastSearch, this._lastDirection, Mode.NEXT, startPos, CaseSensitive.DEFAULT, timestamp);
        }
        return null;
    }

    public Region searchPrevious(String text, int startPos, long timestamp) {
        if (this._lastSearch != null) {
            return this.search(text, this._lastSearch, this._lastDirection, Mode.PREVIOUS, startPos, CaseSensitive.DEFAULT, timestamp);
        }
        return null;
    }

    public Region search(String text, String searchString, Direction direction, int startPos, long timestamp) {
        return this.search(text, searchString, direction, startPos, CaseSensitive.DEFAULT, timestamp);
    }

    public Region search(String text, String searchString, Direction direction, int startPos, CaseSensitive caseInSensitive, long timestamp) {
        if (searchString == null) {
            return null;
        }
        this._lastSearch = searchString;
        this._lastDirection = direction;
        return this.search(text, searchString, direction, Mode.NEW, startPos, caseInSensitive, timestamp);
    }

    public void setLastSearch(String searchString) {
        this._lastSearch = searchString;
    }

    public Region search(String text, String searchString, Direction direction, Mode mode, int startPos, long timestamp) {
        if (searchString == null) {
            return null;
        }
        this._lastSearch = searchString;
        this._lastDirection = direction;
        return this.search(text, searchString, direction, mode, startPos, CaseSensitive.DEFAULT, timestamp);
    }

    public abstract Region search(String var1, String var2, Direction var3, Mode var4, int var5, CaseSensitive var6, long var7);

    public static final class CaseSensitive {
        public static final CaseSensitive DEFAULT = new CaseSensitive();
        public static final CaseSensitive TRUE = new CaseSensitive();
        public static final CaseSensitive FALSE = new CaseSensitive();
    }

    public static final class Direction {
        public static final Direction FORWARD = new Direction();
        public static final Direction BACKWARD = new Direction();
    }

    public static final class Mode {
        public static final Mode NEW = new Mode();
        public static final Mode NEXT = new Mode();
        public static final Mode PREVIOUS = new Mode();
    }
}

