/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.search;

import com.mbartl.viplugineclipse.preferences.PreferenceService;
import com.mbartl.viplugineclipse.viimplementation.search.Search;
import com.mbartl.viplugineclipse.viimplementation.util.Region;

public class SimpleSearch
extends Search {
    @Override
    public Region search(String textStr, String search, Search.Direction direction, Search.Mode mode, int startPos, Search.CaseSensitive caseSensitive, long timestamp) {
        int idx;
        boolean ignoreCase = PreferenceService.getInstance().getBoolean("ignorecase");
        boolean smartCase = PreferenceService.getInstance().getBoolean("smartcase");
        String searchString = search;
        String text = textStr;
        if (caseSensitive == Search.CaseSensitive.FALSE) {
            text = text.toLowerCase();
            searchString = searchString.toLowerCase();
        } else if (caseSensitive == Search.CaseSensitive.DEFAULT && ignoreCase) {
            boolean found = false;
            if (smartCase) {
                int i = 0;
                while (i < search.length()) {
                    if (Character.isUpperCase(search.charAt(i))) {
                        found = true;
                    }
                    ++i;
                }
            }
            if (!found) {
                text = text.toLowerCase();
                searchString = searchString.toLowerCase();
            }
        }
        int pos = startPos;
        if (direction == Search.Direction.FORWARD) {
            if (mode == Search.Mode.NEW || mode == Search.Mode.NEXT) {
                if (++pos > text.length() - 1) {
                    pos = 0;
                }
                if ((idx = text.indexOf(searchString, pos)) == -1) {
                    idx = text.indexOf(searchString);
                }
            } else {
                if (--pos < 0) {
                    pos = text.length() - 1;
                }
                if ((idx = text.lastIndexOf(searchString, pos)) == -1) {
                    idx = text.lastIndexOf(searchString);
                }
            }
        } else if (mode == Search.Mode.NEW || mode == Search.Mode.NEXT) {
            if (--pos < 0) {
                pos = text.length() - 1;
            }
            if ((idx = text.lastIndexOf(searchString, pos)) == -1) {
                idx = text.lastIndexOf(searchString);
            }
        } else {
            if (++pos > text.length() - 1) {
                pos = 0;
            }
            if ((idx = text.indexOf(searchString, pos)) == -1) {
                idx = text.indexOf(searchString);
            }
        }
        if (idx != -1) {
            return new Region(idx, searchString.length());
        }
        return null;
    }
}

