/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.util;

import com.mbartl.viplugineclipse.Activator;
import com.mbartl.viplugineclipse.viimplementation.util.Macro;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.startup.core.DVTLogger;

public class MacroHandler {
    private static MacroHandler instance = null;
    private final Map<String, Macro> macros = new HashMap<String, Macro>();
    private final String allPossibleMacros = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static MacroHandler getInstance() {
        if (instance == null) {
            instance = new MacroHandler();
            instance.loadMacrosFromPreferences();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveMacrosToPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        Base64.Encoder encoder = Base64.getEncoder();
        int i = 0;
        while (true) {
            block18: {
                if (i >= "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length()) {
                    return;
                }
                String key = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".substring(i, i + 1);
                Macro macro = this.macros.get(key);
                if (macro != null) {
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            try {
                                try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                                    oos.writeObject(macro);
                                    preferenceStore.putValue("MACRO_" + key, encoder.encodeToString(bos.toByteArray()));
                                }
                                if (bos == null) break block18;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bos == null) throw throwable;
                                bos.close();
                                throw throwable;
                            }
                            bos.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    private void loadMacrosFromPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        Base64.Decoder decoder = Base64.getDecoder();
        int i = 0;
        while (i < "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length()) {
            String key = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".substring(i, i + 1);
            String value = preferenceStore.getString("MACRO_" + key);
            if (!value.isEmpty()) {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decoder.decode(value)));){
                        this.macros.put(key, (Macro)ois.readObject());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    preferenceStore.putValue("MACRO_" + key, "");
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    public void add(Macro macro) {
        this.macros.put(macro.getKey(), macro);
        this.saveMacrosToPreferences();
    }

    public Macro get(String key) {
        return this.macros.get(key);
    }
}

