/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.util;

import com.mbartl.viplugineclipse.BookMarkHandler;
import com.mbartl.viplugineclipse.DocumentAdapter;
import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.viimplementation.layer.SelectionManager;
import com.mbartl.viplugineclipse.viimplementation.util.Line;

public class RangeCommandEvaluator {
    public static void evalRegion(String range, DocumentAdapter analyzer, SelectionManager selectionManager, EditorImplementation editor, BookMarkHandler bookmarks) {
        if (range.equals("%")) {
            selectionManager.selectAll();
            return;
        }
        int idx = range.indexOf(",");
        if (idx != -1) {
            String start = range.substring(0, idx);
            String end = range.substring(idx + 1);
            int startLinePos = RangeCommandEvaluator.convertToLineNumber(start, analyzer, editor, bookmarks);
            int endLinePos = RangeCommandEvaluator.convertToLineNumber(end, analyzer, editor, bookmarks);
            if (endLinePos < startLinePos) {
                int temp = startLinePos;
                startLinePos = endLinePos;
                endLinePos = temp;
            }
            Line startLine = analyzer.getLine(startLinePos);
            Line endLine = analyzer.getLine(endLinePos);
            if (startLine != null && endLine != null) {
                selectionManager.setInternalSelection(startLine.getOffset(), endLine.getOffsetEnd() - startLine.getOffset());
            }
        }
    }

    public static int convertToLineNumber(String rangePointStr, DocumentAdapter analyzer, EditorImplementation editor, BookMarkHandler bookmarks) {
        int linePos = 0;
        String rangePoint = rangePointStr;
        if (rangePoint.length() == 0) {
            linePos = analyzer.getLinePosOfOffset(editor.getCaretPosition());
        } else if (Character.isDigit(rangePoint.charAt(0))) {
            linePos = RangeCommandEvaluator.parseSignedInteger(rangePoint) - 1;
        } else {
            if (rangePoint.startsWith(".")) {
                rangePoint = rangePoint.substring(1);
                linePos = analyzer.getLinePosOfOffset(editor.getCaretPosition());
            } else if (rangePoint.startsWith("$")) {
                rangePoint = rangePoint.substring(1);
                linePos = analyzer.getNumberOfLines() - 1;
            } else if (rangePoint.startsWith("+") || rangePoint.startsWith("-")) {
                linePos = analyzer.getLinePosOfOffset(editor.getCaretPosition());
            } else if (rangePoint.startsWith("'") || rangePoint.startsWith("`")) {
                int pos = bookmarks.getPosition(rangePoint.substring(1));
                linePos = analyzer.getLinePosOfOffset(pos);
            }
            if (rangePoint.length() > 0 && (rangePoint.startsWith("+") || rangePoint.startsWith("-"))) {
                int counter = RangeCommandEvaluator.parseSignedInteger(rangePoint);
                linePos += counter;
            }
        }
        linePos = Math.max(0, linePos);
        linePos = Math.min(analyzer.getNumberOfLines() - 1, linePos);
        return linePos;
    }

    private static int parseSignedInteger(String number) {
        String n = number;
        if (n.charAt(0) == '+') {
            n = n.substring(1);
        }
        int integer = 0;
        try {
            integer = Integer.parseInt(n);
        }
        catch (NumberFormatException numberFormatException) {}
        return integer;
    }
}

