/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.util;

public class TextUtils {
    public static final String DELIMITER_ON_THIS_PLATFORM = System.getProperty("line.separator");
    public static final String DELIMITER_WINDOWS = "\r\n";
    public static final String DELIMITER_UNIX = "\n";
    public static final String DELIMITER_MAC = "\r";
    static final String[] DELIMITER = new String[]{"\r\n", "\n", "\r"};

    public static int getPreviousWhiteSpace(String text, int startIndex) {
        return text.lastIndexOf(" ", startIndex - 1);
    }

    public static int getNextWhiteSpace(String text, int startIndex) {
        return text.indexOf(" ", startIndex + 1);
    }

    public static int getFirstVisibleCharacter(String text, int startIndex) {
        int i = startIndex;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String shiftText(String text, int counter, boolean left, int shiftWidth, boolean expandtab) {
        String shiftedText = text;
        int i = 0;
        while (i < counter) {
            if (left && shiftedText.length() > 0) {
                int whiteSpaceLength;
                if (shiftedText.charAt(0) == '\t') {
                    shiftedText = shiftedText.substring(1);
                } else if (Character.isWhitespace(shiftedText.charAt(0)) && (whiteSpaceLength = TextUtils.getFirstVisibleCharacter(shiftedText, 0)) != -1) {
                    int deleteChars = Math.min(shiftWidth, whiteSpaceLength);
                    shiftedText = shiftedText.substring(deleteChars);
                }
            } else {
                shiftedText = expandtab ? String.valueOf(TextUtils.createStringFromCharacter(' ', shiftWidth)) + shiftedText : String.valueOf('\t') + shiftedText;
            }
            ++i;
        }
        return shiftedText;
    }

    public static boolean endsWithDelimiter(String text) {
        int i = 0;
        while (i < DELIMITER.length) {
            int idx = text.lastIndexOf(DELIMITER[i]);
            if (idx != -1 && idx == text.length() - DELIMITER[i].length()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String createStringFromCharacter(char ch, int length) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < length) {
            str.append(ch);
            ++i;
        }
        return str.toString();
    }

    public static String multiplyString(String text, int counter) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < counter) {
            str.append(text);
            ++i;
        }
        return str.toString();
    }

    public static String replaceAll(String text, String find, String replace) {
        int idx;
        if (text == null || text.length() == 0) {
            return text;
        }
        String newText = text;
        int searchPos = 0;
        while ((idx = newText.indexOf(find, searchPos)) != -1) {
            newText = String.valueOf(newText.substring(0, idx)) + replace + newText.substring(idx + find.length());
            searchPos = idx + replace.length();
        }
        return newText;
    }

    public static String trimFront(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String newText = text;
        while (newText.length() != 0 && Character.isWhitespace(newText.charAt(0))) {
            newText = newText.substring(1);
        }
        return newText;
    }

    public static int getStartOfNumber(String text, int start) {
        boolean digitFound = false;
        while (start >= 0) {
            char ch = text.charAt(start);
            if (Character.isDigit(ch)) {
                digitFound = true;
                if (start > 0) {
                    --start;
                    continue;
                }
                return start;
            }
            if (ch == '+' || ch == '-') {
                if (digitFound) {
                    --start;
                }
                return start;
            }
            return start;
        }
        return -1;
    }
}

