/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.viimplementation.util;

import com.mbartl.viplugineclipse.viimplementation.util.TextUtils;
import org.apache.commons.lang.StringUtils;

public class WordSeparatorUtils {
    public static final String separatorDefaults = ".,(,), ,TAB,CR_LF,ENTER,:,;,?,+,=,ANGLE_BRACKET_RIGHT,ANGLE_BRACKET_LEFT,*,{,},\",|,COMMA,-,\\,/,@,[,],},~,!,#,$,%,^,AND,',`,\ufffd";
    private String[] wordSeparators;
    private final char[] WORDSeparators = new char[]{' ', '\n', '\t'};

    public WordSeparatorUtils(String separators) {
        this.setWordSeparators(separators);
    }

    private void setWordSeparators(String separatorsString) {
        String[] separators = StringUtils.split((String)separatorsString, (String)",");
        this.wordSeparators = new String[separators.length];
        int i = 0;
        String[] stringArray = separators;
        int n = separators.length;
        int n2 = 0;
        while (n2 < n) {
            String separator = stringArray[n2];
            String ch = separator.equals("COMMA") ? "," : (separator.equals("CR_LF") ? "\r\n" : (separator.equals("ENTER") ? "\n" : (separator.equals("TAB") ? "\t" : (separator.equals("ANGLE_BRACKET_LEFT") ? "<" : (separator.equals("ANGLE_BRACKET_RIGHT") ? ">" : (separator.equals("AND") ? "&" : separator))))));
            this.wordSeparators[i] = ch;
            ++i;
            ++n2;
        }
    }

    public boolean isWordEnding(char ch, boolean withSpace) {
        if (!(withSpace || ch != ' ' && ch != '\t' && ch != '\n')) {
            return false;
        }
        int i = 0;
        while (i < this.wordSeparators.length) {
            if (this.wordSeparators[i].equals(String.valueOf(ch))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getNextWord(String text, int startIndex) {
        char c;
        if (text == null || text.length() == 0) {
            return -1;
        }
        int endIndex = text.length();
        int newStartIndex = startIndex;
        if (this.isWordEnding(text.charAt(startIndex), false)) {
            int i = startIndex + 1;
            while (i < text.length()) {
                if (!this.isWordEnding(text.charAt(i), false)) break;
                newStartIndex = i++;
            }
        }
        int index = 0;
        int i = 0;
        while (i < this.wordSeparators.length) {
            index = text.indexOf(this.wordSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex) {
            i = newStartIndex + 1;
            while (i < text.length()) {
                c = text.charAt(i);
                if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                    return i;
                }
                ++i;
            }
        }
        if (endIndex < text.length() && (text.charAt(endIndex) == ' ' || text.charAt(endIndex) == '\r' || text.charAt(endIndex) == '\n')) {
            i = endIndex;
            while (i < text.length()) {
                c = text.charAt(i);
                if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                    return i;
                }
                ++i;
            }
        }
        return endIndex;
    }

    public int getNextWORD(String text, int startIndex) {
        char c;
        if (text == null || text.length() == 0) {
            return -1;
        }
        int newStartIndex = startIndex;
        int endIndex = text.length();
        int index = 0;
        int i = 0;
        while (i < this.WORDSeparators.length) {
            index = text.indexOf(this.WORDSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex) {
            i = newStartIndex + 1;
            while (i < text.length()) {
                c = text.charAt(i);
                if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                    return i;
                }
                ++i;
            }
        }
        if (endIndex < text.length() && (text.charAt(endIndex) == ' ' || text.charAt(endIndex) == '\n')) {
            i = endIndex;
            while (i < text.length()) {
                c = text.charAt(i);
                if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                    return i;
                }
                ++i;
            }
        }
        return endIndex;
    }

    public int getPreviousWord(String text, int startIndex) {
        if (startIndex >= text.length()) {
            startIndex = text.length() - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            int wordPos = this.getNextWord(text, i);
            if (wordPos < startIndex) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getPreviousWORD(String text, int startIndex) {
        int i = startIndex;
        while (i >= 0) {
            int wordPos = this.getNextWORD(text, i);
            if (wordPos < startIndex) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getEndOfCurrentWord(String text, int startIndex, boolean selectUntilLastEndCharacter, boolean movement) {
        int newStartIndex;
        if (movement) {
            newStartIndex = TextUtils.getFirstVisibleCharacter(text, startIndex + 1);
        } else {
            newStartIndex = TextUtils.getFirstVisibleCharacter(text, startIndex);
            if (text.length() > 0 && Character.isWhitespace(text.charAt(0))) {
                newStartIndex = TextUtils.getFirstVisibleCharacter(text, startIndex + 1);
            }
        }
        if (newStartIndex == -1) {
            return startIndex;
        }
        int endIndex = text.length();
        int index = 0;
        int i = 0;
        while (i < this.wordSeparators.length) {
            index = text.indexOf(this.wordSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex && selectUntilLastEndCharacter) {
            i = startIndex + 2;
            while (i < text.length()) {
                if (!this.isWordEnding(text.charAt(i), false)) break;
                endIndex = i++;
            }
            return endIndex;
        }
        return endIndex - 1;
    }

    public int getEndOfCurrentWORD(String text, int startIndex) {
        int newStartIndex = TextUtils.getFirstVisibleCharacter(text, startIndex + 1);
        if (newStartIndex == -1) {
            return startIndex;
        }
        int endIndex = text.length();
        int index = 0;
        int i = 0;
        while (i < this.WORDSeparators.length) {
            index = text.indexOf(this.WORDSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        return endIndex - 1;
    }

    public static boolean isWordCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }
}

