/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.builders;

import antlr.Token;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.parser.VhdlAMS;
import ro.amiq.vhdldt.ui.persistenttask.PersistentTaskManager;

public class VhdlBuilderUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean internalFullBuild(IBuildStatusProvider buildStatusProvider, VhdlAMS vhdlParser, RfProject rfProject, Set<String> translatePragmas, List<CustomPragma> customPragmas, DVTCodeCommentsPreferences commentsPreferences, int maxIssuesKindNumber) {
        HashMap<ParserPath, HashSet<Integer>> invocationIndexByPath = new HashMap<ParserPath, HashSet<Integer>>();
        try {
            IProject project = rfProject.getProject();
            if (project == null) {
                return false;
            }
            rfProject.setElaborationEnabled(BuildConfigManager.getIncrementalElaborationKind((IProject)project));
            List invocations = BuildConfigManager.getInvocations((IProject)project);
            if (invocations == null) return false;
            if (invocations.isEmpty()) {
                return false;
            }
            Set taskNames = PersistentTaskManager.getInstance().getAllTaskNames();
            boolean hideTaskTags = PersistentTaskManager.getInstance().getHideTaskTags();
            boolean caseSensitiveTaskTags = PersistentTaskManager.getInstance().getCaseSensitiveTaskTags();
            int invocOffset = 0;
            int fileIndex = 0;
            int invocNumber = 0;
            while (true) {
                if (invocNumber >= invocations.size()) {
                    return true;
                }
                Invocation invocation = (Invocation)invocations.get(invocNumber);
                IBuildConfigParserConstants.ToolCompat toolCompat = invocation.getToolCompat();
                buildStatusProvider.beginInvocation(invocNumber);
                if (BuildConfigManager.getPrecompiledDbMode((IProject)project) != BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_SAVE) {
                    List topFiles = BuildConfigManager.getTopFiles((Invocation)invocation, (LanguageKind)LanguageKind.VHDL);
                    SkipCompileFilter skipCompileFilter = BuildConfigManager.getSkipCompileFilter((IProject)project, (Invocation)invocation);
                    if (!topFiles.isEmpty()) {
                        rfProject.setToolCompat(toolCompat);
                        int printableInvocationNumber = invocation.getState().fKind == BuildConfigParser.InvocationKind.REGULAR && invocNumber == 0 ? invocNumber + 1 : invocNumber;
                        buildStatusProvider.consolePrint("*** Invocation #" + printableInvocationNumber + "***");
                        long startTime = System.currentTimeMillis();
                        int i = 0;
                        while (true) {
                            if (i >= topFiles.size()) {
                                buildStatusProvider.consolePrintSection("Done invocation #" + printableInvocationNumber + " [" + (System.currentTimeMillis() - startTime) + " ms]");
                                break;
                            }
                            BuildConfigProperty topFileProperty = (BuildConfigProperty)topFiles.get(i);
                            IBuildConfigParserConstants.LanguageSyntax languageSyntax = (IBuildConfigParserConstants.LanguageSyntax)topFileProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX");
                            if (languageSyntax == null) {
                                languageSyntax = IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2000;
                            }
                            if (topFileProperty.getKind() == 0) {
                                if (buildStatusProvider.checkCancel()) {
                                    return false;
                                }
                                String pathValue = topFileProperty.getValue();
                                pathValue = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(pathValue);
                                if ((pathValue = DVTUtilsCommon.INSTANCE.getFileSubstitute(project, pathValue)) != null) {
                                    VhdlModelManager.getInstance().addTopFile(pathValue);
                                    VhdlAMS vhdlAMS = vhdlParser;
                                    synchronized (vhdlAMS) {
                                        block24: {
                                            block23: {
                                                if (!vhdlParser.isInterrupted()) break block23;
                                                buildStatusProvider.stopCancelPoolingThread();
                                                return true;
                                            }
                                            try {
                                                try {
                                                    ++fileIndex;
                                                    buildStatusProvider.setTimestamp();
                                                    buildStatusProvider.newCancelPoolingThread();
                                                    buildStatusProvider.startCancelPoolingThread(vhdlParser, project, false);
                                                    buildStatusProvider.setCancelPoolingThreadFileName(pathValue);
                                                    ParserPath key = new ParserPath(pathValue);
                                                    HashSet<Integer> set = (HashSet<Integer>)invocationIndexByPath.get(key);
                                                    if (set == null) {
                                                        set = new HashSet<Integer>();
                                                        invocationIndexByPath.put(key, set);
                                                    }
                                                    set.add(invocation.getIndex());
                                                    vhdlParser.parseFile(pathValue, invocation.getLibName(), languageSyntax, rfProject, null, false, fileIndex, invocNumber + invocOffset, maxIssuesKindNumber, translatePragmas, customPragmas, commentsPreferences, taskNames, caseSensitiveTaskTags, hideTaskTags, skipCompileFilter);
                                                    Token token = (Token)topFileProperty.getAttribute("ATTRIBUTE_TOKEN");
                                                    if (token == null) break block24;
                                                    rfProject.addBuildFileMapping(fileIndex, token.getFilename(), token.getLine());
                                                }
                                                catch (Exception e) {
                                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                                    buildStatusProvider.stopCancelPoolingThread();
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                buildStatusProvider.stopCancelPoolingThread();
                                                throw throwable;
                                            }
                                        }
                                        buildStatusProvider.stopCancelPoolingThread();
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    buildStatusProvider.endInvocation(invocNumber);
                }
                ++invocNumber;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public static String importExtensions(IProject project, String ext) {
        block6: {
            String string;
            BufferedWriter extensionsWriter = null;
            String extensionPath = null;
            BufferedReader extensionReader = null;
            try {
                String line;
                IPath extensionsPath = RfProject.getExtensionsPath(project, ext);
                extensionsWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(extensionsPath.toOSString())), IDVTConstants.UTF8));
                URL extensionURL = RfProject.class.getResource(ext);
                extensionPath = extensionURL.getPath();
                extensionReader = new BufferedReader(new InputStreamReader(extensionURL.openStream(), IDVTConstants.UTF8));
                while ((line = extensionReader.readLine()) != null) {
                    extensionsWriter.write(String.valueOf(line) + "\n");
                }
                extensionReader.close();
                ((Writer)extensionsWriter).close();
                string = extensionsPath.toOSString();
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)extensionReader);
            }
            catch (IOException iOException) {
                DVTLogger.INSTANCE.logInfo("Could not load extension:" + extensionPath);
                break block6;
            }
            finally {
                DVTUtilsCommon.INSTANCE.closeClosable(extensionReader);
                DVTUtilsCommon.INSTANCE.closeClosable(extensionsWriter);
            }
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)extensionsWriter);
            return string;
        }
        return null;
    }

    public static interface IBuildStatusProvider {
        public void consolePrint(String var1);

        public void consolePrintSection(String var1);

        public void newCancelPoolingThread();

        public void startCancelPoolingThread(VhdlAMS var1, IProject var2, boolean var3);

        public void setCancelPoolingThreadFileName(String var1);

        public void stopCancelPoolingThread();

        public void setTimestamp();

        public boolean checkCancel();

        public void beginInvocation(int var1);

        public void endInvocation(int var1);

        public int getFileIndex();
    }
}

