/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.core;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;
import ro.amiq.dvt.DVTActivator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.vhdldt.core.VhdlPluginCommon;
import ro.amiq.vhdldt.externaltools.VhdlExternalToolsDelegate;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.ui.namechecker.NameCheckerWarningsManager;
import ro.amiq.vhdldt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.vhdldt.ui.syntaxerrors.SyntaxErrorsManager;

public class VhdlPlugin
extends VhdlPluginCommon {
    private static VhdlPlugin fPlugin;
    private IPreferenceStore fCombinedPreferenceStore;

    public VhdlPlugin() {
        fPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DVTLogger.INSTANCE.logDebug(">> Started VHDLDT Plugin (version: " + (String)this.getBundle().getHeaders().get("Bundle-Version") + ").");
        context.addBundleListener(event -> {
            if (event.getType() == 2 && event.getBundle().getSymbolicName().equals("ro.amiq.vhdldt")) {
                DVTLogger.INSTANCE.logDebug(">> Started VHDLDT initialization.");
                new DVTActivator();
                SyntaxErrorsManager.getInstance().startup();
                ExternalToolsModelManager.getInstance().addExternalToolsDelegate((IExternalToolsDelegate)VhdlExternalToolsDelegate.getInstance());
                this.contributeToVariables();
                try {
                    while (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    DVTLogger.INSTANCE.logDebug(">> Started VHDLDT UI initialization.");
                    PersistentTaskManager.getInstance().startup();
                    NameCheckerWarningsManager.getInstance();
                    DVTMixedLangModelManager.getInstance().registerModelManager((DVTModelManager)VhdlModelManager.getInstance());
                    ObjectionManager.getInstance().clear(Objection.VHDLDT_INITIALIZED);
                    DVTLogger.INSTANCE.logDebug("<< Ended VHDLDT UI initialization.");
                });
                DVTLogger.INSTANCE.logDebug("<< Ended VHDLDT initialization.");
            }
        });
    }

    private void contributeToVariables() {
    }

    @Override
    public void stop(BundleContext context) {
        try {
            super.stop(context);
            DVTPlugin.getDefault().collect().i("F7668646C");
            DVTLogger.INSTANCE.logDebug("<< Ended VHDLDT Plugin.");
        }
        finally {
            fPlugin = null;
            super.stop(context);
        }
    }

    public static VhdlPlugin getDefault() {
        return fPlugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ro.amiq.vhdldt", (String)path);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public void savePreferences() {
        try {
            InstanceScope instance = new InstanceScope();
            instance.getNode("ro.amiq.vhdldt").flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

