/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.exploratory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.ui.editor.VHDLScopeBreadcrumbUtils;

public class VhdlCustomWaiversExploratoryUtil {
    private static final String PACKAGE = "package";
    private static final String PACKAGE_BODY = "package-body";
    private static final String ENTITY = "entity";
    private static final String TYPE = "type";
    private static final String TYPE_BODY = "type-body";
    private static final String FUNCTION = "function";
    private static final String BLOCK = "block";
    private static final String COMPONENT = "component";
    private static final String CONFIGURATION = "configuration";
    private static final String INSTANCE = "instance";
    private static final String ARCHITECTURE = "architecture";
    public static final Map<String, DVTPair<Class<? extends IRfNamedElement>, Boolean>> SCOPE_TYPES = new HashMap<String, DVTPair<Class<? extends IRfNamedElement>, Boolean>>();

    static {
        SCOPE_TYPES.put(PACKAGE, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfPackage.class, (Object)false));
        SCOPE_TYPES.put(PACKAGE_BODY, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfPackageBody.class, (Object)false));
        SCOPE_TYPES.put(ENTITY, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfEntity.class, (Object)false));
        SCOPE_TYPES.put(TYPE, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfType.class, (Object)true));
        SCOPE_TYPES.put(TYPE_BODY, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfTypeBody.class, (Object)false));
        SCOPE_TYPES.put(FUNCTION, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfFunction.class, (Object)false));
        SCOPE_TYPES.put(BLOCK, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfBlock.class, (Object)false));
        SCOPE_TYPES.put(COMPONENT, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfComponent.class, (Object)true));
        SCOPE_TYPES.put(CONFIGURATION, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfConfiguration.class, (Object)false));
        SCOPE_TYPES.put(INSTANCE, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfInstance.class, (Object)false));
        SCOPE_TYPES.put(ARCHITECTURE, (DVTPair<Class<? extends IRfNamedElement>, Boolean>)new DVTPair(RfArchitecture.class, (Object)false));
    }

    public static IRfBreadcrumbElement getScopeForBreadcrumb(ITextEditor editor, int offset) {
        return VHDLScopeBreadcrumbUtils.getInstance().getScopeForBreadcrumb(editor, offset, true);
    }

    public static List<IRfNamedElement> computeScopeAncestors(IRfBreadcrumbElement selectedScope) {
        ArrayList<IRfNamedElement> ancestors = new ArrayList<IRfNamedElement>();
        while (selectedScope != null) {
            IRfScopeElement enclosingScope;
            if (selectedScope instanceof RfDefElement) {
                selectedScope = ((RfDefElement)selectedScope).getNamedElement();
            }
            if (selectedScope instanceof RfPackage || selectedScope instanceof RfPackageBody || selectedScope instanceof RfEntity || selectedScope instanceof RfType || selectedScope instanceof RfTypeBody || selectedScope instanceof RfFunction || selectedScope instanceof RfBlock || selectedScope instanceof RfComponent || selectedScope instanceof RfConfiguration || selectedScope instanceof RfInstance) {
                ancestors.add((IRfNamedElement)selectedScope);
            }
            if (!((enclosingScope = selectedScope.getEnclosingScope()) instanceof IRfBreadcrumbElement)) break;
            selectedScope = (IRfBreadcrumbElement)enclosingScope;
        }
        return ancestors;
    }

    public static boolean testScopeWaiverMatch(String waiverType, String waiverTypeName, IRfNamedElement elementToMatch) {
        if (elementToMatch == null) {
            return false;
        }
        boolean matchName = new StringMatcher(waiverTypeName, false, false).match(elementToMatch.getName());
        if (!matchName) {
            return false;
        }
        if (SCOPE_TYPES.containsKey(waiverType)) {
            DVTPair<Class<? extends IRfNamedElement>, Boolean> pair = SCOPE_TYPES.get(waiverType);
            if (((Boolean)pair.getValue()).booleanValue()) {
                return ((Class)pair.getKey()).isInstance(elementToMatch);
            }
            return ((Class)pair.getKey()).equals(elementToMatch.getClass());
        }
        return waiverType.equals("*");
    }
}

