/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.exploratory;

import antlr.CharScanner;
import antlr.Token;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.CustomWaiversExploratoryStrategy;
import ro.amiq.dvt.exploratory.ExploratoryCustomWaivers;
import ro.amiq.dvt.exploratory.IExploratoryCommandContributor;
import ro.amiq.dvt.exploratory.NotAppliedExploratoryCustomWaivers;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.XPLUtil;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vhdldt.exploratory.VhdlCustomWaiversExploratoryUtil;
import ro.amiq.vhdldt.exploratory.VhdlExploratoryCustomWaiversReader;
import ro.amiq.vhdldt.exploratory.VhdlExploratoryGeneratedWaiversWriter;
import ro.amiq.vhdldt.exploratory.VhdlScopeCustomWaiversExploratoryStrategy;
import ro.amiq.vhdldt.exploratory.XplVhdlLexer;
import ro.amiq.vhdldt.model.reflection.util.RfUtilsCommon;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;

public class VhdlExploratoryCommandContributor
implements IExploratoryCommandContributor {
    private List<ExploratoryCustomWaivers> customXPLWaivers = new ArrayList<ExploratoryCustomWaivers>();
    private List<ExploratoryCustomWaivers> generatedXPLCustomWaivers = new ArrayList<ExploratoryCustomWaivers>();
    private Map<String, List<NotAppliedExploratoryCustomWaivers>> xplScopeOccurencesHashMap = new HashMap<String, List<NotAppliedExploratoryCustomWaivers>>();
    private Map<BaseExplorationCommand, List<Predicate<IRfNamedElement>>> semanticXPLWaivers = new HashMap<BaseExplorationCommand, List<Predicate<IRfNamedElement>>>();

    public CharScanner getLexer(Reader input, IFile file) {
        return new XplVhdlLexer(input, file);
    }

    public Token getLexerNextToken(CharScanner lexer, IDocument document) {
        if (!(lexer instanceof XplVhdlLexer)) {
            return new Token(1);
        }
        return ((XplVhdlLexer)lexer).nextIdentifierToken();
    }

    public LanguageKind getLanguage() {
        return LanguageKind.VHDL;
    }

    public boolean testCustomWaivers(BaseExplorationCommand command, CharScanner lexer, DVTEditor dvtEditor, Token token, IRfNamedElementAndScope elementAndScope) {
        if (this.customXPLWaivers == null || this.customXPLWaivers.isEmpty()) {
            return false;
        }
        IFile file = ((XplVhdlLexer)lexer).getFile();
        for (ExploratoryCustomWaivers customWaiver : this.customXPLWaivers) {
            if (!customWaiver.isApplicable(command, file, elementAndScope, dvtEditor, token)) continue;
            return true;
        }
        return false;
    }

    public boolean testGeneratedWaivers(BaseExplorationCommand command, CharScanner lexer, DVTEditor dvtEditor, Token token, IRfNamedElementAndScope elementAndScope) {
        if (this.generatedXPLCustomWaivers == null || this.generatedXPLCustomWaivers.isEmpty()) {
            return false;
        }
        IFile file = ((XplVhdlLexer)lexer).getFile();
        for (ExploratoryCustomWaivers generatedWaiver : this.generatedXPLCustomWaivers) {
            if (!generatedWaiver.isApplicable(command, file, elementAndScope, dvtEditor, token)) continue;
            return true;
        }
        return false;
    }

    public void loadWaivers(Map<String, Object> dataFromWaiversFile) {
        this.customXPLWaivers = new VhdlExploratoryCustomWaiversReader().getWaivers(dataFromWaiversFile);
    }

    public void clearXPLWaivers() {
        this.semanticXPLWaivers.clear();
        this.customXPLWaivers.clear();
        this.generatedXPLCustomWaivers.clear();
        this.xplScopeOccurencesHashMap.clear();
    }

    public IRfNamedElementAndScope getElementUnderCursor(CharScanner lexer, IDocument document) {
        int currentOffset = lexer.getOffset();
        IFile file = ((XplVhdlLexer)lexer).getFile();
        if (file == null || document == null) {
            return null;
        }
        RfWNamedElementAndScope currentElement = RfUtilsCommon.getRfElement(file, document, currentOffset);
        return currentElement;
    }

    private String getTypeFromIRfNamedElement(IRfNamedElement namedElementFromScopeList) {
        for (Map.Entry<String, DVTPair<Class<? extends IRfNamedElement>, Boolean>> element : VhdlCustomWaiversExploratoryUtil.SCOPE_TYPES.entrySet()) {
            if (!((Boolean)element.getValue().getValue() != false ? ((Class)element.getValue().getKey()).isInstance(namedElementFromScopeList) : ((Class)element.getValue().getKey()).equals(namedElementFromScopeList.getClass()))) continue;
            return element.getKey();
        }
        return null;
    }

    private List<IRfNamedElement> getScopeListForGeneratedWaivers(DVTEditor dvtEditor, Token token) {
        IRfBreadcrumbElement scopeBreadcrumb = VhdlCustomWaiversExploratoryUtil.getScopeForBreadcrumb((ITextEditor)dvtEditor, token.getOffset());
        if (!(scopeBreadcrumb instanceof IRfNamedElement)) {
            return null;
        }
        return VhdlCustomWaiversExploratoryUtil.computeScopeAncestors(scopeBreadcrumb);
    }

    private List<LinkedHashMap<String, Object>> convertScopeListToYamlFormat(List<IRfNamedElement> scopeList) {
        ArrayList<LinkedHashMap<String, Object>> scopeStackOfNamedElement = new ArrayList<LinkedHashMap<String, Object>>();
        for (IRfNamedElement namedElementFromScopeList : scopeList) {
            String typeFromIRfNamedElement = this.getTypeFromIRfNamedElement(namedElementFromScopeList);
            if (typeFromIRfNamedElement == null) {
                return null;
            }
            LinkedHashMap<String, String> scopeItemLinkedHashMap = new LinkedHashMap<String, String>();
            scopeItemLinkedHashMap.put(typeFromIRfNamedElement, namedElementFromScopeList.getName());
            scopeStackOfNamedElement.add(scopeItemLinkedHashMap);
        }
        return scopeStackOfNamedElement;
    }

    private void addWaiverToGeneratedWaiversListIfNecessary(NotAppliedExploratoryCustomWaivers currentNotAppliedWaiver, XPLConfig xplConfig, List<IRfNamedElement> scopeList, List<NotAppliedExploratoryCustomWaivers> listOfNotAppliedWaivers, String scopeListAsString) {
        if (currentNotAppliedWaiver == null || currentNotAppliedWaiver.getOccurences() != xplConfig.getGeneratedWaiverOccurrences()) {
            return;
        }
        List<LinkedHashMap<String, Object>> scopeHashMapOfNamedElement = this.convertScopeListToYamlFormat(scopeList);
        if (scopeHashMapOfNamedElement == null || scopeHashMapOfNamedElement.isEmpty()) {
            return;
        }
        VhdlScopeCustomWaiversExploratoryStrategy scopeStrategy = new VhdlScopeCustomWaiversExploratoryStrategy(scopeHashMapOfNamedElement);
        ExploratoryCustomWaivers waiverToBeAdded = currentNotAppliedWaiver.getWaiver();
        if (waiverToBeAdded == null) {
            return;
        }
        waiverToBeAdded.addStrategy((CustomWaiversExploratoryStrategy)scopeStrategy);
        this.generatedXPLCustomWaivers.add(waiverToBeAdded);
        if (listOfNotAppliedWaivers == null) {
            return;
        }
        listOfNotAppliedWaivers.remove(currentNotAppliedWaiver);
        if (listOfNotAppliedWaivers.isEmpty()) {
            this.xplScopeOccurencesHashMap.remove(scopeListAsString);
        }
    }

    public void createGeneratedWaiverIfScopeOccurencesMatch(XPLConfig xplConfig, DVTEditor dvtEditor, Token token, BaseExplorationCommand command) {
        String commandAsString = XPLUtil.INSTANCE.getCommandForGeneratedWaivers(command);
        if (commandAsString == null) {
            return;
        }
        List<IRfNamedElement> scopeList = this.getScopeListForGeneratedWaivers(dvtEditor, token);
        if (scopeList == null || scopeList.isEmpty()) {
            return;
        }
        String scopeListAsString = scopeList.stream().map(x -> x.getClass() + "[" + x.getName() + "]").collect(Collectors.joining("."));
        NotAppliedExploratoryCustomWaivers currentNotAppliedWaiver = null;
        List<NotAppliedExploratoryCustomWaivers> listOfNotAppliedWaivers = this.xplScopeOccurencesHashMap.get(scopeListAsString);
        if (listOfNotAppliedWaivers == null) {
            ArrayList<NotAppliedExploratoryCustomWaivers> notAppliedWaiversList = new ArrayList<NotAppliedExploratoryCustomWaivers>();
            currentNotAppliedWaiver = new NotAppliedExploratoryCustomWaivers(token, commandAsString);
            notAppliedWaiversList.add(currentNotAppliedWaiver);
            this.xplScopeOccurencesHashMap.put(scopeListAsString, notAppliedWaiversList);
        } else {
            boolean isWaiverFound = false;
            for (NotAppliedExploratoryCustomWaivers notAppliedWaiver : listOfNotAppliedWaivers) {
                if (notAppliedWaiver == null || notAppliedWaiver.getWaiver() == null || notAppliedWaiver.getWaiver().getCommand() == null || !notAppliedWaiver.getWaiver().getCommand().equals(commandAsString)) continue;
                isWaiverFound = true;
                notAppliedWaiver.incrementOccurences();
                notAppliedWaiver.addToDescription(token);
                currentNotAppliedWaiver = notAppliedWaiver;
                break;
            }
            if (!isWaiverFound) {
                currentNotAppliedWaiver = new NotAppliedExploratoryCustomWaivers(token, commandAsString);
                listOfNotAppliedWaivers.add(currentNotAppliedWaiver);
            }
        }
        this.addWaiverToGeneratedWaiversListIfNecessary(currentNotAppliedWaiver, xplConfig, scopeList, listOfNotAppliedWaivers, scopeListAsString);
    }

    public List<LinkedHashMap<String, Object>> convertGeneratedCustomWaiverToYAML() {
        return new VhdlExploratoryGeneratedWaiversWriter().convertWaiversToYamlFormat(this.generatedXPLCustomWaivers);
    }
}

