/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.externaltools;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.VhdlProject;
import ro.amiq.vhdldt.utils.VhdlFileUtils;

public class VhdlExternalToolsDelegate
implements IExternalToolsDelegate {
    private static volatile VhdlExternalToolsDelegate fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private VhdlExternalToolsDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VhdlExternalToolsDelegate getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VhdlExternalToolsDelegate();
            }
        }
        return fInstance;
    }

    public IFile getResource(IProject project, String knownPath) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        Path path = new Path(customPath);
        if (path.isAbsolute()) {
            File classicFile = new File(customPath);
            IFile candidate = VhdlFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        VhdlProject vhdlProject = (VhdlProject)VhdlModelManager.getInstance().getVhdlModel().getVhdlProject(project);
        if (vhdlProject != null) {
            File classicFile = new File(customPath);
            IFile candidate = VhdlFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        IFile candidate = VhdlFileUtils.getInstance().findProjectFile(project, customPath);
        if (candidate == null) {
            return null;
        }
        return candidate;
    }

    public String getBuilderKind() {
        return "ro.amiq.dvt.vhdldtKind";
    }

    public void openEditor(IProject project, String workingDirectory, String filePath, int line) {
        if (!Path.fromOSString((String)filePath).isAbsolute()) {
            filePath = Path.fromOSString((String)workingDirectory).append(filePath).toOSString();
        }
        filePath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(filePath);
        VhdlFileUtils.getInstance().openFile(project, filePath, line, null);
    }

    public boolean hasRelevantContentType(String fileName) {
        if (fileName == null) {
            return false;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vhdldt.VhdlSource", false);
        return DVTFileUtils.getInstance().validExtension(fileExtensions, fileName);
    }
}

