/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.reportissue.IncrementalBuildThreadDumpHandler;
import ro.amiq.dvt.ui.reportissue.IncrementalInfoCallbackFactory;
import ro.amiq.vhdldt.model.RebuildTriggerJobCommon;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.VhdlModule;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.utils.Utils;

class RebuildTriggerJob
extends RebuildTriggerJobCommon {
    public RebuildTriggerJob(VhdlModule module) {
        super(module);
    }

    public boolean shouldSchedule() {
        block3: {
            try {
                IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                if (preferences != null && DVTPlugin.getDefault() != null && DVTPlugin.getDefault().getPreferenceStore() != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return super.shouldSchedule() && (ResourcesPlugin.getWorkspace().isAutoBuilding() && DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE") || this.module.isForceBuild()) && this.module.isBuilderEnabled("ro.amiq.dvt.MixedLangBuilder");
    }

    public boolean shouldRun() {
        block3: {
            try {
                IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                if (preferences != null && DVTPlugin.getDefault() != null && DVTPlugin.getDefault().getPreferenceStore() != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return super.shouldRun() && (ResourcesPlugin.getWorkspace().isAutoBuilding() && DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE") || this.module.isForceBuild()) && this.module.isBuilderEnabled("ro.amiq.dvt.MixedLangBuilder");
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            block18: {
                if (!DVTPlugin.getDefault().collect().c(this.module.getFile().getProject(), "F7668646C")) {
                    return Status.CANCEL_STATUS;
                }
                IFile file = this.module.getFile();
                IProject project = file.getProject();
                monitor.beginTask("Parse: " + this.module.getFile().getName(), 5);
                monitor.worked(2);
                EnumMap<LanguageKind, Set> changedFiles = new EnumMap<LanguageKind, Set>(LanguageKind.class);
                RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
                try {
                    try {
                        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
                        IncrementalBuildThreadDumpHandler.INSTANCE.createSession(IncrementalInfoCallbackFactory.INSTANCE.createIncrementalDeltaFilesCallback(rfMixedLangProject, changedFiles), IncrementalInfoCallbackFactory.INSTANCE.createIncrementalDeltaInfoCallback(rfMixedLangProject), project);
                        FileCompileInfo fileCompileInfo = new FileCompileInfo(file);
                        ObjectionManager.getInstance().clear(Objection.BUILD);
                        if (project != null && !project.hasNature(LanguageKind.VLOG.NATURE_ID)) {
                            Utils.setReadOnlyBreadcrumbs();
                        }
                        DesignPathManager.getInstance().freeze(project);
                        boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
                        if (cancelIncremental) {
                            ChangedFilesManager.handleCanceledIncremental(new HashSet<FileCompileInfo>(Arrays.asList(fileCompileInfo)), (LanguageKind)LanguageKind.VHDL, (IProject)project, (IProgressMonitor)monitor, changedFiles);
                        }
                        VhdlModelManager.getInstance().cbIncrementalBuild(monitor, fileCompileInfo, this.fDocument, true);
                        changedFiles.computeIfAbsent(LanguageKind.VHDL, x -> new LinkedHashSet()).add(fileCompileInfo);
                        if (rfProject != null) {
                            rfProject.setBuildProgressMonitor(monitor);
                        }
                        DVTMixedLangModelManager.getInstance().notifyBuildListenersPostIncrementalBuild(project, changedFiles);
                        IncrementalElaborationKind incrementalElaborationKind = BuildConfigManager.getIncrementalElaborationKind((IProject)project);
                        DVTMixedLangModelManager.getInstance().notifyBuildListenersMixedLangPostIncrementalBuild(project, changedFiles, incrementalElaborationKind);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project != null ? project.getName() : "");
                        IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                        if (rfProject != null) {
                            rfProject.cleanIncrementalDeltaContainer();
                        }
                        if (!monitor.isCanceled()) {
                            RfMixedLangManager.getInstance().clearBacklogElements(project);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project != null ? project.getName() : "");
                    IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                    if (rfProject != null) {
                        rfProject.cleanIncrementalDeltaContainer();
                    }
                    if (!monitor.isCanceled()) {
                        RfMixedLangManager.getInstance().clearBacklogElements(project);
                    }
                    throw throwable;
                }
                DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project != null ? project.getName() : "");
                IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                if (rfProject != null) {
                    rfProject.cleanIncrementalDeltaContainer();
                }
                if (!monitor.isCanceled()) {
                    RfMixedLangManager.getInstance().clearBacklogElements(project);
                }
            }
            monitor.worked(3);
            monitor.setTaskName("");
            monitor.done();
            ObjectionManager.getInstance().clear(Objection.BUILD_DONE);
            this.setName("");
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.setName("");
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.OK_STATUS;
        }
    }
}

