/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.model.IVhdlModel;
import ro.amiq.vhdldt.model.IVhdlModule;
import ro.amiq.vhdldt.model.IVhdlProject;
import ro.amiq.vhdldt.model.VhdlFileInfo;
import ro.amiq.vhdldt.model.VhdlModel;
import ro.amiq.vhdldt.model.VhdlModule;
import ro.amiq.vhdldt.model.floatingwidgets.VhdlFNotificationProvider;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;
import ro.amiq.vhdldt.parser.VhdlAMS;
import ro.amiq.vhdldt.parser.VhdlProblem;
import ro.amiq.vhdldt.ui.syntaxerrors.SyntaxErrorsManager;
import ro.amiq.vhdldt.utils.Utils;

public class VhdlModelManager
extends DVTModelManager {
    private static volatile VhdlModelManager fInstance;
    private final VhdlModel fModel;
    private HashMap<IPath, ArrayList> fTopFilesErrors = new HashMap();
    private HashMap<IPath, ArrayList> fTopFilesWarnings = new HashMap();
    private List<VhdlProblem> fUnreportedErrors = new NullProtectedList<VhdlProblem>();
    private List<VhdlProblem> fUnreportedWarnings = new NullProtectedList<VhdlProblem>();
    private RfManager fRfManager;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private VhdlModelManager() {
        this.fModel = new VhdlModel();
        this.fRfManager = RfManager.getInstance();
        this.addBuildListener(this.fRfManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VhdlModelManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VhdlModelManager();
            }
        }
        return fInstance;
    }

    public int getPriority() {
        return DVTMixedLangBuilder.getBuilderPriorityForNature((String)"ro.amiq.vhdldt.VhdlNature");
    }

    public IVhdlModel getVhdlModel() {
        return this.fModel;
    }

    public IVhdlProject getIVhdlProject(IDVTProject iDVTProject) {
        return (IVhdlProject)iDVTProject;
    }

    public IVhdlModule getIVhdlFile(IDVTFile iDVTFile) {
        return (IVhdlModule)iDVTFile;
    }

    public VhdlFileInfo getVhdlFileInfo(DVTFileInfo dvtFileInfo) {
        return (VhdlFileInfo)dvtFileInfo;
    }

    public void saveUnfinishedJobs(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        Utils.saveRFDM(rfProject, false, false, true);
    }

    public void cbClean(IProject project) {
        this.cbClean(project, true);
    }

    public void cbClean(IProject project, boolean compilePredef) {
        this.fTopFilesErrors.clear();
        this.fTopFilesWarnings.clear();
        this.fUnreportedErrors.clear();
        this.fUnreportedWarnings.clear();
        IVhdlProject vhdlProject = this.getVhdlModel().getVhdlProject(project);
        if (vhdlProject == null) {
            return;
        }
        vhdlProject.clean();
        this.notifyReparseListeners(2, project);
        this.notifyBuildListenersClean(vhdlProject, compilePredef);
    }

    public void cbBuild(DVTFileInfo dvtFileInfo) {
        try {
            VhdlFileInfo info = this.getVhdlFileInfo(dvtFileInfo);
            IVhdlProject vhdlProject = this.getVhdlModel().getVhdlProject(info.getProject());
            if (vhdlProject != null) {
                vhdlProject.addTopFile(info.getParserPath());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbPostFullBuild(IProject project, boolean success) {
        DVTLogger.INSTANCE.logDebug("DEBUG: cbPostFullBuild start");
        IVhdlProject vhdlProject = this.getVhdlModel().getVhdlProject(project);
        if (vhdlProject == null) {
            return;
        }
        VhdlAMS vhdlParser = vhdlProject.getVHDLParser();
        if (vhdlParser == null) {
            return;
        }
        NullProtectedList<VhdlProblem> unreportedErrors = new NullProtectedList<VhdlProblem>();
        ArrayList<IVhdlModule> vhdlFiles = new ArrayList<IVhdlModule>();
        for (ParserPath parserPath : vhdlProject.getTopFiles()) {
            IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
            if (file != null && file.getLocation() != null) {
                VhdlAMS vhdlAMS;
                IPath location = file.getLocation();
                String resourcePath = location.toOSString();
                IVhdlModule vhdlFile = this.getVhdlModel().getOrCreateVhdlFile(file);
                if (this.fTopFilesErrors.containsKey(location)) {
                }
                if (vhdlFile != null) {
                    vhdlFiles.add(vhdlFile);
                    vhdlAMS = vhdlParser;
                    synchronized (vhdlAMS) {
                        vhdlFile.setEncrypted(vhdlParser.isEncrypted(parserPath));
                        boolean updatePath = !resourcePath.equals(parserPath.path);
                        vhdlFile.setErrors(vhdlParser.getErrors(parserPath), updatePath, resourcePath);
                        vhdlFile.setWarnings(vhdlParser.getWarnings(parserPath), updatePath, resourcePath);
                        vhdlFile.setTasks(vhdlParser.getTasks(parserPath));
                        continue;
                    }
                }
                vhdlAMS = vhdlParser;
                synchronized (vhdlAMS) {
                    unreportedErrors.addAll(vhdlParser.getErrors(parserPath));
                    continue;
                }
            }
            VhdlAMS vhdlAMS = vhdlParser;
            synchronized (vhdlAMS) {
                unreportedErrors.addAll(vhdlParser.getErrors(parserPath));
            }
        }
        int type = 6;
        this.notifyReparseListeners(1, type, vhdlFiles);
        this.notifyReparseListeners(3, project);
        if (!unreportedErrors.isEmpty()) {
            SyntaxErrorsManager.getInstance().updateProblemsUI(project, unreportedErrors);
        }
        this.notifyBuildListenersPostFullBuild(vhdlProject, success);
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo fileInfo, IDocument document, boolean saveRFDM) {
        if (monitor.isCanceled()) {
            return;
        }
        if (fileInfo == null) {
            return;
        }
        IFile file = fileInfo.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        this.cbClean(file);
        IVhdlModule vhdlFile = this.getVhdlModel().getOrCreateVhdlFile(file);
        if (vhdlFile == null) {
            return;
        }
        try {
            if (document != null) {
                vhdlFile.reparse(monitor, document.get(), saveRFDM);
            } else {
                vhdlFile.reparse(monitor, saveRFDM);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (vhdlFile.isAutoBuildStop()) {
            return;
        }
        int type = 1;
        type |= 2;
        IPath filePath = file.getLocation();
        this.notifyReparseListeners(0, type |= 4, vhdlFile);
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        IVhdlProject vProject = this.getVhdlModel().getVhdlProject(project);
        VhdlAMS vParser = vProject.getVHDLParser();
        ParserPath parserPath = vhdlFile.getParserPath();
        if (vParser != null && filePath != null) {
            this.handleFloatingNotification(VhdlFNotificationProvider.getInstance(), project, file, vProject.isParserInterrupted());
            this.notifyBuildListenersPostIncrementalBuild(new VhdlFileInfo(project, parserPath, file));
        }
    }

    public void cbInstanceIncrementalBuild(VhdlModule vlogFile, IDVTFileInstance instance, VhdlAMS vParser) {
        if (vlogFile == null) {
            return;
        }
        if (vlogFile.isAutoBuildStop()) {
            return;
        }
        IFile file = vlogFile.getFile();
        ParserPath parserPath = vlogFile.getParserPath();
        if (vParser != null && parserPath != null) {
            this.notifyBuildListenersIncrementalBuild(new VhdlFileInfo(file.getProject(), parserPath, file));
        }
    }

    public void cbRemove(IFile file) {
        IVhdlModule vModule = this.getVhdlModel().getOrCreateVhdlFile(file);
        if (vModule != null) {
            this.notifyBuildListenersRemove(vModule);
        }
    }

    public void cbClean(IFile file) {
        IVhdlModule vhdlFile = this.getVhdlModel().getOrCreateVhdlFile(file);
        if (vhdlFile == null) {
            return;
        }
        this.notifyBuildListenersClean(vhdlFile);
    }

    public VhdlFileInfo getModuleInfo(DVTFileInfo dvtFileInfo) {
        return (VhdlFileInfo)dvtFileInfo;
    }

    public IVhdlModule getIVhdlModule(IDVTFile iDVTFile) {
        return (IVhdlModule)iDVTFile;
    }

    public void addTopFile(String parserPath) {
        IPath path = Path.fromOSString((String)parserPath);
        this.fTopFilesErrors.put(path, null);
        this.fTopFilesWarnings.put(path, null);
    }

    public void cleanVhdlProject(IProject project) {
        this.fModel.cleanIDVTProject(project);
    }
}

