/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTFile;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.builders.VhdlPoolingCancelThread;
import ro.amiq.vhdldt.model.IVhdlModule;
import ro.amiq.vhdldt.model.IVhdlProject;
import ro.amiq.vhdldt.model.RebuildTriggerJob;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.parser.VhdlAMS;
import ro.amiq.vhdldt.parser.VhdlProblem;
import ro.amiq.vhdldt.ui.persistenttask.PersistentTaskManager;

public class VhdlModule
extends DVTFile
implements IVhdlModule {
    private RebuildTriggerJob fRebuildJob = new RebuildTriggerJob(this);
    private boolean fForceBuild;
    private boolean fAutobuildStop;
    private boolean fEncrypted;

    public VhdlModule(IFile iFile) {
        super(iFile);
    }

    public void scheduleReparse(boolean wait, boolean force, long delay, boolean saveRFDM) {
        this.scheduleReparse(wait, force, delay, null, saveRFDM);
    }

    public void scheduleReparse(boolean wait, boolean force, long delay, IDocument document, boolean saveRFDM) {
        try {
            this.fForceBuild = force;
            boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
            if (cancelIncremental) {
                ChangedFilesManager.cancelBuildJob();
            } else {
                this.fRebuildJob.cancel();
            }
            this.fRebuildJob.setDocument(document);
            if (wait) {
                DVTJobsUtils.scheduleAndJoin((Job)this.fRebuildJob, (long)delay);
            } else {
                this.fRebuildJob.schedule(delay);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void reparse(IProgressMonitor monitor, boolean saveRFDM) {
        this.reparse(monitor, null, saveRFDM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparse(IProgressMonitor monitor, String documentContent, boolean saveRFDM) {
        block19: {
            try {
                this.fAutobuildStop = false;
                IFile file = this.getFile();
                if (file == null) {
                    return;
                }
                IPath location = file.getLocation();
                if (location == null) {
                    return;
                }
                String resourcePath = location.toOSString();
                ParserPath parserPath = this.getParserPath();
                IProject project = file.getProject();
                if (BuildConfigManager.isBuildConfigFile((IProject)project, (ParserPath)parserPath)) {
                    return;
                }
                IVhdlProject vhdlProject = VhdlModelManager.getInstance().getVhdlModel().getVhdlProject(project);
                if (vhdlProject == null) break block19;
                VhdlAMS parser = vhdlProject.getVHDLParser();
                VhdlPoolingCancelThread pooling = null;
                VhdlAMS vhdlAMS = parser;
                synchronized (vhdlAMS) {
                    block22: {
                        RfProject rfProject;
                        block20: {
                            block21: {
                                rfProject = RfManager.getInstance().getRfProject(project);
                                if (!monitor.isCanceled()) break block20;
                                rfProject.cleanIncrementalDeltaContainer();
                                this.fAutobuildStop = true;
                                if (pooling == null) break block21;
                                pooling.stopPoolingThread();
                            }
                            monitor.worked(1);
                            return;
                        }
                        try {
                            try {
                                if (BuildConfigManager.isSkip((IProject)project, (ParserPath)parserPath)) break block22;
                                pooling = new VhdlPoolingCancelThread();
                                pooling.startPoolingThread(monitor, parser, project, true);
                                RfFileDef fileDef = rfProject.getFile((IResource)file);
                                String libraryName = "work";
                                if (fileDef != null && fileDef.getEnclosingLibrary() != null) {
                                    libraryName = fileDef.getEnclosingLibrary().getName();
                                }
                                IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008;
                                if (fileDef != null) {
                                    languageSyntax = fileDef.getLanguageSyntax();
                                }
                                Set taskNames = PersistentTaskManager.getInstance().getAllTaskNames();
                                boolean hideTaskTags = PersistentTaskManager.getInstance().getHideTaskTags();
                                boolean caseSensitiveTaskTags = PersistentTaskManager.getInstance().getCaseSensitiveTaskTags();
                                DVTCodeCommentsPreferences commentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)project);
                                Set translatePragmas = BuildConfigManager.getPreprocessTranslatePragmas((IProject)project);
                                List customPragmas = BuildConfigManager.getCustomPragmas((IProject)project);
                                int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
                                parser.addParsingInstanceListener(this);
                                pooling.setFileName(parserPath.path);
                                parser.parseFile(parserPath.path, libraryName, languageSyntax, rfProject, documentContent, true, -1, -1, maxIssuesKindNumber, translatePragmas, customPragmas, commentsPreferences, taskNames, caseSensitiveTaskTags, hideTaskTags, null);
                            }
                            catch (Exception exception) {
                                if (pooling != null && pooling.getPoolingStatus() == 1) {
                                    this.fAutobuildStop = true;
                                }
                                if (pooling != null) {
                                    pooling.stopPoolingThread();
                                }
                                monitor.worked(1);
                            }
                        }
                        catch (Throwable throwable) {
                            if (pooling != null) {
                                pooling.stopPoolingThread();
                            }
                            monitor.worked(1);
                            throw throwable;
                        }
                    }
                    if (pooling != null) {
                        pooling.stopPoolingThread();
                    }
                    monitor.worked(1);
                    boolean updatePath = !resourcePath.equals(parserPath.path);
                    this.setErrors(parser.getErrors(parserPath), updatePath, resourcePath);
                    this.setWarnings(parser.getWarnings(parserPath), updatePath, resourcePath);
                    this.setTasks(parser.getTasks(parserPath));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void cancelReparse() {
        this.fRebuildJob.cancel();
    }

    @Override
    public boolean isAutoBuildStop() {
        return this.fAutobuildStop;
    }

    @Override
    public boolean isEncrypted() {
        return this.fEncrypted;
    }

    @Override
    public void setEncrypted(boolean encrypted) {
        this.fEncrypted = encrypted;
    }

    @Override
    public void notifyInstanceParsing(IDVTFileInstance instance, VhdlAMS parser) {
        VhdlModelManager.getInstance().cbInstanceIncrementalBuild(this, instance, parser);
    }

    public void setAST(Object ast) {
    }

    public Object getAST() {
        return null;
    }

    @Override
    public void setErrors(List<VhdlProblem> problems, boolean updatePath, String resourceFileName) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            super.setErrors(problems);
            return;
        }
        for (VhdlProblem problem : problems) {
            problem.setFileName(resourceFileName);
        }
        super.setErrors(problems);
    }

    @Override
    public void setWarnings(List<VhdlProblem> problems, boolean updatePath, String resourceFileName) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            super.setWarnings(problems);
            return;
        }
        for (VhdlProblem problem : problems) {
            problem.setFileName(resourceFileName);
        }
        super.setWarnings(problems);
    }

    public void blockingReparse(IProgressMonitor progressMonitor, IDocument document) {
        if (document != null) {
            this.fRebuildJob.setDocument(document);
        }
        this.fRebuildJob.run((IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
    }

    public boolean isForceBuild() {
        return this.fForceBuild;
    }
}

