/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.DVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vhdldt.model.IVhdlConstants;
import ro.amiq.vhdldt.model.IVhdlProject;
import ro.amiq.vhdldt.parser.VhdlAMS;

public class VhdlProject
extends DVTProject
implements IVhdlProject,
IVhdlConstants {
    private List<ParserPath> fParserPaths;
    private VhdlAMS fParser = null;
    private final Object fVhdlSynch = new Object();

    public VhdlProject(IProject project) {
        super(project);
        this.fParserPaths = new ArrayList<ParserPath>();
    }

    @Override
    public void addTopFile(ParserPath moduleName) {
        if (!this.fParserPaths.contains(moduleName)) {
            this.fParserPaths.add(moduleName);
        }
    }

    @Override
    public List<ParserPath> getTopFiles() {
        return this.fParserPaths;
    }

    @Override
    public void clean() {
        this.fParserPaths.clear();
        this.fParser = null;
    }

    @Override
    public VhdlAMS getVHDLParser() {
        if (this.fParser == null) {
            this.createNewVHDLParser();
        }
        this.fParser.resetInterrupt();
        return this.fParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VhdlAMS createNewVHDLParser() {
        Object object = this.fVhdlSynch;
        synchronized (object) {
            this.fParser = new VhdlAMS();
        }
        return this.fParser;
    }

    public boolean isParserInterrupted() {
        if (this.fParser == null) {
            return false;
        }
        return this.fParser.isInterrupted();
    }
}

