/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.persistence;

import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.PrintStream;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.indexer.AbstractIdentifierIndexer;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.persistence.VersionChangedException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfNamedElementVisitor2Adapter;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;

public class Persistence
extends PersistenceBase {
    private static final transient String RFDM_FILE = "vhdl_rfdm";
    private static final transient String RFDM_FILE_COMP_FILES = "vhdl_rfdm_comp_files";
    private static final transient String DIRTY_FILE = "vhdl_dirty";

    public Persistence(IProject project) {
        super(project);
    }

    protected String getDirtyFileName() {
        return DIRTY_FILE;
    }

    protected String getCompiledFilesFileName() {
        return RFDM_FILE_COMP_FILES;
    }

    protected String getRfProjectFileName() {
        return RFDM_FILE;
    }

    protected Class<? extends AbstractIdentifierIndexer> getIdentifierIndexerClass() {
        return null;
    }

    protected void fastSerialize(IRfSingleLangProject rfSingleLangProject, final PersistenceOutputStream stream) throws Exception {
        RfProject rfProject = (RfProject)rfSingleLangProject;
        rfProject.accept(new RfDefElementVisitorAdapter(){

            @Override
            public boolean visitLeaving(RfDefElement defElement) throws Exception {
                Persistence.this.writeObjectWrapper(stream, defElement);
                return true;
            }
        });
        rfProject.visitNamedElements(rfProject, new RfNamedElementVisitor2Adapter(){

            @Override
            public boolean postVisit(RfNamedElement namedElement) throws Exception {
                Persistence.this.writeObjectWrapper(stream, namedElement);
                return true;
            }
        });
        this.writeObjectWrapper(stream, rfProject);
        rfProject.postWriteObject(stream);
        for (ParserPath parserPath : rfProject.getCompiledFilesSet()) {
            RfFileDef rfFileDef = rfProject.getFileDefUsingParserPath(parserPath);
            this.writeObjectWrapper(stream, rfFileDef.getNamedElements());
        }
        rfProject.visitNamedElements(rfProject, new RfNamedElementVisitor2Adapter(){

            @Override
            public boolean postVisit(RfNamedElement namedElement) throws Exception {
                Persistence.this.writeObjectWrapper(stream, (Object)namedElement.getHidHolder());
                return true;
            }
        });
    }

    protected RfProject fastDeSerialize(final PersistenceInputStream stream) throws ClassNotFoundException, IOException, VersionChangedException {
        this.getBenchmark(stream.getPersistenceModeWrapper()).start("[PHASE] RfDefElements");
        Object readObject = this.readObjectWrapper(stream);
        while (!(readObject instanceof RfNamedElement)) {
            readObject = this.readObjectWrapper(stream);
        }
        this.getBenchmark(stream.getPersistenceModeWrapper()).stop("[PHASE] RfDefElements");
        this.getBenchmark(stream.getPersistenceModeWrapper()).start("[PHASE] RfNamedElements");
        while (!(readObject instanceof RfProject)) {
            readObject = this.readObjectWrapper(stream);
        }
        this.getBenchmark(stream.getPersistenceModeWrapper()).stop("[PHASE] RfNamedElements");
        RfProject rfProject = (RfProject)readObject;
        this.getBenchmark(stream.getPersistenceModeWrapper()).start("[PHASE] postReadObject");
        rfProject.postReadObject(stream);
        this.getBenchmark(stream.getPersistenceModeWrapper()).stop("[PHASE] postReadObject");
        for (ParserPath parserPath : rfProject.getCompiledFilesSet()) {
            RfFileDef rfFileDef = rfProject.getFileDefUsingParserPath(parserPath);
            readObject = this.readObjectWrapper(stream);
            if (!(readObject instanceof RfNamedElement[])) continue;
            RfNamedElement[] rfNamedElementArray = (RfNamedElement[])readObject;
            int n = rfNamedElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                RfNamedElement namedElem = rfNamedElementArray[n2];
                rfFileDef.addNamedElement(namedElem);
                ++n2;
            }
        }
        this.getBenchmark(stream.getPersistenceModeWrapper()).start("[PHASE] setEnclosingScopeOfChildrenForRestore");
        rfProject.accept(new RfNamedElementVisitor2Adapter(){

            @Override
            public boolean postVisit(RfNamedElement rfNamedElement) {
                rfNamedElement.setEnclosingScopeOfChildrenForRestore(rfNamedElement);
                return true;
            }

            @Override
            public boolean visitFunctionCalls() {
                return true;
            }
        });
        this.getBenchmark(stream.getPersistenceModeWrapper()).stop("[PHASE] setEnclosingScopeOfChildrenForRestore");
        this.getBenchmark(stream.getPersistenceModeWrapper()).start("[PHASE] setHidHolders");
        rfProject.accept(new RfNamedElementVisitor2Adapter(){

            @Override
            public boolean postVisit(RfNamedElement namedElement) throws Exception {
                namedElement.setHidHolder((RfHidHolder)((Object)Persistence.this.readObjectWrapper(stream)));
                return true;
            }
        });
        this.getBenchmark(stream.getPersistenceModeWrapper()).stop("[PHASE] setHidHolders");
        return rfProject;
    }

    public void writeObjectWrapper(PersistenceOutputStream s, Object o) throws IOException {
        this.threadYield(100L);
        s.writeObject(o);
    }

    public Object readObjectWrapper(PersistenceInputStream s) throws IOException, ClassNotFoundException {
        this.threadYield(300L);
        return s.readObject();
    }

    protected Class<?> resolveClass(ObjectStreamClass desc) {
        block3: {
            try {
                String className = desc.getName();
                if (className.indexOf("ro.amiq.vhdldt.") != -1) break block3;
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return Class.forName(desc.getName());
    }

    protected static class NamedElemntsTreePrinter
    extends RfNamedElementVisitor2Adapter {
        private PrintStream out;

        public NamedElemntsTreePrinter(String section, PrintStream out) {
            this.out = out;
            out.println(section);
        }

        @Override
        public boolean preVisit(RfNamedElement namedElement) throws Exception {
            this.out.println(RfElementPath.path((IRfNamedElement)namedElement).toNiceString());
            return true;
        }

        @Override
        public boolean postVisit(RfNamedElement namedElement) throws Exception {
            return true;
        }
    }
}

