/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;

public class ConstraintErrorInfo {
    private IHidObject hidObject;
    private String errorPattern;
    private String[] errorArgs;

    public ConstraintErrorInfo(IHidObject hidObject, String messagePattern, String ... messageArgs) {
        this.hidObject = hidObject;
        this.errorPattern = messagePattern;
        this.errorArgs = messageArgs;
    }

    public IHidObject getHidObject() {
        return this.hidObject;
    }

    public boolean hasHidObject() {
        return this.hidObject != null;
    }

    public int getLine() {
        if (!this.hasHidObject()) {
            return -1;
        }
        HidOccurrence firstOccurrence = HidUtils.getOccurrence((IHidObject)this.hidObject);
        return HidUtils.getLine((HidOccurrence)firstOccurrence);
    }

    public int getStartOffset() {
        if (!this.hasHidObject()) {
            return -1;
        }
        HidOccurrence firstOccurrence = HidUtils.getOccurrence((IHidObject)this.hidObject);
        return HidUtils.getStartOffset((HidOccurrence)firstOccurrence);
    }

    public int getEndOffset() {
        if (!this.hasHidObject()) {
            return -1;
        }
        HidOccurrence firstOccurrence = HidUtils.getOccurrence((IHidObject)this.hidObject);
        int startOffset = HidUtils.getStartOffset((HidOccurrence)firstOccurrence);
        return HidUtils.getEndOffset((IHidObject)this.hidObject, (int)startOffset, (HidOccurrence)firstOccurrence);
    }

    public String getErrorPattern() {
        return this.errorPattern;
    }

    public Object[] getErrorArgs() {
        return this.errorArgs;
    }
}

