/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.OpenIndexConstraint;
import ro.amiq.vhdldt.model.reflection.RecordConstraintHolder;
import ro.amiq.vhdldt.model.reflection.RfType;

public class ConstraintHolder {
    private RfType type;
    private String variableName;
    protected List<IndexConstraint> constraints;
    public static final String ALREADY_CONSTRAINED = "already_constrained";

    public ConstraintHolder() {
        this.constraints = new ArrayList<IndexConstraint>();
    }

    public ConstraintHolder(List<IndexConstraint> constraints) {
        this.constraints = constraints;
    }

    public ConstraintHolder(RfType type) {
        this.constraints = new ArrayList<IndexConstraint>();
        this.type = type;
    }

    public static ConstraintHolder copyOf(ConstraintHolder other) {
        if (other == null) {
            return null;
        }
        ConstraintHolder copy = null;
        copy = other instanceof RecordConstraintHolder ? new RecordConstraintHolder(new HashMap<String, ConstraintHolder>(((RecordConstraintHolder)other).constraintMap)) : new ConstraintHolder(new ArrayList<IndexConstraint>(other.getConstraints()));
        copy.setType(other.getType());
        copy.setVariableName(other.getVariableName());
        return copy;
    }

    public void addConstraint(IndexConstraint constraint) {
        if (this.constraints != null) {
            this.constraints.add(constraint);
        }
    }

    public boolean consumeConstraint(IndexConstraint toConsume) {
        if (toConsume == null || this.isFullyConstrained()) {
            return false;
        }
        IndexConstraint firstConsumer = this.constraints.get(0);
        if (firstConsumer.consumeConstraint(toConsume)) {
            this.constraints.remove(0);
            return true;
        }
        return false;
    }

    public boolean isFullyConstrained() {
        if (this.constraints == null || this.constraints.isEmpty()) {
            return true;
        }
        for (IndexConstraint c : this.constraints) {
            if (c instanceof OpenIndexConstraint) continue;
            return false;
        }
        return true;
    }

    public List<IndexConstraint> getConstraints() {
        return this.constraints;
    }

    public String consumeConstraints(IndexConstraint topConstraint) {
        if (this.isFullyConstrained()) {
            return topConstraint.isOpen() ? null : ALREADY_CONSTRAINED;
        }
        if (topConstraint.isVariadicConstraint()) {
            List<IndexConstraint> unpackedConstraints = topConstraint.unpackVariadicConstraint();
            int i = unpackedConstraints.size() - 1;
            while (i >= 0) {
                IndexConstraint peeledConstraint = unpackedConstraints.get(i);
                if (this.isFullyConstrained()) {
                    return null;
                }
                if (!this.consumeConstraint(peeledConstraint)) {
                    topConstraint.setLastPeeledConstraint(peeledConstraint);
                    IRfNamedElement errorType = this.constraints.get(0).getConstraintResolvedType();
                    return errorType != null ? errorType.getName() : null;
                }
                --i;
            }
        } else if (!this.consumeConstraint(topConstraint) && HidUtils.isResolved((IHidObject)this.constraints.get(0).getHidObject())) {
            if (this.constraints.get(0) instanceof OpenIndexConstraint) {
                return ALREADY_CONSTRAINED;
            }
            IRfNamedElement errorType = this.constraints.get(0).getConstraintResolvedType();
            return errorType != null ? errorType.getName() : null;
        }
        return null;
    }

    public RfType getType() {
        return this.type;
    }

    public void setType(RfType type) {
        this.type = type;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String toString() {
        return this.constraints != null ? this.constraints.toString() : "[]";
    }
}

