/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import antlr.Token;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;

public class DataType
implements Serializable,
IDataType {
    private static final long serialVersionUID = 2L;
    private List<DataTypeChunk> typeName;
    @Deprecated
    private int offset = -1;
    @Deprecated
    private String range;
    private List<IndexConstraint> elementConstraints;
    private List<IndexConstraint> arrayConstraints;
    private IHidOperator signature;
    public static final DataType INTEGER_DATA_TYPE = new DataType("integer");

    public DataType(List<DataTypeChunk> typeName, int line, int offset) {
        this(typeName);
        this.offset = offset;
    }

    public DataType(String name) {
        this(Collections.singletonList(new DataTypeChunk(name, -1, -1)), -1, -1);
    }

    @Deprecated
    public DataType(Token tok) {
        this(Collections.singletonList(new DataTypeChunk(tok.getText(), -1, -1)), tok.getLine(), tok.getOffset());
    }

    public DataType(List<DataTypeChunk> associatedTypeName) {
        this.typeName = OptimizedUtils.listCreate(associatedTypeName);
    }

    public DataType(DataType dataType) {
        this(dataType.getTypeName(), -1, dataType.getOffset());
        if (dataType.elementConstraints != null) {
            this.elementConstraints = dataType.elementConstraints;
        }
        if (dataType.arrayConstraints != null) {
            this.arrayConstraints = dataType.arrayConstraints;
        }
        this.range = dataType.range;
        this.signature = dataType.signature;
    }

    public DataType(DataType dataType, int line, int offset) {
        this(dataType);
        this.offset = offset;
    }

    public void setElementConstraints(List<IHidObject> constraints) {
        this.elementConstraints = IndexConstraint.ofList(constraints);
    }

    public void setArrayConstraints(List<IHidObject> constraints) {
        this.arrayConstraints = IndexConstraint.ofList(constraints);
    }

    public void setArrayConstraints(IHidObject constraints) {
        if (HidUtils.isOperatorOfKind((IHidObject)constraints, (IHidOperatorConstants.OperatorKind)IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR)) {
            List list = OptimizedUtils.asList((ListContainer)((HidOperator)constraints).getRHValues(), (boolean)true);
            Collections.reverse(list);
            this.setArrayConstraints(list);
        } else {
            this.setArrayConstraints(Collections.singletonList(constraints));
        }
    }

    public int getOffset() {
        DataTypeChunk lastDataType = this.getLastDataTypeChunk();
        return lastDataType != null ? lastDataType.offset : this.offset;
    }

    public String getFirstTypeName() {
        if (this.typeName == null || this.typeName.isEmpty()) {
            return "";
        }
        return this.typeName.get((int)0).name;
    }

    public List<DataTypeChunk> getTypeName() {
        return this.typeName;
    }

    public boolean equalsChangedFieldAndMethodDataType(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
            return false;
        }
        if (this.arrayConstraints == null ? other.arrayConstraints != null : !this.arrayConstraints.equals(other.arrayConstraints)) {
            return false;
        }
        return !(this.elementConstraints == null ? other.elementConstraints != null : !this.elementConstraints.equals(other.elementConstraints));
    }

    @Deprecated
    public String getRange() {
        return this.range;
    }

    public static String getFullTypeName(DataType dataType, boolean noRange) {
        if (dataType == null) {
            return "";
        }
        if (dataType.range == null || dataType.range.isEmpty() || noRange) {
            return DataType.qualifiedNameAsString(dataType.typeName).toString();
        }
        return DataType.qualifiedNameAsString(dataType.typeName).append('(').append(dataType.range).append(')').toString();
    }

    public static StringBuilder qualifiedNameAsString(List<DataTypeChunk> qualifiedName) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (qualifiedName != null && i < qualifiedName.size()) {
            result.append(qualifiedName.get((int)i).name);
            if (i < qualifiedName.size() - 1) {
                result.append(".");
            }
            ++i;
        }
        return result;
    }

    public IHidOperator getSignature() {
        return this.signature;
    }

    public void setSignature(IHidOperator signature) {
        this.signature = signature;
    }

    public IRfNamedElement getArrayIndexType(int position, SEvaluator.VhdlSemanticOperatorVisitor visitor) {
        IHidObject constraint = this.getArrayConstraintHidObject(position);
        if (constraint == null) {
            return null;
        }
        IRfNamedElement constraintType = null;
        switch (constraint.getHidKind()) {
            case ACCESS: {
                constraint = ((RfHidAccess)constraint).getParentHid();
                if (constraint == null) break;
            }
            case HID: {
                RfHid hid = (RfHid)constraint;
                constraintType = hid.getElement();
                break;
            }
            case OPERATOR: {
                ISDataType sDataType;
                HidOperator operator = (HidOperator)constraint;
                ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)operator.getOperatorResolvedType());
                if (dataType == null || dataType.getType() == SDataAbstracts.UNDEFINED_ELEMENT) {
                    visitor.resolveCompleteOperator((IHidObject)operator, null, null);
                    dataType = SDataUtils.getDataType((ISDataAbstract)operator.getOperatorResolvedType());
                }
                constraintType = (sDataType = SDataUtils.getDataType((ISDataAbstract)dataType)) == null ? null : sDataType.getType();
                break;
            }
        }
        return constraintType;
    }

    public ISDataType getArrayIndexDataType(int position) {
        IHidObject constraint = this.getArrayConstraintHidObject(position);
        if (constraint == null) {
            return null;
        }
        ISDataType constraintDataType = SDataAbstracts.UNDEFINED;
        switch (constraint.getHidKind()) {
            case ACCESS: {
                constraint = ((RfHidAccess)constraint).getParentHid();
                if (constraint == null) break;
            }
            case HID: {
                RfHid hid = (RfHid)constraint;
                constraintDataType = SDataType.of(hid.getElement());
                break;
            }
            case OPERATOR: {
                HidOperator operator = (HidOperator)constraint;
                constraintDataType = SDataUtils.getDataType((ISDataAbstract)operator.getOperatorResolvedType());
                break;
            }
        }
        return constraintDataType;
    }

    public void clear() {
        if (this.typeName != null) {
            this.typeName.clear();
        }
        this.elementConstraints = null;
        this.arrayConstraints = null;
        this.range = null;
        this.signature = null;
    }

    public void setTypeFullName(String fullTypeName) {
        this.range = DVTStringUtil.intern((String)this.internalGetRange(fullTypeName));
    }

    public void setTypeName(String typeName) {
        this.typeName = Collections.singletonList(new DataTypeChunk(typeName, -1, -1));
    }

    protected String internalGetRange(String fullTypeName) {
        int end;
        if (fullTypeName == null) {
            return "";
        }
        if (fullTypeName.indexOf(40) < 0) {
            String lowerCaseTypeName = fullTypeName.toLowerCase();
            int indexRange = lowerCaseTypeName.indexOf("range");
            if (!(indexRange <= 0 || Character.isJavaIdentifierPart(lowerCaseTypeName.charAt(indexRange - 1)) || lowerCaseTypeName.length() != indexRange + 5 && Character.isJavaIdentifierPart(lowerCaseTypeName.charAt(indexRange + 5)))) {
                int indexTolerance = lowerCaseTypeName.indexOf("tolerance");
                int end2 = indexTolerance != -1 ? indexTolerance : fullTypeName.length();
                return fullTypeName.substring(indexRange, end2);
            }
            return "";
        }
        int start = fullTypeName.indexOf(40) + 1;
        if (start >= (end = fullTypeName.lastIndexOf(41))) {
            return "";
        }
        return fullTypeName.substring(start, end).trim();
    }

    public int getNofElementConstraints() {
        return this.elementConstraints != null ? this.elementConstraints.size() : 0;
    }

    public int getNofArrayConstraints() {
        return this.arrayConstraints != null ? this.arrayConstraints.size() : 0;
    }

    public List<IndexConstraint> getElementConstraints() {
        return this.elementConstraints != null ? this.elementConstraints : Collections.emptyList();
    }

    public List<IndexConstraint> getArrayConstraints() {
        return this.arrayConstraints != null ? this.arrayConstraints : Collections.emptyList();
    }

    public List<IHidObject> getArrayConstraintHidObjects() {
        if (this.arrayConstraints == null || this.arrayConstraints.isEmpty()) {
            return Collections.emptyList();
        }
        List result = OptimizedUtils.listCreate((int)this.arrayConstraints.size());
        for (IndexConstraint constraint : this.arrayConstraints) {
            result.add(constraint.getHidObject());
        }
        return result;
    }

    public IndexConstraint getArrayConstraint(int position) {
        if (this.arrayConstraints == null || this.arrayConstraints.isEmpty()) {
            return null;
        }
        IndexConstraint indexConstraint = this.arrayConstraints.get(position >= this.arrayConstraints.size() ? 0 : position);
        if (indexConstraint.isVariadicConstraint()) {
            List<IndexConstraint> unpacked = indexConstraint.unpackVariadicConstraint();
            if (unpacked.isEmpty()) {
                return null;
            }
            int length = unpacked.size();
            position = length - position - 1;
            if (position < 0 || position >= length) {
                return null;
            }
            return unpacked.get(position);
        }
        return indexConstraint;
    }

    public IHidObject getArrayConstraintHidObject(int position) {
        IndexConstraint constraint = this.getArrayConstraint(position);
        if (constraint == null) {
            return null;
        }
        return constraint.getHidObject();
    }

    public List<IHidObject> getElementConstraintHidObjects() {
        if (this.elementConstraints == null) {
            return Collections.emptyList();
        }
        List result = OptimizedUtils.listCreate((int)this.elementConstraints.size());
        for (IndexConstraint constraint : this.elementConstraints) {
            result.add(constraint.getHidObject());
        }
        return result;
    }

    public IndexConstraint getElementConstraint(int position) {
        if (this.elementConstraints == null || this.elementConstraints.isEmpty()) {
            return null;
        }
        IndexConstraint indexConstraint = this.elementConstraints.get(position = position < 0 || position >= this.elementConstraints.size() ? 0 : position);
        if (indexConstraint.isVariadicConstraint()) {
            List<IndexConstraint> unpacked = indexConstraint.unpackVariadicConstraint();
            if (unpacked.isEmpty()) {
                return null;
            }
            int length = unpacked.size();
            position = length - position - 1;
            if (position < 0 || position >= length) {
                return null;
            }
            return unpacked.get(position);
        }
        return indexConstraint;
    }

    public IHidObject getElementConstraintHidObject(int position) {
        IndexConstraint constraint = this.getElementConstraint(position);
        if (constraint == null) {
            return null;
        }
        return constraint.getHidObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.typeName);
        if (this.elementConstraints != null) {
            sb.append(" ").append(this.elementConstraints.toString());
        }
        return sb.toString();
    }

    public void decreaseArrayConstraints() {
        this.arrayConstraints = DataType.decreaseConstraints(this.arrayConstraints);
        this.range = null;
    }

    public void decreaseElementConstraints() {
        this.elementConstraints = DataType.decreaseConstraints(this.elementConstraints);
        this.range = null;
    }

    private static List<IndexConstraint> decreaseConstraints(List<IndexConstraint> constraints) {
        if (constraints == null || constraints.isEmpty()) {
            return null;
        }
        if (constraints.size() == 1) {
            return null;
        }
        List result = OptimizedUtils.listCreate((int)(constraints.size() - 1));
        result.addAll(constraints.subList(1, constraints.size()));
        return result;
    }

    public DataTypeChunk getDataTypeChunk(int i) {
        if (this.typeName == null || this.typeName.isEmpty()) {
            return null;
        }
        if (i < 0 || i >= this.typeName.size()) {
            return null;
        }
        return this.typeName.get(i);
    }

    public DataTypeChunk getLastDataTypeChunk() {
        if (this.typeName == null || this.typeName.isEmpty()) {
            return null;
        }
        return this.typeName.get(this.typeName.size() - 1);
    }

    public DataTypeChunk getFirstDataTypeChunk() {
        if (this.typeName == null || this.typeName.isEmpty()) {
            return null;
        }
        return this.typeName.get(0);
    }

    public int getNofChuncks() {
        return this.typeName == null ? 0 : this.typeName.size();
    }
}

