/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.QFileCompileInfo;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.parser.VhdlFileInstancesMap;

public class FileReferenceGraph {
    private Map<ParserPath, Set<ParserPath>> referencersMap;
    private Map<ParserPath, Set<ParserPath>> referencedMap;
    private Map<ParserPath, Set<ParserPath>> cReferencersMap;
    private Map<ParserPath, Set<ParserPath>> cReferencedMap;
    private Map<ParserPath, Integer> inDegree;
    private Map<ParserPath, Integer> cInDegree;
    private Set<ParserPath> compiledFiles;
    private RfProject rfProject;
    private boolean isDirty;
    private boolean inclComps;

    public FileReferenceGraph(RfProject rfProject) {
        if (rfProject == null) {
            return;
        }
        this.rfProject = rfProject;
        this.reset(false, false);
    }

    private void reset(boolean computeDependencies, boolean includeComponents) {
        this.isDirty = true;
        this.compiledFiles = this.rfProject.getCompiledFilesSet();
        this.inDegree = new LinkedHashMap<ParserPath, Integer>();
        this.cInDegree = new LinkedHashMap<ParserPath, Integer>();
        this.referencedMap = new LinkedHashMap<ParserPath, Set<ParserPath>>();
        this.referencersMap = new LinkedHashMap<ParserPath, Set<ParserPath>>();
        this.cReferencedMap = new LinkedHashMap<ParserPath, Set<ParserPath>>();
        this.cReferencersMap = new LinkedHashMap<ParserPath, Set<ParserPath>>();
        if (computeDependencies) {
            this.recomputeDependencies(includeComponents);
            this.inclComps = includeComponents;
        }
    }

    private void recomputeDependencies(boolean includeComponents) {
        if (this.rfProject == null) {
            return;
        }
        this.rfProject.visitHidObject(this.rfProject, new FileReferenceHidVisitor());
        this.rfProject.visitNamedElements(this.rfProject, new FileReferenceElementVisitor(includeComponents));
        this.isDirty = false;
    }

    public List<QFileCompileInfo> getQFileCompileInfos(ParserPath path, boolean recursive, boolean inclComps) {
        Set<ParserPath> cSet;
        if (this.isDirty || this.inclComps ^ inclComps) {
            this.reset(true, inclComps);
        }
        if (path == null) {
            return this.transformInQPath(this.sort(inclComps));
        }
        HashSet<ParserPath> dependencies = new HashSet<ParserPath>();
        dependencies.add(path);
        Set<ParserPath> set = this.referencedMap.get(path);
        if (inclComps && (cSet = this.cReferencedMap.get(path)) != null) {
            if (set == null) {
                set = cSet;
            } else {
                set.addAll(cSet);
            }
        }
        if (set == null) {
            return this.transformInQPath(this.sort(dependencies, inclComps));
        }
        if (!recursive) {
            set.add(path);
            return this.transformInQPath(set);
        }
        LinkedList<ParserPath> queue = new LinkedList<ParserPath>(set);
        while (!queue.isEmpty()) {
            Set<ParserPath> cSet2;
            ParserPath head = (ParserPath)queue.poll();
            dependencies.add(head);
            set = this.referencedMap.get(head);
            if (inclComps && (cSet2 = this.cReferencedMap.get(head)) != null) {
                if (set == null) {
                    set = cSet2;
                } else {
                    set.addAll(cSet2);
                }
            }
            if (set == null) continue;
            for (ParserPath pth : set) {
                if (dependencies.contains(pth)) continue;
                queue.add(pth);
            }
        }
        return this.transformInQPath(this.sort(dependencies, inclComps));
    }

    private List<ParserPath> sort(boolean inclComps) {
        return this.sort(this.compiledFiles, inclComps);
    }

    private List<ParserPath> sort(Set<ParserPath> files, boolean inclComps) {
        if (files == null || this.referencersMap == null) {
            return null;
        }
        HashMap<ParserPath, Integer> inDegree = new HashMap<ParserPath, Integer>(this.inDegree);
        if (inclComps) {
            inDegree.putAll(this.cInDegree);
        }
        int visitedCount = 0;
        LinkedList<ParserPath> queue = new LinkedList<ParserPath>();
        for (ParserPath path : files) {
            if (inDegree.get(path) != null && (Integer)inDegree.get(path) != 0) continue;
            queue.add(path);
        }
        ArrayList<ParserPath> result = new ArrayList<ParserPath>();
        while (!queue.isEmpty()) {
            Set<ParserPath> set;
            ParserPath head = (ParserPath)queue.poll();
            if (files.contains(head)) {
                result.add(head);
                ++visitedCount;
            }
            Set<ParserPath> referencers = this.referencersMap.get(head);
            if (inclComps && (set = this.cReferencersMap.get(head)) != null) {
                if (referencers == null) {
                    referencers = set;
                } else {
                    referencers.addAll(set);
                }
            }
            if (referencers == null) continue;
            for (ParserPath path : referencers) {
                Integer inDegreeOfPath = (Integer)inDegree.get(path);
                if (inDegreeOfPath == null) {
                    queue.add(path);
                    continue;
                }
                inDegreeOfPath = inDegreeOfPath - 1;
                inDegree.put(path, inDegreeOfPath);
                if (inDegreeOfPath != 0) continue;
                queue.add(path);
            }
        }
        if (visitedCount != files.size()) {
            return new ArrayList<ParserPath>(files);
        }
        return result;
    }

    private List<QFileCompileInfo> transformInQPath(Collection<ParserPath> paths) {
        if (paths == null || this.rfProject == null) {
            return null;
        }
        VhdlFileInstancesMap fileInstancesMap = this.rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        ArrayList<QFileCompileInfo> result = new ArrayList<QFileCompileInfo>();
        for (ParserPath path : paths) {
            List<VhdlFileInstance> fileInstances = fileInstancesMap.getFileInstances(path);
            if (fileInstances == null || fileInstances.isEmpty()) {
                return null;
            }
            VhdlFileInstance first = fileInstances.iterator().next();
            result.add(new QFileCompileInfo(path, first.getLibraryScopeName(), first.getLanguageSyntax()));
        }
        return result;
    }

    private void addComponentReference(ParserPath from, ParserPath to) {
        Set<ParserPath> referencedBy;
        if (from.path.equals(to.path)) {
            return;
        }
        if (this.cReferencersMap == null) {
            this.cReferencersMap = new HashMap<ParserPath, Set<ParserPath>>();
        }
        if (this.cReferencedMap == null) {
            this.cReferencedMap = new HashMap<ParserPath, Set<ParserPath>>();
        }
        if ((referencedBy = this.cReferencersMap.get(to)) == null) {
            referencedBy = new HashSet<ParserPath>();
            this.cReferencersMap.put(to, referencedBy);
        }
        if (referencedBy.contains(from)) {
            return;
        }
        referencedBy.add(from);
        Set<ParserPath> referencedIn = this.cReferencedMap.get(from);
        if (referencedIn == null) {
            referencedIn = new HashSet<ParserPath>();
            this.cReferencedMap.put(from, referencedIn);
        }
        if (!referencedIn.contains(to)) {
            referencedIn.add(to);
        }
        if (!this.cInDegree.containsKey(from)) {
            this.cInDegree.put(from, 1);
        } else {
            this.cInDegree.put(from, this.cInDegree.get(from) + 1);
        }
    }

    private void addReference(ParserPath from, ParserPath to) {
        Set<ParserPath> referencedBy;
        if (from.path.equals(to.path)) {
            return;
        }
        if (this.referencersMap == null) {
            this.referencersMap = new HashMap<ParserPath, Set<ParserPath>>();
        }
        if (this.referencedMap == null) {
            this.referencedMap = new HashMap<ParserPath, Set<ParserPath>>();
        }
        if ((referencedBy = this.referencersMap.get(to)) == null) {
            referencedBy = new HashSet<ParserPath>();
            this.referencersMap.put(to, referencedBy);
        }
        if (referencedBy.contains(from)) {
            return;
        }
        referencedBy.add(from);
        Set<ParserPath> referencedIn = this.referencedMap.get(from);
        if (referencedIn == null) {
            referencedIn = new HashSet<ParserPath>();
            this.referencedMap.put(from, referencedIn);
        }
        if (!referencedIn.contains(to)) {
            referencedIn.add(to);
        }
        if (!this.inDegree.containsKey(from)) {
            this.inDegree.put(from, 1);
        } else {
            this.inDegree.put(from, this.inDegree.get(from) + 1);
        }
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    private class FileReferenceElementVisitor
    implements IRfNamedElementVisitor {
        public boolean compDeps;

        public FileReferenceElementVisitor(boolean compDeps) {
            this.compDeps = compDeps;
        }

        private void checkUses(RfNamedElement elem) {
            if (elem == null || elem.getDeclaration() == null || elem.getDeclaration().getParserPath() == null) {
                return;
            }
            ParserPath parserPath = elem.getDeclaration().getParserPath();
            ArrayList<ImportInfo> uses = new ArrayList<ImportInfo>();
            List<ImportInfo> wildcardUse = elem.getWildcardUse();
            List<ImportInfo> explicitUse = elem.getExplicitUse();
            if (explicitUse != null) {
                uses.addAll(explicitUse);
            }
            if (wildcardUse != null) {
                uses.addAll(wildcardUse);
            }
            for (ImportInfo importInfo : uses) {
                IRfNamedElement resolved = importInfo.getElement();
                if (!(resolved instanceof RfNamedElement) || resolved.isPredefined() || resolved.getDeclaration() == null || resolved.getDeclaration().getParserPath() == null) continue;
                FileReferenceGraph.this.addReference(parserPath, resolved.getDeclaration().getParserPath());
            }
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            this.checkUses(namedElement);
            if (!(namedElement instanceof IRfAssociatedType)) {
                return true;
            }
            IRfAssociatedType assocType = (IRfAssociatedType)((Object)namedElement);
            RfDefElement declaration = ((RfNamedElement)((Object)assocType)).getDeclaration();
            if (((RfNamedElement)((Object)assocType)).isPredefined() || declaration == null) {
                return true;
            }
            ParserPath parserPath = declaration.getParserPath();
            if (parserPath == null) {
                return true;
            }
            IRfNamedElement transientType = assocType.getAssociatedType();
            if (!(transientType instanceof RfNamedElement) || transientType.isPredefined()) {
                return true;
            }
            IRfDefElement tDeclaration = transientType.getDeclaration();
            if (tDeclaration != null && tDeclaration.getParserPath() != null) {
                FileReferenceGraph.this.addReference(parserPath, tDeclaration.getParserPath());
            }
            if (!this.compDeps) {
                return true;
            }
            if (!(assocType instanceof RfInstance) || !DesignUtils.isVHDLComponent((Object)transientType)) {
                return true;
            }
            IRfDesignElement binding = ((RfInstance)assocType).computeComponentBinding((IRfDesignElement)transientType);
            if (!(binding instanceof RfNamedElement)) {
                return true;
            }
            RfDefElement rDeclaration = ((RfNamedElement)binding).getDeclaration();
            if (rDeclaration == null || rDeclaration.getParserPath() == null) {
                return true;
            }
            FileReferenceGraph.this.addComponentReference(parserPath, rDeclaration.getParserPath());
            return true;
        }
    }

    private class FileReferenceHidVisitor
    extends RfHidVisitor {
        private FileReferenceHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (this.parserPath == null) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfNamedElement) || element.isPredefined()) {
                return true;
            }
            IRfDefElement declaration = element.getDeclaration();
            if (declaration == null || declaration.getParserPath() == null) {
                return true;
            }
            FileReferenceGraph.this.addReference(this.parserPath, declaration.getParserPath());
            return true;
        }
    }
}

