/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.parser.VhdlCompileInfo;

public class ImportInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<DataTypeChunk> fUseClauseList;
    private String fExplicitName;
    private int fLine;
    private int fOffset;
    private ParserPath fParserPath;
    private boolean fDirty;
    private ImportInfoKind fImportInfoKind;
    private VhdlCompileInfo compileInfo;
    private transient IRfNamedElement fImportElement;
    private transient RfAlias fPackageInstance;

    public ImportInfo(List<DataTypeChunk> use, String explicit, ImportInfoKind importInfoKind, int line, int offset, ParserPath parserPath) {
        this.fUseClauseList = use;
        this.fExplicitName = DVTStringUtil.intern((String)explicit);
        this.fImportInfoKind = importInfoKind;
        this.fLine = line;
        this.fOffset = offset;
        this.fParserPath = parserPath;
        this.fDirty = false;
        this.compileInfo = null;
    }

    public List<DataTypeChunk> getUseClauseList() {
        return this.fUseClauseList;
    }

    public String getExplicitName() {
        return this.fExplicitName;
    }

    public int getExplicitOffset(int index) {
        if (this.fUseClauseList == null) {
            return this.fOffset;
        }
        if (index >= this.fUseClauseList.size()) {
            return this.fOffset;
        }
        int explicitOffset = this.fUseClauseList.get((int)index).offset;
        return explicitOffset < 0 ? this.fOffset : explicitOffset;
    }

    public ImportInfoKind getImportInfoKind() {
        return this.fImportInfoKind;
    }

    public VhdlCompileInfo getCompileInfo() {
        return this.compileInfo;
    }

    public void setCompileInfo(VhdlCompileInfo compileInfo) {
        this.compileInfo = compileInfo;
    }

    public int getLine() {
        return this.fLine;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public ParserPath getParserPath() {
        return this.fParserPath;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void setDirty(boolean dirty) {
        this.fImportElement = null;
        this.fPackageInstance = null;
        this.fDirty = dirty;
    }

    public void setElement(IRfNamedElement rfElement) {
        this.fImportElement = rfElement;
    }

    public IRfNamedElement getElement() {
        return this.fImportElement;
    }

    public IRfNamedElement getImportedElement() {
        IRfNamedElement element = this.getElement();
        if (element instanceof IRfPackageElement || element instanceof RfAlias || element instanceof RfContext) {
            return element;
        }
        IRfPackageElement enclosingPackage = (IRfPackageElement)element.getEnclosingScope(RfPackage.class);
        if (enclosingPackage != null) {
            return enclosingPackage;
        }
        enclosingPackage = (IRfPackageElement)element.getEnclosingScope(RfPackageBody.class);
        if (enclosingPackage != null) {
            return enclosingPackage;
        }
        return null;
    }

    public RfAlias getPackageInstance() {
        return this.fPackageInstance;
    }

    public IRfNamedElement resolve(RfProject rfProject, RfNamedElement scope, boolean otherLanguage) {
        IRfNamedElement candidate;
        IRfNamedElement element = this.internalResolveScope(rfProject, scope, otherLanguage);
        if (element == null || element instanceof ErrorPackage) {
            return element;
        }
        if (this.fExplicitName == null) {
            return element;
        }
        String explicitName = this.fExplicitName;
        if (explicitName.startsWith("\"") && !RfFunction.PREDEFINED_OPERATORS.contains(explicitName)) {
            explicitName = explicitName.substring(1, explicitName.length() - 1);
        }
        if ((candidate = element.getVisibleMemberInScope(explicitName, null, null, new HashSet(), null, false, true, false, false)) instanceof RfPackageBody) {
            candidate = ((RfPackageBody)candidate).getPackage();
        } else if (candidate == null || element instanceof RfType && candidate instanceof RfEnum) {
            return new ErrorPackage("UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", this.fExplicitName, this.fUseClauseList.size());
        }
        return candidate;
    }

    private IRfNamedElement internalResolveScope(RfProject rfProject, RfNamedElement scope, boolean otherLanguage) {
        if (this.fUseClauseList == null || this.fUseClauseList.isEmpty()) {
            return null;
        }
        RfMixedLangProject mixedLangProjectParent = rfProject.getMixedLangProjectParent();
        if (this.fUseClauseList.size() == 1) {
            String libraryName = this.fUseClauseList.get((int)0).name;
            IRfLibraryElement library = scope.getLibraryAndWork(libraryName);
            if (library != null && !otherLanguage) {
                return library;
            }
            if (otherLanguage && mixedLangProjectParent != null && (library = mixedLangProjectParent.getLibraryWithPrefix((IRfSingleLangProject)rfProject, libraryName, 9)) != null) {
                return library;
            }
            IRfNamedElement element = scope.getSignalWithPrefix(libraryName, 1);
            if (element instanceof RfAlias && ((RfAlias)element).isPackageInstatiation()) {
                this.fPackageInstance = (RfAlias)element;
                element = this.fPackageInstance.internalComputeInstantiatedPackage();
                if (element instanceof RfPackage) {
                    return element;
                }
            }
            return new ErrorPackage("UNDECLARED_LIBRARY: Library ''{0}'' is not declared", libraryName, 0);
        }
        IRfPackageElement packageCandidate = null;
        String libraryName = this.fUseClauseList.get((int)0).name;
        String packageName = this.fUseClauseList.get((int)1).name;
        boolean isLibraryMissing = true;
        IRfLibraryElement libraryCandidate = scope.getLibraryAndWork(libraryName);
        if (libraryCandidate != null) {
            libraryName = libraryCandidate.getName();
            isLibraryMissing = false;
            packageCandidate = this.internalResolvePackage(libraryCandidate);
            if (packageCandidate == null && "work".equalsIgnoreCase(this.fUseClauseList.get((int)0).name) && (libraryCandidate = scope.getLibraryWithPrefix("work", 9)) != null) {
                packageCandidate = this.internalResolvePackage(libraryCandidate);
            }
        }
        if (packageCandidate == null && otherLanguage && mixedLangProjectParent != null && (libraryCandidate = mixedLangProjectParent.getLibraryWithPrefix((IRfSingleLangProject)rfProject, libraryName, 9)) != null) {
            isLibraryMissing = false;
            packageCandidate = libraryCandidate.getPackageWithPrefix(packageName, 9);
        }
        if (isLibraryMissing) {
            return new ErrorPackage("UNDECLARED_LIBRARY: Library ''{0}'' is not declared", libraryName, 0);
        }
        if (packageCandidate == null) {
            return new ErrorPackage("UNDECLARED_PACKAGE: Package ''{0}'' is not declared", packageName, 1);
        }
        IRfPackageElement useScopeElement = packageCandidate;
        String useScopeName = null;
        int useScopeIndex = 2;
        while (useScopeIndex < this.fUseClauseList.size()) {
            useScopeName = this.fUseClauseList.get((int)useScopeIndex).name;
            useScopeElement = useScopeElement.getVisibleMemberInScope(useScopeName, null, null, new HashSet(), null, false, false, false, false);
            ++useScopeIndex;
        }
        if (useScopeElement == null) {
            return new ErrorPackage("UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", useScopeName, useScopeIndex);
        }
        return useScopeElement;
    }

    private IRfPackageElement internalResolvePackage(IRfLibraryElement library) {
        String packageName = this.fUseClauseList.get((int)1).name;
        IRfPackageElement packag = library.getPackageWithPrefix(packageName, 9);
        if (packag != null) {
            return packag;
        }
        IRfNamedElement element = library.getLocalMember(Collections.singleton(RfAlias.class), packageName, null);
        if (element instanceof RfAlias && ((RfAlias)element).isPackageInstatiation()) {
            this.fPackageInstance = (RfAlias)element;
            element = this.fPackageInstance.internalComputeInstantiatedPackage();
            if (element instanceof RfPackage) {
                return (RfPackage)element;
            }
        }
        return null;
    }

    public static class DummyElement
    extends RfNamedElement {
        private static final long serialVersionUID = 1L;

        public DummyElement() {
            super("");
        }

        @Override
        public String getContextType() {
            return null;
        }

        public String getSignature() {
            return null;
        }
    }

    public static class ErrorPackage
    extends RfPackage {
        private static final long serialVersionUID = 1L;
        private String errorMessage;
        private String nameOfMissingItem;
        private int index;

        public ErrorPackage(String errorMessage, String nameOfMissingItem, int index) {
            super("[dummy error package]");
            this.errorMessage = errorMessage;
            this.nameOfMissingItem = nameOfMissingItem;
            this.index = index;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getNameOfMissingItem() {
            return this.nameOfMissingItem;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void elaborateConstants(ELManager manager) {
        }
    }

    public static enum ImportInfoKind {
        LIBRARY_CLAUSE,
        CONTEXT_CLAUSE,
        USE_CLAUSE;

    }

    public static class StdImportInfo
    extends ImportInfo {
        private static final long serialVersionUID = 1L;

        private StdImportInfo(List<DataTypeChunk> use, String explicit, ImportInfoKind importInfoKind, int line, int offset, ParserPath parserPath) {
            super(use, explicit, importInfoKind, line, offset, parserPath);
        }

        public static StdImportInfo of(List<DataTypeChunk> use) {
            return new StdImportInfo(use, null, ImportInfoKind.USE_CLAUSE, -1, -1, new ParserPath("<STD STANDARD>"));
        }

        @Override
        public void setDirty(boolean dirty) {
        }
    }
}

