/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.DeltaFileKind;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.model.reflection.IIncrementalDeltaContainer;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVUnit;

public class IncrementalDeltaContainer
implements IIncrementalDeltaContainer {
    public static final Set<Class<? extends IRfScopeElement>> CLOSEST_TYPE_CONTAINER = new HashSet<Class<? extends IRfScopeElement>>();
    private Set<RfNamedElement> elementsBeforeIncremental = Collections.newSetFromMap(new IdentityHashMap());
    private Set<RfNamedElement> elementsAfterIncremental;
    protected Set<RfNamedElement> changedDataTypeElements;
    protected Set<RfNamedElement> changedExpressionBlocks;
    protected HashSet<String> changedTypeNames = new HashSet();
    protected HashMap<String, Set<RfNamedElement>> changedImportPackageNames;
    protected Set<ParserPath> parserPaths;
    protected Map<ParserPath, Set<IRfNamedElement>> delta;
    protected Map<ParserPath, Collection<RfNamedElement>> firstLevelElements;
    protected Collection<RfNamedElement> currentFileScopes;
    private List<RfDefElement> defElementsBeforeIncremental = new ArrayList<RfDefElement>();
    protected Set<String> updateViewsIds;

    static {
        CLOSEST_TYPE_CONTAINER.add(RfPackageBody.class);
        CLOSEST_TYPE_CONTAINER.add(RfTypeBody.class);
        CLOSEST_TYPE_CONTAINER.add(RfEntity.class);
        CLOSEST_TYPE_CONTAINER.add(RfVUnit.class);
        CLOSEST_TYPE_CONTAINER.add(RfArchitecture.class);
        CLOSEST_TYPE_CONTAINER.add(RfConfiguration.class);
        CLOSEST_TYPE_CONTAINER.add(RfPackage.class);
        CLOSEST_TYPE_CONTAINER.add(RfLibrary.class);
    }

    protected IncrementalDeltaContainer() {
        this.changedImportPackageNames = new HashMap();
        this.parserPaths = new LinkedHashSet<ParserPath>();
        this.firstLevelElements = new LinkedHashMap<ParserPath, Collection<RfNamedElement>>();
        this.delta = new LinkedHashMap<ParserPath, Set<IRfNamedElement>>();
        this.changedDataTypeElements = new LinkedHashSet<RfNamedElement>();
        this.changedExpressionBlocks = new LinkedHashSet<RfNamedElement>();
        this.elementsAfterIncremental = Collections.newSetFromMap(new IdentityHashMap());
        this.updateViewsIds = new HashSet<String>();
        if (TestHelper.isTestMode()) {
            this.updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
        }
    }

    public IncrementalDeltaContainer(IncrementalDeltaContainer incrementalDeltaContainer) {
        this();
        if (incrementalDeltaContainer.elementsBeforeIncremental != null) {
            this.elementsBeforeIncremental.addAll(incrementalDeltaContainer.elementsBeforeIncremental);
        }
        if (incrementalDeltaContainer.changedTypeNames != null) {
            this.changedTypeNames.addAll(incrementalDeltaContainer.changedTypeNames);
        }
        if (incrementalDeltaContainer.changedImportPackageNames != null) {
            this.changedImportPackageNames.putAll(incrementalDeltaContainer.changedImportPackageNames);
        }
        if (incrementalDeltaContainer.parserPaths != null) {
            this.parserPaths.addAll(incrementalDeltaContainer.parserPaths);
        }
        if (incrementalDeltaContainer.firstLevelElements != null) {
            this.firstLevelElements.putAll(incrementalDeltaContainer.firstLevelElements);
        }
        if (incrementalDeltaContainer.delta != null) {
            this.delta.putAll(incrementalDeltaContainer.delta);
        }
        if (incrementalDeltaContainer.elementsAfterIncremental != null) {
            this.elementsAfterIncremental.addAll(incrementalDeltaContainer.elementsAfterIncremental);
        }
        if (incrementalDeltaContainer.updateViewsIds != null) {
            this.updateViewsIds.addAll(incrementalDeltaContainer.updateViewsIds);
        }
        if (incrementalDeltaContainer.changedDataTypeElements != null) {
            this.changedDataTypeElements.addAll(incrementalDeltaContainer.changedDataTypeElements);
        }
        if (incrementalDeltaContainer.changedExpressionBlocks != null) {
            this.changedExpressionBlocks.addAll(incrementalDeltaContainer.changedExpressionBlocks);
        }
        if (incrementalDeltaContainer.defElementsBeforeIncremental != null) {
            this.defElementsBeforeIncremental.addAll(incrementalDeltaContainer.defElementsBeforeIncremental);
        }
    }

    public void removeElement(RfNamedElement element) {
        this.elementsBeforeIncremental.remove(element);
    }

    public void clear() {
        this.elementsBeforeIncremental.clear();
        this.changedTypeNames.clear();
        this.changedImportPackageNames.clear();
        this.defElementsBeforeIncremental.clear();
        this.parserPaths.clear();
        this.firstLevelElements.clear();
        this.delta.clear();
        this.elementsAfterIncremental.clear();
        this.changedDataTypeElements.clear();
        this.changedExpressionBlocks.clear();
        this.updateViewsIds.clear();
        if (TestHelper.isTestMode()) {
            this.updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
        }
    }

    public Map<ParserPath, Set<IRfNamedElement>> getDelta() {
        return this.delta;
    }

    public int getDeltaSize() {
        return this.delta == null ? 0 : this.delta.keySet().size();
    }

    public String logDelta(IIncrementalDeltaContainer.LogOption logOption) {
        ParserPath pp;
        StringBuilder sb = new StringBuilder();
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.BEFORE_INCREMENTAL_NAMED_ELEMENTS)) {
            sb.append("elementsBeforeIncremental:\n");
            if (this.elementsBeforeIncremental != null) {
                for (RfNamedElement rfNamedElement : this.elementsBeforeIncremental) {
                    sb.append("    element before incremental name: " + rfNamedElement.getNameAndEnclosing() + " kind: " + rfNamedElement.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.AFTER_INCREMENTAL_NAMED_ELEMENTS)) {
            sb.append("elementsAfterIncremental:\n");
            if (this.elementsAfterIncremental != null) {
                for (RfNamedElement rfNamedElement : this.elementsAfterIncremental) {
                    sb.append("    element after incremental name: " + rfNamedElement.getName() + " kind: " + rfNamedElement.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.REMOVED_NAMED_ELEMENTS)) {
            Set<RfNamedElement> set = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
            set.addAll(this.elementsBeforeIncremental);
            set.removeAll(this.elementsAfterIncremental);
            sb.append("elementsDiffIncremental (before - after):\n");
            if (set != null) {
                for (RfNamedElement elem : set) {
                    sb.append("    element diff incremental name: " + elem.getName() + " kind: " + elem.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.ADDED_NAME_ELEMENTS)) {
            Set<RfNamedElement> set = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
            set.addAll(this.elementsAfterIncremental);
            set.removeAll(this.elementsBeforeIncremental);
            sb.append("elementsDiffIncremental (after - before):\n");
            if (set != null) {
                for (RfNamedElement elem : set) {
                    sb.append("    element diff incremental name: " + elem.getName() + " kind: " + elem.getClass().toString() + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CHANGED_TYPE_NAMES)) {
            sb.append("changedTypeNames:\n");
            if (this.changedTypeNames != null) {
                for (String string : this.changedTypeNames) {
                    sb.append("    changed type name " + string + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CHANGED_IMPORT_PACKAGE_NAMES)) {
            sb.append("changedImportPackageNames:\n");
            if (this.changedImportPackageNames != null) {
                for (Map.Entry entry : this.changedImportPackageNames.entrySet()) {
                    String name = (String)entry.getKey();
                    sb.append("    package name " + name + "\n");
                    Collection changedImportPackageNamesList = (Collection)entry.getValue();
                    if (changedImportPackageNamesList == null) continue;
                    for (IRfNamedElement elem : changedImportPackageNamesList) {
                        sb.append("        changed import element: " + elem.getNameAndEnclosing() + " kind: " + elem.getClass().toString() + "\n");
                    }
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.PARSER_PATHS)) {
            sb.append("parserPaths:\n");
            if (this.parserPaths != null) {
                for (ParserPath parserPath : this.parserPaths) {
                    sb.append("    parser path: " + parserPath.path + "\n");
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.FIRST_LEVEL_ELEMENTS)) {
            sb.append("firstLevelElements:\n");
            if (this.firstLevelElements != null) {
                for (Map.Entry entry : this.firstLevelElements.entrySet()) {
                    pp = (ParserPath)entry.getKey();
                    sb.append("    parser path " + pp.path + "\n");
                    Collection firstLevelElementsList = (Collection)entry.getValue();
                    if (firstLevelElementsList == null) continue;
                    for (IRfNamedElement elem : firstLevelElementsList) {
                        sb.append("        first level element: " + elem.getNameAndEnclosing() + " kind: " + elem.getClass().toString() + "\n");
                    }
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.DELTA)) {
            sb.append("delta:\n");
            if (this.delta != null) {
                for (Map.Entry entry : this.delta.entrySet()) {
                    pp = (ParserPath)entry.getKey();
                    sb.append("    parser path: " + pp.path + "\n");
                    Set deltaList = (Set)entry.getValue();
                    if (deltaList == null) continue;
                    for (IRfNamedElement elem : deltaList) {
                        sb.append("        delta element: " + elem.getNameAndEnclosing() + " kind: " + elem.getClass().toString() + "\n");
                    }
                }
            }
        }
        if (logOption.hasOption(IIncrementalDeltaContainer.LogOption.CURRENT_FILES_SCOPE)) {
            sb.append("currentFileScopes:\n");
            if (this.currentFileScopes != null) {
                for (RfNamedElement rfNamedElement : this.currentFileScopes) {
                    sb.append("    currentFileScope: " + rfNamedElement.getName() + " kind: " + rfNamedElement.getClass().toString() + "\n");
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.logDelta(IIncrementalDeltaContainer.LogOption.ALL);
    }

    protected void removeDirtyElements(ParserPath parserPath, RfProject rfProject) {
        try {
            RfFileDef fileDef;
            if (this.elementsBeforeIncremental != null && !this.elementsBeforeIncremental.isEmpty()) {
                Set visited = Collections.newSetFromMap(new IdentityHashMap());
                for (RfNamedElement elementBeforeIncremental : this.elementsBeforeIncremental) {
                    RfNamedElement enclosingScope = elementBeforeIncremental.getEnclosingScope();
                    if (enclosingScope == null || visited.contains(enclosingScope)) continue;
                    visited.add(enclosingScope);
                    enclosingScope.removeDirtyElements(parserPath, rfProject);
                }
            }
            if ((fileDef = rfProject.getFileDefUsingParserPath(parserPath)) != null) {
                RfNamedElement[] fileScopes = fileDef.getNamedElements();
                if (fileScopes != null && fileScopes.length > 0) {
                    if (this.currentFileScopes == null) {
                        this.currentFileScopes = new LinkedHashSet<RfNamedElement>();
                    }
                    RfNamedElement[] rfNamedElementArray = fileScopes;
                    int n = fileScopes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RfNamedElement fileScope = rfNamedElementArray[n2];
                        this.currentFileScopes.add(fileScope);
                        ++n2;
                    }
                }
                this.collectElementsInFileAfterIncremental(parserPath, (DVTLinkedHashMap<RfDefElement, RfDefElement>)fileDef.fChildrenDefs, true);
            }
            Set<IRfNamedElement> deltaPerFile = this.collectDependencyList(parserPath, rfProject);
            this.delta.put(parserPath, deltaPerFile);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Set<IRfNamedElement> collectDependencyList(ParserPath parserPath, RfProject project) {
        Set<IRfNamedElement> result = Collections.newSetFromMap(new IdentityHashMap());
        try {
            Set<RfNamedElement> addedElements = Collections.newSetFromMap(new IdentityHashMap(this.elementsAfterIncremental.size()));
            addedElements.addAll(this.elementsAfterIncremental);
            for (RfNamedElement namedElement : this.elementsBeforeIncremental) {
                if (namedElement instanceof RfConfiguration) continue;
                addedElements.remove(namedElement);
            }
            Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(this.elementsBeforeIncremental.size()));
            removedElements.addAll(this.elementsBeforeIncremental);
            removedElements.removeAll(this.elementsAfterIncremental);
            this.removeElementsUnderAnonymousActionBlocks(addedElements, removedElements);
            DVTLogger.INSTANCE.logInfo("DEBUG VHDL: Incremental added elements: " + addedElements);
            DVTLogger.INSTANCE.logInfo("DEBUG VHDL: Incremental removed elements: " + removedElements);
            if (this.changedImportPackageNames != null && !this.changedImportPackageNames.isEmpty()) {
                for (Set<RfNamedElement> importScopes : this.changedImportPackageNames.values()) {
                    if (importScopes == null) continue;
                    addedElements.addAll(importScopes);
                }
            }
            this.collectDependencyList(this.changedDataTypeElements, result, true);
            this.collectViewsUpdateEvents(this.changedDataTypeElements);
            this.collectDependencyList(removedElements, result, true);
            this.collectViewsUpdateEvents(removedElements);
            this.collectDependencyList(addedElements, result, true);
            this.collectViewsUpdateEvents(addedElements);
            this.collectViewsUpdateEvents(this.changedExpressionBlocks);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void removeElementsUnderAnonymousActionBlocks(Set<RfNamedElement> addedElements, Set<RfNamedElement> removedElements) {
        Iterator<RfNamedElement> addedElementsIterator = addedElements.iterator();
        block0: while (addedElementsIterator.hasNext()) {
            RfNamedElement addedElement = addedElementsIterator.next();
            String addedElementCustomName = this.customNameOf(addedElement);
            Iterator<RfNamedElement> removedElementsIterator = removedElements.iterator();
            while (removedElementsIterator.hasNext()) {
                String removedElementCustomName;
                RfNamedElement removedElement = removedElementsIterator.next();
                if (!addedElement.getName().equals(removedElement.getName()) || !addedElementCustomName.equals(removedElementCustomName = this.customNameOf(removedElement))) continue;
                addedElementsIterator.remove();
                removedElementsIterator.remove();
                continue block0;
            }
        }
    }

    private final String customNameOf(RfNamedElement element) {
        StringBuilder result = new StringBuilder(element.getName());
        while ((element = element.getEnclosingScope()) != null) {
            if (element.isAnonymous()) continue;
            result.append('#').append(element.getName());
            if (!CLOSEST_TYPE_CONTAINER.contains(element.getClass())) continue;
            return result.toString();
        }
        return result.toString();
    }

    private void collectViewsUpdateEvents(Set<RfNamedElement> elements) {
        if (TestHelper.isTestMode()) {
            this.updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
        } else {
            this.updateViewsIds.addAll(ViewsUtils.ALL_BUT_DH_VIEWS);
        }
        if (this.updateViewsIds.contains("ro.amiq.dvt.ui.views.LazyDesignHierarchyView")) {
            return;
        }
        for (RfNamedElement element : elements) {
            if (!(element instanceof IRfDesignElement) && !(element instanceof RfInstance) && !(element instanceof RfConfiguration) && (!(element instanceof RfBlock) || !((RfBlock)element).isGenerate() || !((RfBlock)element).hasInstances())) continue;
            this.updateViewsIds.add("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
            break;
        }
    }

    private void collectDependencyList(Collection<? extends RfNamedElement> namedElements, Set<IRfNamedElement> result, boolean checkReferences) {
        try {
            if (namedElements.isEmpty()) {
                return;
            }
            Set visitedElement = Collections.newSetFromMap(new IdentityHashMap());
            for (RfNamedElement rfNamedElement : namedElements) {
                Collection references;
                Collection<RfNamedElement> members;
                RfNamedElement typeContainer;
                if (rfNamedElement == null || (typeContainer = (RfNamedElement)rfNamedElement.getEnclosingScope(CLOSEST_TYPE_CONTAINER)) == null || typeContainer instanceof RfArchitecture && !(rfNamedElement instanceof RfArchitecture) || visitedElement.contains(rfNamedElement)) continue;
                visitedElement.add(rfNamedElement);
                RfLibrary library = typeContainer.getEnclosingLibrary();
                String typeName = typeContainer.getName();
                if (library == null) continue;
                if (rfNamedElement instanceof RfPackage && (members = ((RfPackage)rfNamedElement).getMembers(true, false)) != null && !members.isEmpty()) {
                    this.collectDependencyList(members, result, checkReferences);
                }
                if ((references = library.getReferences(typeName)) == null) continue;
                for (IRfNamedElement reference : new ArrayList(references)) {
                    List<RfArchitecture> newReferences;
                    if (reference == null || result.contains(reference) || !(reference instanceof RfEntity) || (newReferences = ((RfEntity)reference).getArchitectures()) == null) continue;
                    references.addAll(newReferences);
                }
                for (IRfNamedElement reference : references) {
                    boolean isInstanceOrModule;
                    if (reference == null || result.contains(reference)) continue;
                    String elementName = rfNamedElement.getName();
                    boolean isPort = RfSearchUtils.isPortOrParameterElement((IRfNamedElement)rfNamedElement);
                    boolean bl = isInstanceOrModule = reference instanceof RfArchitecture || reference instanceof IRfInstanceElement;
                    if (!checkReferences || isPort || reference.hasReferenceToIdentifierName(elementName)) {
                        result.add(reference);
                        continue;
                    }
                    if (!isInstanceOrModule && !(reference instanceof RfConfiguration)) continue;
                    result.add(reference);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void collectElementsInFileAfterIncremental(ParserPath parserPath, DVTLinkedHashMap<RfDefElement, RfDefElement> childrenDefs, boolean collectFirstLevel) {
        try {
            if (childrenDefs == null || childrenDefs.isEmpty()) {
                return;
            }
            for (RfDefElement defElement : childrenDefs.values()) {
                RfNamedElement[] namedElements = defElement.getNamedElements();
                if (namedElements == null || namedElements.length == 0) {
                    return;
                }
                RfNamedElement[] rfNamedElementArray = namedElements;
                int n = namedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    RfNamedElement namedElement = rfNamedElementArray[n2];
                    if (namedElement != null) {
                        if (!namedElement.isAnonymous()) {
                            this.elementsAfterIncremental.add(namedElement);
                        }
                        Collection<? extends RfDefElement> declarations = namedElement.getDeclarations();
                        for (IRfDefElement iRfDefElement : declarations) {
                            ParserPath parserPath2;
                            if (iRfDefElement == null || (parserPath2 = iRfDefElement.getParserPath()) == null || parserPath2.equals((Object)parserPath)) continue;
                            this.parserPaths.add(parserPath2);
                        }
                        if (collectFirstLevel) {
                            void var12_17;
                            Collection<RfNamedElement> collection;
                            if (this.firstLevelElements == null) {
                                this.firstLevelElements = new HashMap<ParserPath, Collection<RfNamedElement>>();
                            }
                            if ((collection = this.firstLevelElements.get(parserPath)) == null) {
                                ArrayList arrayList = new ArrayList();
                                this.firstLevelElements.put(parserPath, arrayList);
                            }
                            var12_17.add(namedElement);
                        }
                    }
                    ++n2;
                }
                if (defElement.fChildrenDefs == null || defElement.fChildrenDefs.isEmpty() || defElement.fChildrenDefs == childrenDefs) continue;
                this.collectElementsInFileAfterIncremental(parserPath, defElement.fChildrenDefs, false);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean collectElementsInFileBeforeIncremental(RfDefElement defElement, boolean disableChildrenCollect) {
        RfNamedElement[] namedElements;
        block9: {
            block8: {
                block7: {
                    if (!disableChildrenCollect) break block7;
                    return true;
                }
                if (defElement != null) break block8;
                return false;
            }
            this.defElementsBeforeIncremental.add(defElement);
            namedElements = defElement.getNamedElements();
            if (namedElements != null && namedElements.length != 0) break block9;
            return false;
        }
        try {
            RfNamedElement[] rfNamedElementArray = namedElements;
            int n = namedElements.length;
            int n2 = 0;
            while (n2 < n) {
                RfNamedElement namedElement = rfNamedElementArray[n2];
                if (namedElement != null && !namedElement.isAnonymous()) {
                    this.elementsBeforeIncremental.add(namedElement);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public void addChangedParserPath(ParserPath parserPath) {
        if (parserPath == null) {
            return;
        }
        this.parserPaths.add(parserPath);
    }

    public boolean hasConfigChanges() {
        if (this.firstLevelElements == null || this.firstLevelElements.isEmpty()) {
            return false;
        }
        for (Collection<RfNamedElement> elements : this.firstLevelElements.values()) {
            if (elements == null || elements.isEmpty()) continue;
            for (RfNamedElement element : elements) {
                if (!(element instanceof RfConfiguration)) continue;
                return true;
            }
        }
        return false;
    }

    public void collectDeltaInstances(List<IRfInstanceElement> collected) {
        if (collected == null) {
            return;
        }
        Set uniqueChanged = Collections.newSetFromMap(new IdentityHashMap());
        if (this.delta != null) {
            for (Set<IRfNamedElement> changedElements : this.delta.values()) {
                if (changedElements == null || changedElements.isEmpty()) continue;
                for (IRfNamedElement changedElement : changedElements) {
                    if (!(changedElement instanceof IRfInstanceElement)) continue;
                    uniqueChanged.add((IRfInstanceElement)changedElement);
                }
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public void collectDeltaDesigns(List<IRfDesignElement> collected) {
        if (collected == null) {
            return;
        }
        Set uniqueChanged = Collections.newSetFromMap(new IdentityHashMap());
        if (this.firstLevelElements != null) {
            for (Map.Entry entry : this.firstLevelElements.entrySet()) {
                Collection changedElements = (Collection)entry.getValue();
                if (changedElements == null) continue;
                for (RfNamedElement changedElement : changedElements) {
                    RfEntity entity;
                    if (changedElement instanceof RfEntity) {
                        List<RfArchitecture> topArchitectures;
                        if (changedElement.isImplicit() || (topArchitectures = ((RfEntity)changedElement).getArchitectures()) == null || topArchitectures.isEmpty()) continue;
                        uniqueChanged.addAll(topArchitectures);
                        continue;
                    }
                    if (changedElement instanceof IRfEntityComplement && ((entity = (RfEntity)((IRfEntityComplement)changedElement).getEntity()) == null || entity.isImplicit()) || !(changedElement instanceof IRfDesignElement)) continue;
                    uniqueChanged.add((IRfDesignElement)changedElement);
                }
            }
        }
        if (this.delta != null) {
            for (Set set : this.delta.values()) {
                if (set == null || set.isEmpty()) continue;
                for (IRfNamedElement changedElement : set) {
                    RfEntity entity;
                    if (changedElement instanceof RfEntity) {
                        List<RfArchitecture> topArchitectures;
                        if (((RfEntity)changedElement).isImplicit() || (topArchitectures = ((RfEntity)changedElement).getArchitectures()) == null || topArchitectures.isEmpty()) continue;
                        uniqueChanged.addAll(topArchitectures);
                        continue;
                    }
                    if (changedElement instanceof IRfEntityComplement && ((entity = (RfEntity)((IRfEntityComplement)changedElement).getEntity()) == null || entity.isImplicit()) || !(changedElement instanceof IRfDesignElement)) continue;
                    uniqueChanged.add((IRfDesignElement)changedElement);
                }
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public void collectDeltaBlocks(List<IRfDesignElement> collected) {
        LinkedHashSet<IRfDesignElement> uniqueChanged = new LinkedHashSet<IRfDesignElement>();
        Set<RfNamedElement> addedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsAfterIncremental.size())));
        addedElements.addAll(this.elementsAfterIncremental);
        for (RfNamedElement namedElement : this.elementsBeforeIncremental) {
            if (namedElement instanceof RfConfiguration) continue;
            addedElements.remove(namedElement);
        }
        Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
        removedElements.addAll(this.elementsBeforeIncremental);
        removedElements.removeAll(this.elementsAfterIncremental);
        for (RfNamedElement added : addedElements) {
            if (!DesignUtils.isBlock((Object)added)) continue;
            uniqueChanged.add((IRfDesignElement)added);
        }
        for (RfNamedElement removed : removedElements) {
            if (!DesignUtils.isBlock((Object)removed)) continue;
            uniqueChanged.add((IRfDesignElement)removed);
        }
        if (this.changedExpressionBlocks != null) {
            for (RfNamedElement changedBlock : this.changedExpressionBlocks) {
                if (!DesignUtils.isBlock((Object)changedBlock)) continue;
                uniqueChanged.add((IRfDesignElement)changedBlock);
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public boolean hasRemovedDescriptions() {
        Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
        removedElements.addAll(this.elementsBeforeIncremental);
        removedElements.removeAll(this.elementsAfterIncremental);
        for (RfNamedElement removed : removedElements) {
            if (!(removed instanceof IRfInstanceElement)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStructuralDesignChanges() {
        if (this.hasConfigChanges()) {
            return true;
        }
        if (!this.changedExpressionBlocks.isEmpty()) {
            return true;
        }
        for (RfNamedElement namedElement : this.changedDataTypeElements) {
            if (!(namedElement instanceof RfInstance)) continue;
            return true;
        }
        Set<RfNamedElement> addedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsAfterIncremental.size())));
        addedElements.addAll(this.elementsAfterIncremental);
        for (RfNamedElement namedElement : this.elementsBeforeIncremental) {
            if (namedElement instanceof RfConfiguration) continue;
            addedElements.remove(namedElement);
        }
        Set<RfNamedElement> removedElements = Collections.newSetFromMap(new IdentityHashMap(OptimizedUtils.noRehashSize((int)this.elementsBeforeIncremental.size())));
        removedElements.addAll(this.elementsBeforeIncremental);
        removedElements.removeAll(this.elementsAfterIncremental);
        for (RfNamedElement added : addedElements) {
            if (!(added instanceof IRfInstanceElement) && !(added instanceof IRfDesignElement) && !(added instanceof IRfConfiguration)) continue;
            return true;
        }
        for (RfNamedElement removed : removedElements) {
            if (!(removed instanceof IRfInstanceElement) && !(removed instanceof IRfDesignElement) && !(removed instanceof IRfConfiguration)) continue;
            return true;
        }
        return false;
    }

    public void collectChangedPackages(List<IRfPackageElement> collected) {
        if (collected == null) {
            return;
        }
        Set uniqueChanged = Collections.newSetFromMap(new IdentityHashMap());
        if (this.changedImportPackageNames != null && !this.changedImportPackageNames.isEmpty()) {
            for (Set set : this.changedImportPackageNames.values()) {
                if (set == null) continue;
                for (RfNamedElement scope : set) {
                    if (!(scope instanceof IRfPackageElement)) continue;
                    uniqueChanged.add((IRfPackageElement)scope);
                }
            }
        }
        if (this.currentFileScopes != null && !this.currentFileScopes.isEmpty()) {
            for (RfNamedElement rfNamedElement : this.currentFileScopes) {
                if (!(rfNamedElement instanceof IRfPackageElement)) continue;
                uniqueChanged.add((IRfPackageElement)rfNamedElement);
            }
        }
        if (this.firstLevelElements != null && !this.firstLevelElements.isEmpty()) {
            for (Map.Entry entry : this.firstLevelElements.entrySet()) {
                Collection firstLevelElements = (Collection)entry.getValue();
                if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                for (RfNamedElement firstLevelElement : firstLevelElements) {
                    if (!(firstLevelElement instanceof IRfPackageElement)) continue;
                    uniqueChanged.add((IRfPackageElement)firstLevelElement);
                }
            }
        }
        if (this.delta != null) {
            for (Set set : this.delta.values()) {
                if (set == null || set.isEmpty()) continue;
                for (IRfNamedElement changedElement : set) {
                    if (!(changedElement instanceof IRfPackageElement)) continue;
                    uniqueChanged.add((IRfPackageElement)changedElement);
                }
            }
        }
        if (!uniqueChanged.isEmpty()) {
            collected.addAll(uniqueChanged);
        }
    }

    public Set<DeltaFileWrapper> getDeltaFilesParserPath(boolean includeCurrentFileScopes) {
        Set<DeltaFileWrapper> deltaFilesParserPaths = this.parserPaths.stream().map(path -> new DeltaFileWrapper(path, DeltaFileKind.CHANGED)).collect(Collectors.toSet());
        HashSet<RfNamedElement> namedElements = new HashSet<RfNamedElement>();
        if (this.delta != null && !this.delta.isEmpty()) {
            for (Set set : this.delta.values()) {
                if (set == null || set.isEmpty()) continue;
                namedElements.addAll(set);
            }
        }
        if (includeCurrentFileScopes && this.currentFileScopes != null) {
            namedElements.addAll(this.currentFileScopes);
        }
        for (IRfNamedElement iRfNamedElement : namedElements) {
            ParserPath parserPath;
            IRfDefElement declaration;
            if (iRfNamedElement == null || iRfNamedElement.hasNoDefs(false) || (declaration = iRfNamedElement.getDeclaration()) == null || (parserPath = declaration.getParserPath()) == null) continue;
            deltaFilesParserPaths.add(new DeltaFileWrapper(parserPath, DeltaFileKind.DELTA));
        }
        return deltaFilesParserPaths;
    }

    public void restoreDefElementsOnCancelIncremental(RfProject rfProject, ParserPath parserPath) {
        this.changedTypeNames.clear();
        RfFileDef currentFileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (currentFileDef == null) {
            return;
        }
        try {
            currentFileDef.cleanChildren(null, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            for (RfDefElement defElement : this.defElementsBeforeIncremental) {
                RfNamedElement namedElement = defElement.getNamedElement();
                if (namedElement == null) continue;
                currentFileDef.addChild(defElement);
                namedElement.addDeclaration(defElement);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        DVTLogger.INSTANCE.logDebug("DEBUG VHDL: Restored defs on incremental canceled/interrupted build!");
    }

    public void clearDefElementsBeforeIncremental() {
        this.defElementsBeforeIncremental.clear();
    }
}

