/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.RfDummyElement;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;

public class IndexConstraint
implements Serializable {
    private static final String ANONYMOUS = "__NONAME__";
    private static final long serialVersionUID = 2L;
    private IHidObject constraint;
    private String constraintName;
    private IndexConstraint lastPeeledConstraint;

    public IndexConstraint(IHidObject constraint) {
        this.constraint = constraint;
        this.constraintName = ANONYMOUS;
    }

    public IndexConstraint(IHidObject constraint, String name) {
        this(constraint);
        this.constraintName = name == null ? "" : name;
    }

    public static List<IndexConstraint> ofList(List<IHidObject> constraints) {
        if (constraints == null || constraints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IndexConstraint> result = new ArrayList<IndexConstraint>();
        for (IHidObject constraint : constraints) {
            if (HidUtils.isHidAccess((IHidObject)constraint) && ((HidAccess)constraint).getParentHid() != null && !((RfHidAccess)constraint).isAttributeAccess1Step()) {
                result.add(new IndexConstraint(constraint, ((HidAccess)constraint).getParentHid().getName()));
                continue;
            }
            result.add(new IndexConstraint(constraint));
        }
        return result;
    }

    public boolean isOpen() {
        return HidUtils.isHidImplicit((IHidObject)this.constraint) && ((HidImplicit)this.constraint).isOpenAssociation();
    }

    public boolean consumeConstraint(IndexConstraint other) {
        if (!this.constraintName.equals(other.getConstraintName())) {
            return false;
        }
        if (this.isOpen() || other.isOpen()) {
            return false;
        }
        IRfNamedElement myType = this.getConstraintResolvedType();
        IRfNamedElement otherType = other.getConstraintResolvedType();
        if (otherType == null || otherType instanceof RfDummyElement) {
            return true;
        }
        return otherType.checkTypeCompatibility(myType);
    }

    public boolean isNamedConstraint() {
        return HidUtils.isHidAccess((IHidObject)this.constraint) && !ANONYMOUS.equals(this.getConstraintName());
    }

    public boolean isVariadicConstraint() {
        return HidUtils.isOperatorOfKind((IHidObject)this.constraint, (IHidOperatorConstants.OperatorKind)IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR);
    }

    public List<IndexConstraint> unpackVariadicConstraint() {
        if (!this.isVariadicConstraint()) {
            return Collections.emptyList();
        }
        return IndexConstraint.ofList(OptimizedUtils.asList((ListContainer)((HidOperator)this.constraint).getRHValues(), (boolean)false));
    }

    public void setLastPeeledConstraint(IndexConstraint last) {
        this.lastPeeledConstraint = last;
    }

    public IndexConstraint getLastPeeledConstraint() {
        return this.lastPeeledConstraint;
    }

    public boolean isNonCompositeValidConstraint() {
        if (this.isOpen()) {
            return false;
        }
        if (!(this.constraint instanceof RfHidOperator)) {
            return false;
        }
        RfHidOperator constrOp = (RfHidOperator)this.constraint;
        return constrOp.isLiteralRange() && (!(constrOp.getFirstRHValue() instanceof IRfHidImplicitLayer) || !((IRfHidImplicitLayer)constrOp.getFirstRHValue()).isBox());
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public IHidObject getHidObject() {
        return this.constraint;
    }

    public IRfNamedElement getConstraintResolvedType() {
        IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)this.constraint);
        return resolvedElement != SDataAbstracts.UNDEFINED_ELEMENT ? resolvedElement : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.constraintName);
        sb.append("  ;;  ");
        sb.append(this.constraint);
        sb.append("  ;;  ");
        IRfNamedElement constraintType = this.getConstraintResolvedType();
        sb.append(constraintType != null ? constraintType.getName() : "null");
        return sb.toString();
    }

    public List<IndexConstraint> unpackNamedConstraint() {
        if (!this.isNamedConstraint()) {
            return null;
        }
        return IndexConstraint.ofList(((HidAccess)this.constraint).getSelects());
    }
}

