/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class RfActionBlock
extends RfNamedElement
implements IRfActionBlockElement {
    private static final long serialVersionUID = 1L;
    private long blockQualifiers;
    private static final HidOperatorQualifier[] IS_CONDITIONAL_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION};
    private static final HidOperatorQualifier[] IS_CASE_ITEM_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION};
    private static final HidOperatorQualifier[] IS_LOOP_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_LOOP_EXPRESSION};
    private static final Set<String> CASE_EXPRESSION_VECTOR_TYPES = new LinkedHashSet<String>(Arrays.asList("std_ulogic", "bit"));

    public RfActionBlock(String name, long qualifiers) {
        super(name);
        this.blockQualifiers = qualifiers;
    }

    public void init(long qualifiers, String name) {
        this.blockQualifiers = qualifiers;
        this.init(name);
    }

    public String getSignature() {
        if (this.isFor()) {
            return "for loop " + this.getName();
        }
        if (this.isWhile()) {
            return "while loop " + this.getName();
        }
        if (this.isCase()) {
            return "case statement " + this.getName();
        }
        if (this.isCaseItem()) {
            return "case when statement " + this.getName();
        }
        if (this.isIf()) {
            return "if statement " + this.getName();
        }
        if (this.isElsif()) {
            return "elsif statement " + this.getName();
        }
        if (this.isElse()) {
            return "else statement " + this.getName();
        }
        return "sequential statement " + this.getName();
    }

    public boolean hasBlockQualifier(IRfActionBlockElement.BlockQualifier qualifier) {
        if (qualifier == null) {
            return this.blockQualifiers == 0L;
        }
        return (this.blockQualifiers & qualifier.value()) != 0L;
    }

    public boolean hasBlockQualifier(long qualifiers) {
        if (qualifiers == 0L) {
            return this.blockQualifiers == 0L;
        }
        return (this.blockQualifiers & qualifiers) != 0L;
    }

    public boolean isCaseItem() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASE_ITEM.value()) != 0L;
    }

    public boolean isElse() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ELSE.value()) != 0L;
    }

    public boolean isElsif() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ELSIF.value()) != 0L;
    }

    public boolean isIf() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IF.value()) != 0L;
    }

    public boolean isCase() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASE.value()) != 0L;
    }

    public boolean isConditional() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IF.value() + IRfActionBlockElement.BlockQualifier.ELSE.value()) != 0L;
    }

    public boolean isWhile() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.WHILE.value()) != 0L;
    }

    public boolean isForever() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOREVER.value()) != 0L;
    }

    public boolean isFor() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOR.value()) != 0L;
    }

    public boolean isForOrForeach() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOR.value()) != 0L;
    }

    public boolean isLoop() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOR.value() + IRfActionBlockElement.BlockQualifier.WHILE.value() + IRfActionBlockElement.BlockQualifier.FOREVER.value()) != 0L;
    }

    public List<IHidObject> computeConditionOperator(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        if (this.isIf() || this.isElsif() || this.isCase()) {
            List<IHidOperator> operators = this.getHidOperators(IS_CONDITIONAL_EXPRESSION, true);
            if (operators == null || operators.isEmpty()) {
                return null;
            }
            IHidOperator opi = operators.get(0);
            if (guardian != null) {
                guardian.markEvaluated(opi);
            }
            IHidObject lhValue = opi.getLHValue();
            return Collections.singletonList(lhValue);
        }
        if (this.isCaseItem()) {
            ParserPath parserPath;
            RfProject project;
            List<IHidOperator> operators = this.getHidOperators(IS_CASE_ITEM_EXPRESSION, true);
            if (operators == null || operators.isEmpty()) {
                return null;
            }
            IHidOperator opi = operators.get(0);
            if (guardian != null) {
                guardian.markEvaluated(opi);
            }
            IHidObject caseExpression = opi.getLHValue();
            IHidObject rhValue = opi.getFirstRHValue();
            HidOperator result = null;
            HidOperatorOccurrence dummyHidOperatorOccurrence = opi.getOccurrence();
            if (HidUtils.isHidImplicit((IHidObject)rhValue) && ((IHidImplicit)rhValue).isOthers()) {
                return Collections.singletonList(rhValue);
            }
            ConfigInfo cInfo = new ConfigInfo(false, project, (project = this.getRfProject()) != null ? project.getEnclosingLibrary() : null, true, null);
            RfDefElement declaration = this.getDeclaration();
            ParserPath parserPath2 = parserPath = declaration != null ? declaration.getParserPath() : null;
            if (rhValue instanceof IRfHidOperatorLayer && ((IRfHidOperatorLayer)rhValue).isBar()) {
                ListContainer rhValues = ((HidOperator)rhValue).getRHValues();
                for (IHidObject hidObject : rhValues) {
                    HidOperator thisOp = STransformer.BUILDERS.buildOperator(caseExpression, Collections.singletonList(hidObject), 229, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", dummyHidOperatorOccurrence, 0L);
                    SEvaluator.INSTANCE.calculateHidObject(cInfo, this, parserPath, false, (IHidObject)thisOp, null);
                    if (result == null) {
                        result = thisOp;
                        continue;
                    }
                    result = STransformer.BUILDERS.buildOperator((IHidObject)result, Collections.singletonList(thisOp), 96, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "or", dummyHidOperatorOccurrence, 0L);
                    SEvaluator.INSTANCE.calculateHidObject(cInfo, this, parserPath, false, (IHidObject)result, null);
                }
            } else {
                result = STransformer.BUILDERS.buildOperator(caseExpression, Collections.singletonList(rhValue), 229, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", dummyHidOperatorOccurrence, 0L);
                SEvaluator.INSTANCE.calculateHidObject(cInfo, this, parserPath, false, (IHidObject)result, null);
            }
            return Collections.singletonList(result);
        }
        if (this.isFor()) {
            List<IHidOperator> operators = this.getHidOperators(IS_LOOP_EXPRESSION, true);
            if (operators == null || operators.isEmpty()) {
                return null;
            }
            IHidOperator opi = operators.get(0);
            if (guardian != null) {
                guardian.markEvaluated(opi);
            }
            IHidObject lhValue = opi.getLHValue();
            IHidOperator rangeOp = null;
            if (HidUtils.isHid((IHidObject)lhValue) || HidUtils.isHidAccess((IHidObject)lhValue)) {
                IHidEvaluationGuardian rangeGuardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this, null, (boolean)false, (ELManager)this.getRfProject().getELManager());
                rangeOp = RfBlock.getRangeForCondition(lhValue, this, evaluator, rangeGuardian, new HashSet<IRfNamedElement>());
            } else if (HidUtils.isOperator((IHidObject)lhValue)) {
                rangeOp = (IHidOperator)lhValue;
            }
            if (rangeOp == null) {
                return null;
            }
            if (rangeOp instanceof RfHidOperator && ((RfHidOperator)rangeOp).isLiteralRange()) {
                rangeOp = (IHidOperator)rangeOp.getRHValues().get(0);
            }
            ArrayList<IHidObject> result = new ArrayList<IHidObject>(3);
            result.add(null);
            result.add(null);
            result.add(null);
            List<RfVariable> fieldMembers = this.getLocalMembers(RfVariable.class);
            if (fieldMembers == null) {
                return null;
            }
            RfVariable genvar = null;
            for (RfVariable variable : fieldMembers) {
                if (variable.getFieldKind() != 524288) continue;
                genvar = variable;
                break;
            }
            if (genvar == null) {
                return null;
            }
            HidOperatorOccurrence occurrence = opi.getOccurrence();
            HidOccurrence dummyHidOccurrence = new HidOccurrence(occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), 0L, occurrence.getReparseInfo());
            HidOperatorOccurrence dummyHidOperatorOccurrence = new HidOperatorOccurrence(occurrence);
            HidImplicit oneImplicit = STransformer.BUILDERS.buildImplicit("1", 243);
            Hid genvarHid = STransformer.BUILDERS.buildHid(genvar.getName(), (IRfNamedElement)genvar, dummyHidOccurrence, 0L);
            result.set(0, (IHidObject)HidEvalCenter.INSTANCE.createDeclarationWithInitialValue((IRfFieldElement)genvar, rangeOp.getLHValue(), dummyHidOperatorOccurrence));
            if (((IRfHidOperatorLayer)rangeOp).isDirectionTo()) {
                result.set(1, (IHidObject)STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList((IHidObject)rangeOp.getRHValues().get(0)), 190, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "<=", dummyHidOperatorOccurrence, 0L));
                HidOperator incrementStepOperator = STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(oneImplicit), 225, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "+", dummyHidOperatorOccurrence, 0L);
                result.set(2, (IHidObject)STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(incrementStepOperator), 194, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":=", dummyHidOperatorOccurrence, 0L));
            } else if (((IRfHidOperatorLayer)rangeOp).isDirectionDownto()) {
                result.set(1, (IHidObject)STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList((IHidObject)rangeOp.getRHValues().get(0)), 191, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ">=", dummyHidOperatorOccurrence, 0L));
                HidOperator decrementStepOperator = STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(oneImplicit), 226, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "-", dummyHidOperatorOccurrence, 0L);
                result.set(2, (IHidObject)STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(decrementStepOperator), 194, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":=", dummyHidOperatorOccurrence, 0L));
            } else {
                return null;
            }
            return result;
        }
        if (this.isWhile()) {
            List<IHidOperator> hidOperators = this.getHidOperators(IS_LOOP_EXPRESSION, true);
            if (hidOperators == null || hidOperators.isEmpty()) {
                return null;
            }
            ArrayList<IHidObject> result = new ArrayList<IHidObject>(3);
            IHidOperator opi = hidOperators.get(0);
            if (guardian != null) {
                guardian.markEvaluated(opi);
            }
            result.add(null);
            result.add(opi.getLHValue());
            result.add(null);
            return result;
        }
        return null;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.action";
    }

    @Override
    public void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean disableExprEvaluate, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        super.resolveHids(configInfo, triggerError, disableExprEvaluate, skipMemberClasses);
        RfDefElement declaration = this.getDeclaration();
        if (this.isCase() && declaration != null && declaration.getDefFile() != null) {
            RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
            if (rfProject == null) {
                return;
            }
            ParserPath parserPath = declaration.getParserPath();
            int nofBits = -1;
            HashMap<String, IHid> caseChoiceMap = new HashMap<String, IHid>();
            RfHidOperator othersChoice = null;
            List<IHidOperator> caseItems = this.getCaseItemExpressions();
            HashMap<String, HidOperatorOccurrence> uniqueCaseItems = new HashMap<String, HidOperatorOccurrence>();
            if (caseItems != null) {
                IHid caseExpression;
                IRfNamedElement caseExpressionType = null;
                List<IHidOperator> caseCondition = this.getHidOperators(IS_CONDITIONAL_EXPRESSION, true);
                if (caseCondition != null && !caseCondition.isEmpty() && HidUtils.isResolved((IHidObject)(caseExpression = HidUtils.getHidFrom((IHidObject)caseCondition.get(0).getLHValue())))) {
                    IRfNamedElement field = caseExpression.getElement();
                    if (field instanceof RfAlias) {
                        field = ((RfAlias)field).getTranslatedType();
                    }
                    if (field instanceof RfVariable) {
                        caseExpressionType = ((RfVariable)field).getAssociatedType();
                        if (caseExpressionType instanceof RfListType) {
                            caseExpressionType = ((RfListType)caseExpressionType).getAssociatedType();
                        }
                        if (caseExpressionType instanceof RfAlias) {
                            caseExpressionType = ((RfAlias)caseExpressionType).getTranslatedType();
                        }
                    }
                }
                if ((caseExpressionType = STransformer.INSTANCE.getBaseType(caseExpressionType, false)) instanceof RfListType) {
                    caseExpressionType = ((RfListType)caseExpressionType).getAssociatedType();
                }
                if (caseExpressionType instanceof RfAlias) {
                    caseExpressionType = ((RfAlias)caseExpressionType).getTranslatedType();
                }
                boolean checkNonCharacterEnumeration = caseExpressionType instanceof RfType && !((RfType)caseExpressionType).isCharacterTypeEnum();
                boolean checkVectorType = caseExpressionType instanceof RfType && CASE_EXPRESSION_VECTOR_TYPES.contains(caseExpressionType.getLowerCaseName());
                int allCaseItemsSize = 0;
                for (IHidOperator caseItem : caseItems) {
                    boolean isDuplicateCaseItem;
                    if (!(caseItem instanceof RfHidOperator)) continue;
                    ArrayList<IHid> allCaseItemHids = new ArrayList<IHid>();
                    ListContainer rhHidObjects = caseItem.getRHValues();
                    if (rhHidObjects == null || rhHidObjects.size() != 1) continue;
                    IHidObject rhHidObject = (IHidObject)rhHidObjects.get(0);
                    if (rhHidObject instanceof RfHidImplicit && ((RfHidImplicit)rhHidObject).isOthers()) {
                        othersChoice = (RfHidOperator)caseItem;
                        ++allCaseItemsSize;
                        continue;
                    }
                    if (rhHidObject instanceof IRfHidOperatorLayer && (((IRfHidOperatorLayer)rhHidObject).isRangeOrPartSelect() || ((IRfHidOperatorLayer)rhHidObject).isVHDLConcatenation())) {
                        checkVectorType = false;
                        checkNonCharacterEnumeration = false;
                        continue;
                    }
                    this.collectAllHids(rhHidObject, allCaseItemHids);
                    allCaseItemsSize += allCaseItemHids.size();
                    String caseItemText = HidUtils.toString((IHidObject)caseItem, (boolean)true, (boolean)true);
                    HidOperatorOccurrence previousOccurrence = (HidOperatorOccurrence)uniqueCaseItems.get(caseItemText);
                    HidOperatorOccurrence occurrence = caseItem.getOccurrence();
                    boolean bl = isDuplicateCaseItem = previousOccurrence != null && !previousOccurrence.equals((Object)occurrence);
                    if (!isDuplicateCaseItem) {
                        uniqueCaseItems.put(caseItemText, occurrence);
                    }
                    block1: for (IHid caseItemHid : allCaseItemHids) {
                        int length;
                        String caseChoiceLowerCaseName;
                        String caseChoiceName = caseItemHid.getName();
                        String string = caseChoiceLowerCaseName = caseChoiceName.startsWith("\"") ? caseChoiceName : caseChoiceName.toLowerCase();
                        if (isDuplicateCaseItem && caseItem.hasOccurrence(HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION)) {
                            HidOperatorOccurrence firstOccurrence = caseItem.getOccurrence();
                            int line = firstOccurrence.getLine();
                            int startOffset = this.getStartOffset((IHidOccurrenceHolder)caseItemHid);
                            int endOffset = startOffset == -1 ? -1 : startOffset + caseChoiceName.length();
                            HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                            attributes.put("QUICKFIX_ELEMENT_NAME", caseChoiceName);
                            attributes.put("QUICKFIX_KIND", 5);
                            rfProject.addSemanticError(1, "DUPLICATE_WHEN_CHOICE: Duplicate case enumerated choice ''{0}'' already declared\n    at line {1,number,#######} in {2}", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, caseChoiceName, firstOccurrence.getLine(), parserPath);
                        }
                        if ((length = caseChoiceName.length()) > 2 && caseChoiceLowerCaseName.charAt(0) == '\"' && caseChoiceLowerCaseName.charAt(length - 1) == '\"') {
                            if (!checkVectorType) continue;
                            if (nofBits == -1) {
                                nofBits = length - 2;
                            }
                            if (nofBits != length - 2) {
                                rfProject.addSemanticError(1, "INCONSISTENT_CHOICES: Case choices inconsistent number of bits", this.getLibPkgScope(), -1, -1, null, declaration.getStartLine(), parserPath, new Object[0]);
                                checkVectorType = false;
                                continue;
                            }
                            int i = 1;
                            while (i < length - 1) {
                                char c = caseChoiceName.charAt(i);
                                if (c != '1' && c != '0') {
                                    checkVectorType = false;
                                    continue block1;
                                }
                                ++i;
                            }
                            continue;
                        }
                        if (!"others".equals(caseChoiceLowerCaseName)) {
                            checkVectorType = false;
                        }
                        caseChoiceMap.put(caseChoiceLowerCaseName, caseItemHid);
                    }
                }
                boolean hasMissingChoiceError = false;
                if (caseExpressionType instanceof RfType && (checkNonCharacterEnumeration || checkVectorType)) {
                    List<RfEnum> typeEnums = ((RfType)caseExpressionType).getEnumsWithPrefix("", 2);
                    boolean disableRedundantOthersChoice = rfProject.disableRedundantOthersChoice();
                    if (checkNonCharacterEnumeration && typeEnums != null && !typeEnums.isEmpty()) {
                        int line;
                        HashMap<String, Object> attributes;
                        StringBuilder nonExplicitChoice = new StringBuilder();
                        HashSet<String> typeEnumSet = new HashSet<String>();
                        RfEnum lastEnum = null;
                        for (RfEnum typeEnum : typeEnums) {
                            String typeEnumName = typeEnum.getName();
                            String typeEnumLowerCaseName = typeEnumName.toLowerCase();
                            if (!caseChoiceMap.containsKey(typeEnumLowerCaseName)) {
                                if (othersChoice == null) {
                                    int line2 = declaration.getStartLine();
                                    int startOffset = declaration.getStartOffset();
                                    attributes = new HashMap<String, Object>(4);
                                    attributes.put("QUICKFIX_ELEMENT_NAME", typeEnumName);
                                    attributes.put("QUICKFIX_KIND", 4);
                                    rfProject.addSemanticError(2, "MISSING_ENUM_CHOICE: Case enumerated choice ''{0}'' is not defined", this.getLibPkgScope(), startOffset, startOffset, attributes, line2, parserPath, typeEnumName);
                                } else if (nonExplicitChoice.length() == 0) {
                                    nonExplicitChoice.append(typeEnumName);
                                } else {
                                    nonExplicitChoice.append(", ").append(typeEnumName);
                                }
                            }
                            typeEnumSet.add(typeEnumLowerCaseName);
                            lastEnum = typeEnum;
                        }
                        caseChoiceMap.keySet().removeAll(typeEnumSet);
                        if (!caseChoiceMap.isEmpty()) {
                            for (IHid caseChoice : caseChoiceMap.values()) {
                                IRfNamedElement element;
                                RfDefElement enumDeclaration;
                                int line3;
                                if (caseChoice instanceof RfHidImplicit || (line3 = this.getStartLine((IHidOccurrenceHolder)caseChoice)) == -1) continue;
                                String name = caseChoice.getName();
                                int startOffset = this.getStartOffset((IHidOccurrenceHolder)caseChoice);
                                int endOffset = startOffset == -1 ? -1 : startOffset + name.length();
                                attributes = new HashMap(4);
                                if (lastEnum != null && !caseExpressionType.isPredefined() && (enumDeclaration = lastEnum.getDeclaration()) != null) {
                                    attributes.put("QUICKFIX_ELEMENT_NAME", name);
                                    attributes.put("QUICKFIX_KIND", 9);
                                    attributes.put("QUICKFIX_ENUM_INSERT_OFFSET", enumDeclaration.getStartOffset() + lastEnum.getName().length());
                                    attributes.put("QUICKFIX_INSERT_FILE", enumDeclaration.getParserPath().toString());
                                }
                                if ((element = caseChoice.getElement()) != null) continue;
                                rfProject.addSemanticError(1, "UNDECLARED_ENUM: Enum type value ''{0}'' is undeclared", this.getLibPkgScope(), startOffset, endOffset, attributes, line3, parserPath, name);
                            }
                        }
                        if (othersChoice != null && nonExplicitChoice.length() != 0) {
                            int line4 = this.getStartLine((IHidOccurrenceHolder)othersChoice);
                            if (line4 != -1) {
                                int startOffset = this.getStartOffset((IHidOccurrenceHolder)othersChoice);
                                endOffset = startOffset == -1 ? -1 : startOffset + "others".length();
                                attributes = new HashMap<String, Object>(4);
                                attributes.put("QUICKFIX_ELEMENT_NAME", "others");
                                attributes.put("QUICKFIX_KIND", 12);
                                String nonExplicit = nonExplicitChoice.toString();
                                attributes.put("QUICKFIX_CASE_CHOICE_ADD", nonExplicit);
                                rfProject.addSemanticError(2, "OTHERS_CHOICE_USED: Case choice ''others'' used for non-explicit enumerated choices ''{0}''", this.getLibPkgScope(), startOffset, endOffset, attributes, line4, parserPath, nonExplicit);
                            }
                        } else if (othersChoice != null && !disableRedundantOthersChoice && (line = this.getStartLine((IHidOccurrenceHolder)othersChoice)) != -1) {
                            int startOffset = this.getStartOffset((IHidOccurrenceHolder)othersChoice);
                            endOffset = startOffset == -1 ? -1 : startOffset + "others".length();
                            attributes = new HashMap(4);
                            attributes.put("QUICKFIX_ELEMENT_NAME", "others");
                            attributes.put("QUICKFIX_KIND", 5);
                            rfProject.addSemanticError(2, "REDUNDANT_OTHERS_CHOICE: Case choice ''others'' is redundant", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, new Object[0]);
                        }
                    } else if (checkVectorType && nofBits > 0) {
                        hasMissingChoiceError = true;
                        int nofValues = (int)Math.pow(2.0, nofBits);
                        if (othersChoice != null && nofValues == allCaseItemsSize - 1 && !disableRedundantOthersChoice) {
                            int line = this.getStartLine((IHidOccurrenceHolder)othersChoice);
                            if (line != -1) {
                                int startOffset = this.getStartOffset((IHidOccurrenceHolder)othersChoice);
                                int endOffset = startOffset == -1 ? -1 : startOffset + "others".length();
                                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                attributes.put("QUICKFIX_ELEMENT_NAME", "others");
                                attributes.put("QUICKFIX_KIND", 5);
                                rfProject.addSemanticError(2, "REDUNDANT_OTHERS_CHOICE: Case choice ''others'' is redundant", this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, new Object[0]);
                            }
                        } else if (othersChoice == null && nofValues > allCaseItemsSize) {
                            hasMissingChoiceError = false;
                        }
                    }
                }
                if (othersChoice == null && !hasMissingChoiceError && !rfProject.disableMissingOthersChoice()) {
                    int line = declaration.getStartLine();
                    int startOffset = declaration.getStartOffset();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    attributes.put("QUICKFIX_ELEMENT_NAME", "others");
                    attributes.put("QUICKFIX_KIND", 4);
                    rfProject.addSemanticError(2, "MISSING_OTHERS_CHOICE: Case choice ''others'' is not defined", this.getLibPkgScope(), startOffset, startOffset, attributes, line, parserPath, new Object[0]);
                }
            }
        }
    }

    public IHidOperator getForLoopRangeExpression() {
        if (!this.isFor()) {
            return null;
        }
        final IHidOperator[] result = new IHidOperator[1];
        IHidVisitor<RfHidOperator> visitor = new IHidVisitor<RfHidOperator>(){

            public boolean visit(RfHidOperator hidObject) {
                if (!hidObject.isForLoopExpression()) {
                    return true;
                }
                result[0] = hidObject;
                return false;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        };
        this.visitHidObject(null, visitor);
        return result[0];
    }

    private List<IHidOperator> getCaseItemExpressions() {
        if (!this.isCase()) {
            return null;
        }
        Collection<RfNamedElement> members = this.getMembers(true, false);
        if (members == null || members.isEmpty()) {
            return null;
        }
        ArrayList<IHidOperator> caseChoises = new ArrayList<IHidOperator>();
        for (RfNamedElement member : members) {
            List<IHidOperator> choises;
            if (!(member instanceof RfActionBlock) || !((RfActionBlock)member).isCaseItem() || (choises = member.getHidOperators(IS_CASE_ITEM_EXPRESSION, true)) == null || choises.isEmpty()) continue;
            caseChoises.addAll(choises);
        }
        return caseChoises;
    }

    private final void collectAllHids(IHidObject caseAlternativeHid, List<IHid> result) {
        if (caseAlternativeHid instanceof RfHid) {
            result.add((IHid)caseAlternativeHid);
        } else if (caseAlternativeHid instanceof RfHidImplicit && !((RfHidImplicit)caseAlternativeHid).isVariadicOperand()) {
            result.add((IHid)caseAlternativeHid);
        } else if (caseAlternativeHid instanceof RfHidOperator) {
            IHidObject leftHid = ((RfHidOperator)caseAlternativeHid).getLHValue();
            this.collectAllHids(leftHid, result);
            ListContainer rightHids = ((RfHidOperator)caseAlternativeHid).getRHValues();
            if (rightHids != null && !rightHids.isEmpty()) {
                for (IHidObject rightHid : rightHids) {
                    this.collectAllHids(rightHid, result);
                }
            }
        }
    }

    private final int getStartOffset(IHidOccurrenceHolder hidObject) {
        HidOccurrence occurrence = hidObject.getOccurrence();
        return occurrence != null ? occurrence.getOffset() : -1;
    }

    private final int getStartLine(IHidOccurrenceHolder hidObject) {
        HidOccurrence occurrence = hidObject.getOccurrence();
        return occurrence != null ? occurrence.getLine() : -1;
    }
}

