/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VhdlFunction;
import ro.amiq.dvt.utils.VhdlPackageInstantiation;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class RfAlias
extends RfVariable
implements IRfTypeAliasElement,
IRfConstantsHolder {
    private static final long serialVersionUID = 1L;
    private DataType fAliasedDataType;
    private int fAliasKind;
    private transient IRfNamedElement fTranslatedElement;
    private transient List<IRfNamedElement> fTranslatedElementChunks;
    private transient Map<String, IRfNamedElement> fTransientLocalResolvedGenericMap;
    public static final int ALIAS = 0;
    public static final int PACKAGE_INSTANTIATION = 1;
    public static final int FUNCTION_INSTANTIATION = 2;
    public static final int PROCEDURE_INSTANTIATION = 3;

    public RfAlias(String name, int interfaceKind, DataType dataType, DataType aliasedDataType, int aliasKind) {
        super(name, interfaceKind, 1, null, dataType, null);
        this.fAliasedDataType = aliasedDataType;
        this.fAliasKind = aliasKind;
    }

    public void init(int interfaceKind, DataType dataType, DataType aliasedDataType, int aliasKind, String name) {
        super.init(name, interfaceKind, 1, null, dataType, null);
        this.fAliasedDataType = aliasedDataType;
        this.fAliasKind = aliasKind;
    }

    public DataType getAliasedDataType() {
        return this.fAliasedDataType;
    }

    @Override
    public String getSignature() {
        switch (this.fAliasKind) {
            case 1: {
                return "package instantiation " + this.printScope() + this.getName() + " of " + DataType.getFullTypeName(this.fAliasedDataType, false);
            }
            case 2: {
                return "function instantiation " + this.printScope() + this.getName() + " of " + DataType.getFullTypeName(this.fAliasedDataType, false);
            }
            case 3: {
                return "procedure instantiation " + this.printScope() + this.getName() + " of " + DataType.getFullTypeName(this.fAliasedDataType, false);
            }
        }
        return "alias " + this.printScope() + this.getName() + " of " + DataType.getFullTypeName(this.fAliasedDataType, false);
    }

    public boolean isPackageInstatiation() {
        return this.fAliasKind == 1;
    }

    public boolean isAlias() {
        return this.fAliasKind == 0;
    }

    public boolean isSubprogramInstantiation() {
        return this.isProcedureInstantiation() || this.isFunctionInstantiation();
    }

    public boolean isProcedureInstantiation() {
        return this.fAliasKind == 3;
    }

    public boolean isFunctionInstantiation() {
        return this.fAliasKind == 2;
    }

    @Override
    public void checkConstraints(RfProject rfProject) {
    }

    @Override
    protected void resolveUses(RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        if (this.isPackageInstatiation()) {
            super.resolveUses(rfProject, report, onlyUnresolved, otherLanguage);
        }
    }

    public IRfNamedElement getTranslatedType(IRfScopeElement scope) {
        return this.internalGetTranslatedTypeRecursive(new HashSet<IRfNamedElement>());
    }

    public IRfNamedElement getTranslatedType() {
        return this.internalGetTranslatedTypeRecursive(new HashSet<IRfNamedElement>());
    }

    public IRfNamedElement getTranslatedType(HashSet<IRfNamedElement> visited) {
        return this.internalGetTranslatedTypeRecursive(visited);
    }

    private IRfNamedElement internalGetTranslatedTypeRecursive(HashSet<IRfNamedElement> visited) {
        if (visited.contains(this)) {
            return null;
        }
        visited.add(this);
        IRfNamedElement aliased = this.fTranslatedElement;
        if (aliased instanceof RfAlias && ((RfAlias)aliased).isAlias()) {
            return ((RfAlias)aliased).internalGetTranslatedTypeRecursive(visited);
        }
        return aliased;
    }

    @Override
    protected void resolveTypes(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        ConfigInfo localConfigInfo = new ConfigInfo(configInfo);
        localConfigInfo.keepGenericMap = false;
        super.resolveHids(localConfigInfo, false, true, null);
        super.resolveTypes(configInfo, rfProject, report, onlyUnresolved, otherLanguage, skipMemberClasses);
    }

    @Override
    protected void internalResolveType(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        try {
            List<DataTypeChunk> typeName;
            if (!onlyUnresolved || this.fTranslatedElement == null || this.transientType == null) {
                super.internalResolveType(configInfo, rfProject, report, onlyUnresolved, otherLanguage);
                this.fTransientLocalResolvedGenericMap = this.getLocalResolvedGenericMap(true);
                this.fTranslatedElement = this.internalComputeAliasedVariable(configInfo);
                if (this.transientType != null && !(this.transientType instanceof RfAssociatedType.RfUnresolvedInfo)) {
                    boolean isObjectAlias;
                    IRfNamedElement finalTranslatedType = this.getTranslatedType();
                    if (finalTranslatedType instanceof RfVariable) {
                        RfDummyVariable dummyVariable = new RfDummyVariable(finalTranslatedType.getName(), this.associatedDataType, ((RfVariable)this.fTranslatedElement).getInterfaceKind(), ((RfVariable)this.fTranslatedElement).getFieldKind(), this.transientType, (RfVariable)finalTranslatedType);
                        dummyVariable.setEnclosingScope(this.getEnclosingScope(), false);
                        this.transientType = dummyVariable;
                    }
                    boolean bl = isObjectAlias = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo || this.fTranslatedElement instanceof RfVariable && ((RfVariable)this.fTranslatedElement).getFieldKind() != 0x200000;
                    if (!isObjectAlias && this.fAliasKind == 0 && this.getDeclaration() != null && this.associatedDataType != null) {
                        this.transientType = this.fTranslatedElement;
                        rfProject.addSemanticError(1, "SUBTYPE_INDICATION: Subtype indication is allowed only for object aliases (i.e. a constant, a variable, a signal, or a file)", this.getLibPkgScope(), -1, DataType.getFullTypeName(this.fAliasedDataType, true).length(), null, this.getDeclaration().getStartLine(), this.getDeclaration().getParserPath(), new Object[0]);
                    }
                } else {
                    this.transientType = this.fTranslatedElement;
                }
            }
            if (this.fAliasedDataType == null) {
                return;
            }
            if (this.transientType instanceof RfScalarType && ((RfScalarType)this.transientType).isEnumType()) {
                RfScalarType enumType = (RfScalarType)this.transientType;
                List<DataTypeChunk> typeName2 = this.fAliasedDataType.getTypeName();
                for (IRfNamedElement enm : enumType.getEnumNames().values()) {
                    ArrayList<DataTypeChunk> newTypeName = new ArrayList<DataTypeChunk>();
                    newTypeName.addAll(typeName2);
                    newTypeName.add(new DataTypeChunk(enm.getName(), -1, -1));
                    RfAlias newAlias = new RfAlias(enm.getName(), 1, null, new DataType(newTypeName), 0);
                    this.getEnclosingScope().addMember(newAlias);
                    newAlias.internalResolveType(configInfo, rfProject, report, onlyUnresolved, otherLanguage);
                }
            }
            if ((typeName = this.fAliasedDataType.getTypeName()) == null || typeName.isEmpty()) {
                return;
            }
            configInfo.addReference(this.fAliasedDataType);
            configInfo.addReferenceToIdentifierName(this.fAliasedDataType);
            if (report) {
                if (this.fTranslatedElement == null || this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo) {
                    RfDefElement declaration = this.getDeclaration();
                    if (declaration != null && declaration.getDefFile() != null) {
                        boolean isNoSignatureAlias;
                        ParserPath parserPath = declaration.getParserPath();
                        boolean isInvalidArraySelect = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo && "INVALID_ARRAY_SELECT".equals(((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getName());
                        boolean isUndefinedSubprogramInstantiation = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo && ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getIndex() == -1;
                        boolean isNonGenericSubprogramInstantiation = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo && ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getIndex() == -2;
                        boolean isWrongKindSubprogramInstantiation = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo && ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getIndex() == -3;
                        boolean bl = isNoSignatureAlias = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo && ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getIndex() == -4;
                        if (!RfProject.isPredefined(parserPath) && isNoSignatureAlias) {
                            String unresolvedName = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getName();
                            int startOffset = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getOffset();
                            int endOffset = startOffset + unresolvedName.length();
                            rfProject.addSemanticError(1, "ILLEGAL_SUBPROGRAM_ALIAS: Alias ''{0}'' must specify the subprogram signature", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, unresolvedName);
                        } else if (isWrongKindSubprogramInstantiation) {
                            String typeExpecting = this.fAliasKind == 2 ? "function" : "procedure";
                            String typeFound = this.fAliasKind == 2 ? "procedure" : "function";
                            String unresolvedName = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getName();
                            int startOffset = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getOffset();
                            int endOffset = startOffset + unresolvedName.length();
                            rfProject.addSemanticError(1, "SUBPROGRAM_KIND_MISMATCH: Expecting uninstantiated {0}, found {1} instead", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, typeExpecting, typeFound);
                        } else if (isUndefinedSubprogramInstantiation) {
                            String unresolvedName = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getName();
                            String instanceName = this.getName();
                            String kind = this.fAliasKind == 0 ? "alias" : "subprogram instantiation";
                            int startOffset = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getOffset();
                            int endOffset = startOffset + unresolvedName.length();
                            rfProject.addSemanticError(1, "UNDEFINED_SUBPROGRAM: Subprogram ''{0}'' referred in {1} ''{2}'' is undefined", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, unresolvedName, kind, instanceName);
                        } else if (isNonGenericSubprogramInstantiation) {
                            String unresolvedName = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getName();
                            String instanceName = this.getName();
                            int startOffset = ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getOffset();
                            int endOffset = startOffset + unresolvedName.length();
                            rfProject.addSemanticError(1, "UNDEFINED_SUBPROGRAM: Subprogram ''{0}'' referred in subprogram instantiation ''{1}'' is not an uninstantiated subprogram.", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, unresolvedName, instanceName);
                        } else {
                            int index;
                            int n = index = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo ? ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getIndex() : -1;
                            if (!RfProject.isPredefined(parserPath) && !isInvalidArraySelect && index <= 0) {
                                String unresolvedName;
                                int severity = this.getAssociatedType() == null ? 1 : 2;
                                IRfNamedElement parentScope = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo ? ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getParentScope() : null;
                                String string = unresolvedName = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo ? ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getName() : null;
                                if (unresolvedName == null || unresolvedName.isEmpty()) {
                                    unresolvedName = DataType.getFullTypeName(this.fAliasedDataType, true);
                                }
                                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                                attributes.put("QUICKFIX_ELEMENT_NAME", unresolvedName);
                                attributes.put("QUICKFIX_KIND", 1);
                                attributes.put("QUICKFIX_HIERARCHICAL_ID", true);
                                attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)parentScope).toString());
                                int startOffset = this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo ? ((RfAssociatedType.RfUnresolvedInfo)this.fTranslatedElement).getOffset() : -1;
                                int endOffset = startOffset < 0 ? startOffset : startOffset + unresolvedName.length();
                                rfProject.addSemanticError(severity, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", this.getLibPkgScope(), startOffset, endOffset, attributes, declaration.getStartLine(), parserPath, unresolvedName);
                            }
                        }
                    }
                } else if (!this.isAlias() && this.fTranslatedElement instanceof RfNamedElement) {
                    IRfDefElement translatedDecl;
                    RfDefElement declaration = this.getDeclaration();
                    boolean enableDefBeforeUseCheck = RfProject.isEnableDefBeforeUseCheck(this, this.fTranslatedElement, rfProject);
                    if (enableDefBeforeUseCheck && !((RfNamedElement)this.fTranslatedElement).isBefore(this) && (translatedDecl = RfProject.getUsageBeforeDeclaration(this.fTranslatedElement)) != null) {
                        rfProject.addSemanticError(1, "USAGE_BEFORE_DECLARATION: {0} ''{1}'' is used before being declared\n    at line {2,number,#######} in {3}", this.getLibPkgScope(), declaration.getStartOffset(), declaration.getStartOffset() + this.getName().length(), null, declaration.getStartLine(), declaration.getParserPath(), RfKind.of(this.transientType).getCapitalizedName(), this.transientType.getName(), translatedDecl.getStartLine(), translatedDecl.getParserPath());
                    }
                }
            }
            if (report && this.isPackageInstatiation()) {
                this.checkMissingPackageBody(rfProject);
            }
            if (this.fTranslatedElement != null && !(this.fTranslatedElement instanceof RfAssociatedType.RfUnresolvedInfo)) {
                configInfo.addReference(this.fTranslatedElement.getName());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void checkMissingPackageBody(RfProject rfProject) {
        if (!(this.fTranslatedElement instanceof RfPackage)) {
            return;
        }
        RfPackage pkg = (RfPackage)this.fTranslatedElement;
        if (pkg.isPredefined() || pkg.hasPackageBody()) {
            return;
        }
        boolean requiresBody = false;
        Collection<RfNamedElement> members = pkg.getMembers();
        if (members == null) {
            return;
        }
        block0: for (RfNamedElement member : members) {
            RfVariable variable;
            if (member.isPredefined()) continue;
            if (member instanceof RfFunctionsHolder) {
                RfFunctionsHolder funcHolder = (RfFunctionsHolder)member;
                Collection<RfNamedElement> functions = funcHolder.getMembers();
                if (functions != null) {
                    for (RfNamedElement el : functions) {
                        if (!(el instanceof RfFunction) || !((RfFunction)el).isPrototype()) continue;
                        requiresBody = true;
                        break block0;
                    }
                }
            } else if (member instanceof RfType && ((RfType)member).isProtected()) {
                requiresBody = true;
            } else if (member instanceof RfVariable && (variable = (RfVariable)member).isConstant() && variable.getInterfaceKind() == 1 && variable.getInitialValue(true) == null) {
                requiresBody = true;
            }
            if (requiresBody) break;
        }
        if (requiresBody) {
            RfDefElement declaration = this.getDeclaration();
            String pkgName = pkg.getName();
            String name = this.getName();
            if (declaration == null || pkgName == null || name == null) {
                return;
            }
            ParserPath parserPath = declaration.getParserPath();
            if (parserPath == null) {
                return;
            }
            int startOffset = this.getOffset();
            int endOffset = startOffset + name.length();
            rfProject.addSemanticError(1, "MISSING_INSTANTIATED_PACKAGE_BODY: Instantiated package ''{0}'' does not have a body", this.getLibPkgScope(), startOffset, endOffset, null, this.getLine(), parserPath, pkgName);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IRfNamedElement internalComputeAliasedVariable(ConfigInfo configInfo) {
        try {
            DataType dummyVariableDataType;
            List<IHidObject> elementConstraints;
            ListContainer rhValues;
            boolean isExternalName;
            this.fTranslatedElementChunks = new ArrayList<IRfNamedElement>();
            RfNamedElement scope = this.getEnclosingScope();
            List<DataTypeChunk> typeName = this.fAliasedDataType == null ? null : this.fAliasedDataType.getTypeName();
            IHidOperator signature = this.fAliasedDataType == null ? null : this.fAliasedDataType.getSignature();
            int typeLength = typeName == null ? 0 : typeName.size();
            HashSet<IRfLibraryElement> visited = new HashSet<IRfLibraryElement>();
            int i = 0;
            while (typeName != null && scope != null && i < typeLength) {
                Object candidate;
                String candidateName;
                block29: {
                    block30: {
                        block31: {
                            block36: {
                                block35: {
                                    IRfNamedElement returnType;
                                    ArrayList<IRfNamedElement> argumentTypes;
                                    block34: {
                                        List<Object> argumentHidObjects;
                                        block33: {
                                            block32: {
                                                candidateName = typeName.get((int)i).name;
                                                candidate = null;
                                                if (i == 0 && typeLength > 1) {
                                                    candidate = this.getEnclosingScope().getLibraryAndWork(candidateName);
                                                }
                                                if (candidate == null && (candidate = scope.getMember(candidateName, DVTRfUtils.MEMBERS_OTHERS, null, i == 0, i == typeLength - 1, false, false, false)) == null && scope instanceof RfPackage && ((RfPackage)scope).hasPackageBody()) {
                                                    candidate = ((RfPackage)scope).getPackageBody().getMember(candidateName, DVTRfUtils.MEMBERS_OTHERS, null, i == 0, i == typeLength - 1, false, false, false);
                                                }
                                                if (signature == null && candidate != null || !(scope instanceof RfNamedElement)) break block29;
                                                List<RfFunctionsHolder> candidates = scope.getFunctionHoldersWithPrefix(candidateName, 1, false);
                                                if (candidates == null || candidates.isEmpty()) break block30;
                                                candidate = RfFunctionsHolder.of(candidateName, candidates);
                                                if (signature == null) break block31;
                                                IHidObject argNames = signature.getLHValue();
                                                argumentTypes = new ArrayList<IRfNamedElement>();
                                                argumentHidObjects = new ArrayList();
                                                if (HidUtils.isOperator((IHidObject)argNames) && ((HidOperator)argNames).getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                                                    argumentHidObjects = OptimizedUtils.asList((ListContainer)((HidOperator)argNames).getRHValues(), (boolean)false);
                                                } else if (HidUtils.isHid((IHidObject)argNames)) {
                                                    argumentHidObjects = Collections.singletonList(argNames);
                                                }
                                                int j = argumentHidObjects.size() - 1;
                                                while (j >= 0) {
                                                    IRfNamedElement assocType;
                                                    List elemTypeName;
                                                    IHidObject hidObject = (IHidObject)argumentHidObjects.get(j);
                                                    if (HidUtils.isHid((IHidObject)hidObject) && (elemTypeName = ((Hid)hidObject).getHidNameAsStringList()) != null && (assocType = this.internalComputeAssociatedType(new DataType(elemTypeName), IRfAssociatedType.AssocTypeKind.ASSOC_TYPE, true)) != null) {
                                                        argumentTypes.add(assocType);
                                                    }
                                                    --j;
                                                }
                                                ListContainer rhValues2 = signature.getRHValues();
                                                IHidObject returnTypeHidObject = rhValues2 != null && !rhValues2.isEmpty() ? (IHidObject)signature.getRHValues().get(0) : null;
                                                List returnTypeName = returnTypeHidObject instanceof Hid ? ((Hid)returnTypeHidObject).getHidNameAsStringList() : null;
                                                IRfNamedElement iRfNamedElement = returnType = returnTypeName != null ? this.internalComputeAssociatedType(new DataType(returnTypeName), IRfAssociatedType.AssocTypeKind.ASSOC_TYPE, true) : null;
                                                if (returnType != null || this.fAliasKind != 2) break block32;
                                                candidate = new RfAssociatedType.RfUnresolvedInfo(candidateName, -3, typeName.get((int)i).offset, scope);
                                                break block29;
                                            }
                                            if (returnType == null || this.fAliasKind != 3) break block33;
                                            candidate = new RfAssociatedType.RfUnresolvedInfo(candidateName, -3, typeName.get((int)i).offset, scope);
                                            break block29;
                                        }
                                        if (argumentTypes.size() == argumentHidObjects.size()) break block34;
                                        candidate = ((RfFunctionsHolder)candidate).getLastDefinedFunction();
                                        break block29;
                                    }
                                    RfFunctionsHolder candidate1 = (RfFunctionsHolder)candidate;
                                    if ((candidate = candidate1.getFunctionByArgumentTypes(argumentTypes, returnType)) != null) break block35;
                                    candidate = new RfAssociatedType.RfUnresolvedInfo(candidateName, -1, typeName.get((int)i).offset, scope);
                                    break block29;
                                }
                                if (this.fAliasKind != 2 && this.fAliasKind != 3 || ((RfFunction)candidate).isUninstantiated()) break block36;
                                candidate = new RfAssociatedType.RfUnresolvedInfo(candidateName, -2, typeName.get((int)i).offset, scope);
                                break block29;
                            }
                            if (!(candidate instanceof RfFunction) || ((RfFunction)candidate).isPrototype()) break block29;
                            candidate = ((RfFunction)candidate).getPrototype();
                            break block29;
                        }
                        if (this.fAliasKind != 0) break block29;
                        candidate = new RfAssociatedType.RfUnresolvedInfo(candidateName, -4, typeName.get((int)i).offset, scope);
                        break block29;
                    }
                    if (signature instanceof HidOperator && i == typeLength - 1 && ((HidOperator)signature).getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                        ListContainer rhValues3 = signature.getRHValues();
                        Iterator<RfType> returnTypeHidObject = rhValues3 != null && !rhValues3.isEmpty() ? (IHidObject)signature.getRHValues().get(0) : null;
                        List returnTypeName = returnTypeHidObject instanceof Hid ? ((Hid)returnTypeHidObject).getHidNameAsStringList() : null;
                        IRfNamedElement returnType = returnTypeName != null ? this.internalComputeAssociatedType(new DataType(returnTypeName), IRfAssociatedType.AssocTypeKind.ASSOC_TYPE, true) : null;
                        Collection<IRfNamedElement> enums = STransformer.INSTANCE.checkImplicitEnumValue(candidateName, scope, false);
                        for (IRfNamedElement enu : enums) {
                            if (!enu.checkTypeCompatibility(returnType)) continue;
                            candidate = enu;
                        }
                    }
                }
                if (candidate instanceof RfNamedElement && ((RfNamedElement)candidate).isImplicit()) {
                    candidate = null;
                }
                if (candidate == null) {
                    List<RfType> allVisibleTypes = scope.getTypesWithPrefix("", 2, false);
                    if (allVisibleTypes != null && !allVisibleTypes.isEmpty()) {
                        for (RfType type : allVisibleTypes) {
                            candidate = type.getEnumWithPrefix(candidateName, 1);
                            if (candidate == null) {
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    this.fTranslatedElementChunks.add((IRfNamedElement)candidate);
                }
                HashSet<IRfLibraryElement> visited2 = new HashSet<IRfLibraryElement>(visited);
                while (i < typeLength - 1 && (candidate instanceof RfAlias || candidate instanceof RfAssociatedType && !(candidate instanceof RfPackage) || candidate instanceof IRfListType)) {
                    if (visited2.contains(candidate)) {
                        return null;
                    }
                    visited2.add((IRfLibraryElement)candidate);
                    if (candidate instanceof RfAlias) {
                        ((RfAlias)candidate).getResolvedType(true);
                        candidate = ((RfAlias)candidate).getTranslatedType(new HashSet<IRfNamedElement>(visited));
                        continue;
                    }
                    if (candidate instanceof RfAssociatedType && !(candidate instanceof RfPackage)) {
                        candidate = ((IRfFieldElement)candidate).getResolvedType(true);
                        continue;
                    }
                    if (!(candidate instanceof IRfListType)) continue;
                    DataType dataType = (DataType)((IRfListType)candidate).getDataType();
                    List<IHidObject> arrayConstraints = dataType.getArrayConstraintHidObjects();
                    int j = 0;
                    while (j < arrayConstraints.size()) {
                        candidate = ((IRfListType)candidate).getResolvedType(true);
                        ++j;
                    }
                }
                if (candidate == null) {
                    int unresolvedOffset = typeName.get((int)i).offset;
                    return unresolvedOffset >= 0 ? new RfAssociatedType.RfUnresolvedInfo(candidateName, i, unresolvedOffset, scope) : null;
                }
                if (visited.contains(candidate)) {
                    return null;
                }
                visited.add((IRfLibraryElement)candidate);
                scope = candidate;
                ++i;
            }
            boolean bl = isExternalName = signature != null && signature.getOperatorType() == IHidOperatorConstants.OperatorType.EXTERNAL_NAME.id;
            if (scope != null && !(scope instanceof RfAssociatedType.RfUnresolvedInfo) && signature != null && isExternalName && (rhValues = ((HidOperator)signature).getRHValues()) != null && rhValues.size() == 3) {
                IHidObject kindObject = (IHidObject)rhValues.get(2);
                int variableKind = kindObject instanceof IRfHidImplicitLayer ? (((IRfHidImplicitLayer)kindObject).isSignal() ? 32768 : (((IRfHidImplicitLayer)kindObject).isVariable() ? 8192 : 16384)) : 8192;
                DataType variableDataType = new DataType(this.fAliasedDataType);
                variableDataType.decreaseElementConstraints();
                RfDummyVariable dummyVariable = new RfDummyVariable(scope.getName(), variableDataType, 1, variableKind, scope, null);
                dummyVariable.setEnclosingScope(this.getEnclosingScope(), false);
                scope = dummyVariable;
            }
            if (scope instanceof IRfFieldElement && (elementConstraints = (dummyVariableDataType = isExternalName && scope instanceof RfDummyVariable ? ((RfDummyVariable)scope).getDataType() : new DataType(this.fAliasedDataType)).getElementConstraintHidObjects()) != null && !elementConstraints.isEmpty()) {
                RfHidAccess dummyAccess = new RfHidAccess(Integer.MIN_VALUE, elementConstraints);
                dummyAccess.resolveType(configInfo, false, false, this.getEnclosingScope(), scope, null, false, true, false, this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null);
                if (dummyAccess.getAssociatedType() == null) {
                    scope = new RfAssociatedType.RfUnresolvedInfo("INVALID_ARRAY_SELECT", 0, -1, this.getEnclosingScope());
                } else {
                    IRfFieldElement scopeField = (IRfFieldElement)scope;
                    int variableKind = scopeField.getFieldKind();
                    RfDummyVariable dummyVariable = new RfDummyVariable(this.getName(), dummyVariableDataType, scopeField.getInterfaceKind(), variableKind, dummyAccess.getAssociatedType(), scopeField);
                    dummyVariable.setEnclosingScope(this.getEnclosingScope(), false);
                    scope = dummyVariable;
                }
            }
            return typeLength != 0 ? scope : null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public String getElabName(boolean isCaseSensitive) {
        if (this.fAliasKind == 0) {
            IRfNamedElement translatedType = this.getTranslatedType();
            return translatedType != null ? translatedType.getElabName(isCaseSensitive) : super.getElabName(isCaseSensitive);
        }
        return super.getElabName(isCaseSensitive);
    }

    @Override
    public int getFieldKind() {
        if (this.fAliasKind == 0) {
            IRfNamedElement translatedType = this.getTranslatedType();
            return translatedType instanceof IRfFieldElement ? ((IRfFieldElement)translatedType).getFieldKind() : super.getFieldKind();
        }
        return super.getFieldKind();
    }

    @Override
    public int getInterfaceKind() {
        if (this.fAliasKind == 0) {
            IRfNamedElement translatedType = this.getTranslatedType();
            return translatedType instanceof IRfFieldElement ? ((IRfFieldElement)translatedType).getInterfaceKind() : super.getInterfaceKind();
        }
        return super.getInterfaceKind();
    }

    @Override
    public Image getImage() {
        if (this.fTranslatedElement == null) {
            return super.getImage();
        }
        return this.fTranslatedElement.getImage();
    }

    public RfPackage internalComputeInstantiatedPackage() {
        if (!this.isPackageInstatiation()) {
            return null;
        }
        if (this.fTranslatedElement == null && this.fAliasedDataType != null) {
            this.fTranslatedElement = this.internalComputeAliasedVariable(new ConfigInfo(false, this.getRfProject(), this.getEnclosingLibrary(), true, null));
        }
        return this.fTranslatedElement instanceof RfPackage ? (RfPackage)this.fTranslatedElement : null;
    }

    @Override
    protected void internalGetResolvedGenericMap(Map<String, IRfNamedElement> result) {
        this.internalGetLocalResolvedGenericMap(result);
        if (this.fTranslatedElement instanceof RfAlias && this.fTranslatedElement != this && this.getTranslatedType() != null) {
            ((RfAlias)this.fTranslatedElement).internalGetResolvedGenericMap(result);
        }
        super.internalGetResolvedGenericMap(result);
    }

    protected void internalGetLocalResolvedGenericMap(Map<String, IRfNamedElement> result) {
        if (this.isPackageInstatiation() && this.fTranslatedElement instanceof RfPackage && this.fTransientLocalResolvedGenericMap != null) {
            result.putAll(this.fTransientLocalResolvedGenericMap);
        }
    }

    public List<IRfNamedElement> getTranslatedElementChunks() {
        return this.fTranslatedElementChunks != null ? this.fTranslatedElementChunks : Collections.emptyList();
    }

    @Override
    public BitVectorContext getDataTypeBitVectorContext(IHidEvaluator evaluator, boolean returnTypeParameterDefault, ElementPath hierarchyPath, ELManager manager) {
        RfPackage packageInst;
        if (this.isPackageInstatiation() && (packageInst = this.internalComputeInstantiatedPackage()) != null) {
            return BitVectorContext.of((DVTNumber)new VhdlPackageInstantiation((IRfPackageElement)packageInst), (IRfNamedElement)this);
        }
        if (this.isSubprogramInstantiation()) {
            IRfNamedElement subprogramInst = this.getAssociatedType();
            if (subprogramInst instanceof RfFunctionsHolder) {
                RfFunctionsHolder holder = (RfFunctionsHolder)subprogramInst;
                if (holder.hasMultipleFunctions()) {
                    return null;
                }
                subprogramInst = holder.getLastDefinedFunction();
            }
            if (!(subprogramInst instanceof IRfMethodElement)) {
                return null;
            }
            return BitVectorContext.of((DVTNumber)new VhdlFunction((IRfMethodElement)subprogramInst), (IRfNamedElement)this);
        }
        return super.getDataTypeBitVectorContext(evaluator, returnTypeParameterDefault, hierarchyPath, manager);
    }

    public void elaborateConstants(ELManager manager) {
        if (!this.isPackageInstatiation()) {
            return;
        }
        byte semanticEnableRaw = manager.getSemanticEnableRaw();
        if (manager.isPermanentElaboration() && semanticEnableRaw == 3) {
            IRfSingleLangProject rfProject = manager.getStartingVHDLProject();
            RfLibrary enclosingLibrary = this.getEnclosingLibrary();
            ConfigInfo configInfo = new ConfigInfo(false, rfProject, enclosingLibrary, BuildConfigManager.getDisableRTLChecks((IProject)rfProject.getProject()), IBuildConfigParserConstants.ToolCompat.DVT);
            configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELParamValues.EMPTY, null, (ELManager)manager));
            this.resolveTypes(configInfo, (RfProject)rfProject, !this.isPredefined(), true, true, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            this.resolveHids(configInfo, !this.isPredefined(), false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            RfPackage genericPackage = this.internalComputeInstantiatedPackage();
            if (genericPackage != null) {
                genericPackage.elaborateConstants(manager);
            }
        }
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.fTransientLocalResolvedGenericMap = null;
        this.fTranslatedElement = null;
        this.fTranslatedElementChunks = null;
    }
}

