/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Collection;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class RfAnyListType
extends RfListType {
    private static final long serialVersionUID = 1L;
    private boolean oneDimensional;
    private String actualLiteral;
    private RfNamedElement scope;

    public RfAnyListType(String name, RfType.TypeKind typeKind, DataType dataType, IRfNamedElement elementType, boolean oneDimensional) {
        super(name, typeKind, dataType);
        this.transientType = elementType;
        this.oneDimensional = oneDimensional;
    }

    public RfAnyListType(String name, IRfNamedElement elementType, boolean oneDimensional, String literal, RfNamedElement scope) {
        super(name, RfType.TypeKind.IS_ARRAY, null, elementType);
        this.oneDimensional = oneDimensional;
        this.actualLiteral = literal;
        this.scope = scope;
    }

    @Override
    public RfProject getRfProject() {
        return this.scope != null ? this.scope.getRfProject() : super.getRfProject();
    }

    @Override
    public boolean isOneDimensional() {
        return this.oneDimensional;
    }

    public boolean checkWithContext(RfScalarType secondType) {
        if (this.actualLiteral == null || this.actualLiteral.isEmpty()) {
            return true;
        }
        Map<String, IRfNamedElement> enumNames = secondType.getEnumNames();
        if (enumNames == null || enumNames.isEmpty()) {
            return true;
        }
        int actualLength = this.actualLiteral.length();
        int i = 0;
        while (i < actualLength) {
            String charAt = "" + '\'' + this.actualLiteral.charAt(i) + '\'';
            if (!enumNames.containsKey(charAt)) {
                return false;
            }
            if (i == 0) {
                boolean found = false;
                Collection<IRfNamedElement> enumCandidates = STransformer.INSTANCE.checkImplicitEnumValue(charAt, this.scope, false);
                for (IRfNamedElement enumCandidate : enumCandidates) {
                    if (!(enumCandidate instanceof RfEnum) || !secondType.equals(((RfEnum)enumCandidate).getParentEnumType())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

