/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidUtils;

public class RfArchitecture
extends RfBlock
implements IRfEntityComplement {
    private static final long serialVersionUID = 1L;
    private static final Set<HidFlatteningOption> FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS));
    private static final int WRITE = 1;
    private static final int READ = 2;
    private static final int READ_WRITE = 3;
    private static final int ERROR_IO_CONNECT = 4;

    public RfArchitecture(String name, DataType dataType) {
        super(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_ENTITY, 0L, null, false, 0);
    }

    public void init(String name, DataType dataType) {
        super.init(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_ENTITY, 0L, null, false, 0);
    }

    public String getQualifiedName() {
        if (this.getEnclosingScope() == null) {
            return "";
        }
        return String.valueOf(this.getName()) + " of " + this.getEnclosingLibrary().getName() + "." + this.getEntityName();
    }

    @Override
    public String getSignature() {
        return "architecture " + this.getQualifiedName();
    }

    public String getEntityName() {
        return this.getEnclosingScope().getName();
    }

    public RfEntity getEntity() {
        return (RfEntity)this.getEnclosingScope();
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARCHITECTURE);
    }

    @Override
    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VHDL_ARCHITECTURE;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        this.getSuperLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
        RfEntity entity = this.getEntity();
        if (entity == null) {
            return;
        }
        entity.getSuperLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
    }

    protected <T extends IRfNamedElement> void getSuperLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        super.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
    }

    @Override
    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        RfNamedElement result = this.getSuperLocalMember(classes, name, exclude);
        if (result != null) {
            return result;
        }
        RfEntity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getSuperLocalMember(classes, name, exclude);
    }

    protected RfNamedElement getSuperLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        return super.getLocalMember((Set)classes, name, exclude);
    }

    @Override
    public List<? extends IRfPortElement> getLocalPorts() {
        RfEntity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getLocalPorts();
    }

    @Override
    public List<RfPort> getPortsWithPrefix(String prefix, int matchType, boolean local) {
        RfEntity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getPortsWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<? extends IRfPortElement> getPortsWithPrefix(String prefix, int matchType) {
        return this.getPortsWithPrefix(prefix, matchType, true);
    }

    @Override
    public RfPort getPortWithPrefix(String prefix, int matchType, boolean local) {
        RfEntity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getPortWithPrefix(prefix, matchType, local);
    }

    @Override
    public IRfNamedElement getParameterWithPrefix(String prefix, int matchType) {
        RfEntity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getParameterWithPrefix(prefix, matchType);
    }

    @Override
    public RfNamedElement getEnclosingScope() {
        RfNamedElement enclosing = super.getEnclosingScope();
        if (enclosing != null && !enclosing.isImplicit()) {
            return enclosing;
        }
        IRfNamedElement associatedType = this.getAssociatedType();
        if (associatedType instanceof RfNamedElement) {
            return (RfNamedElement)associatedType;
        }
        return enclosing;
    }

    @Override
    protected IRfNamedElement internalComputeAssociatedType(DataType associatedDataType, IRfAssociatedType.AssocTypeKind associatedTypeKind, boolean returnDummyInfoType) {
        RfEntity entity = this.getEntity();
        if (!entity.isImplicit() && !entity.hasNoDefs(false)) {
            return entity;
        }
        return super.internalComputeAssociatedType(associatedDataType, associatedTypeKind, returnDummyInfoType);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_ARCHITECTURE: Duplicate architecture ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    private static final void markAsReadOrWrite(RfProject rfProject, Object scopeForDrivers, HidAccess loadHidAccess, RfNamedElement enclosingScope, Map<IRfNamedElement, UnusedCheck> referencesMap, Collection<IHid> hids, int readOrWrite, boolean skipParameter, ParserPath parserPath) {
        if (hids == null || hids.isEmpty()) {
            return;
        }
        for (IHid hid : hids) {
            HidOccurrence occurrence;
            Object prevInfoDriverScope;
            if (readOrWrite == 2 && hid.getHidKind() == IHidObject.HidKind.IMPLICIT) continue;
            IHid parentHid = null;
            boolean isHierarchical = false;
            HidAccess initialHid = loadHidAccess != null ? loadHidAccess : hid;
            while ((parentHid = hid.getParentHid()) != null && parentHid.getElement() != null && !(parentHid.getElement() instanceof RfInstance)) {
                hid = parentHid;
                isHierarchical = true;
            }
            IRfNamedElement element = null;
            if (hid instanceof RfHid) {
                element = hid.getElement();
            } else if (hid instanceof RfHidImplicit && ((RfHidImplicit)hid).isID() && enclosingScope != null) {
                element = enclosingScope.getLocalMember(RfVariable.class, hid.getName());
            }
            if (element instanceof RfAlias) {
                IRfNamedElement translated = ((RfAlias)element).getTranslatedType();
                Object object = element = translated instanceof IRfFieldElement ? translated : null;
                if (element instanceof RfDummyVariable) {
                    element = ((RfDummyVariable)element).getOriginalVar();
                }
            }
            if (element == null || skipParameter && element instanceof RfVariable && ((RfVariable)element).isParameter()) continue;
            UnusedCheck prevRefInfo = referencesMap.get(element);
            if (!(prevRefInfo == null || prevRefInfo.hasMultipleDrivers() || readOrWrite != 3 && readOrWrite != 1 || scopeForDrivers == null || (prevInfoDriverScope = prevRefInfo.getScopeForDrivers()) == null || scopeForDrivers.equals(prevInfoDriverScope) || !prevRefInfo.containsHid((IHidObject)initialHid))) {
                prevRefInfo.setMultipleDrivers();
            }
            int usedStatus = -1;
            boolean addScopeForDrivers = false;
            if (isHierarchical) {
                usedStatus = 3;
                if (readOrWrite != 2 && (prevRefInfo == null || prevRefInfo.getScopeForDrivers() == null)) {
                    addScopeForDrivers = true;
                }
            } else if (prevRefInfo == null || readOrWrite == 3) {
                usedStatus = readOrWrite;
                addScopeForDrivers = true;
            } else if (prevRefInfo.getUsedStatus() == (readOrWrite == 2 ? 1 : 2)) {
                usedStatus = 3;
                if (readOrWrite == 1) {
                    addScopeForDrivers = true;
                }
            } else if ((prevRefInfo.getUsedStatus() == 1 || prevRefInfo.getUsedStatus() == 3) && readOrWrite == 1 && prevRefInfo.getScopeForDrivers() == null) {
                usedStatus = prevRefInfo.getUsedStatus();
                addScopeForDrivers = true;
            }
            if (usedStatus != -1) {
                UnusedCheck refInfo = prevRefInfo;
                if (refInfo == null) {
                    refInfo = new UnusedCheck(usedStatus);
                    referencesMap.put(element, refInfo);
                }
                if (addScopeForDrivers && scopeForDrivers != null && !refInfo.hasMultipleDrivers()) {
                    refInfo.setUsedStatus(usedStatus, scopeForDrivers, (IHidObject)initialHid);
                } else {
                    refInfo.setUsedStatus(usedStatus);
                }
            }
            if (!(element instanceof RfPort) || !((RfPort)element).isInput() || ((RfPort)element).isParameter() || readOrWrite != 1 || parserPath == null || (occurrence = hid.getOccurrence()) == null) continue;
            int line = occurrence.getLine();
            String name = element.getName();
            int startOffset = occurrence.getOffset();
            int endOffset = startOffset + name.length();
            Map<String, Object> attributes = null;
            rfProject.addSemanticError(1, "PORT_CONNECTION: Cannot drive input port ''{0}''", element.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveHidsFromElaboration(ELWidthCheckContext elabContext, boolean triggerError, boolean isFirstSpec, byte semanticEnabled) throws BuildCancelException {
        if (this.hasElaborationFlag((byte)1)) {
            return;
        }
        if (!this.getSemanticEnable()) {
            return;
        }
        RfArchitecture rfArchitecture = this;
        synchronized (rfArchitecture) {
            if (this.hasElaborationFlag((byte)1)) {
                return;
            }
            this.getEntity().internalResolveHidsFromElaboration(elabContext, triggerError);
            this.internalResolveHidsFromElaboration(elabContext, triggerError);
            this.setElaborationFlag((byte)1);
        }
    }

    public void internalResolveHidsFromElaboration(ELWidthCheckContext elabContext, boolean triggerError) throws BuildCancelException {
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return;
        }
        try {
            ConfigInfo configInfo = new ConfigInfo(false, rfProject, this.getEnclosingLibrary(), false, rfProject.getToolCompat());
            configInfo.setElabContext(elabContext);
            ELManager manager = elabContext.getManager();
            FullChecksAndLibs fullCompileChecks = manager.getFullChecksAndLibs();
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
            RfLibrary enclosingLibrary = this.getEnclosingLibrary();
            if (onlyLibAndPkgNames != null && !enclosingLibrary.isPredefined()) {
                if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                    return;
                }
                if (fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                    return;
                }
            }
            this.resolveHids(configInfo, triggerError, false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void checkUnused(RfProject rfProject, boolean incremental, boolean triggerError, Set<ParserPath> changedFiles) throws BuildCancelException {
        rfProject.checkBuildCanceled();
        try {
            List<? extends RfNamedElement> parameters;
            LibraryPackageScope entityPkgScope;
            RfDefElement declaration = this.getDeclaration();
            if (declaration == null) {
                return;
            }
            ParserPath parserPath = declaration.getParserPath();
            if (changedFiles != null && !changedFiles.contains(parserPath)) {
                return;
            }
            RfEntity entity = this.getEntity();
            List<RfPort> ports = entity == null ? null : entity.getLocalMembers(RfPort.class);
            ArrayList<RfVariable> fields = new ArrayList<RfVariable>();
            this.getVariables(fields);
            ArrayList<RfInstance> instances = new ArrayList<RfInstance>();
            RfArchitecture.getInstances(this, instances);
            IdentityHashMap<IRfNamedElement, UnusedCheck> referencesMap = new IdentityHashMap<IRfNamedElement, UnusedCheck>();
            if (fields != null && !fields.isEmpty() || ports != null && !ports.isEmpty()) {
                this.visitHidObject(rfProject, new SignalReadWriteVisitor(rfProject, referencesMap, this));
            }
            LibraryPackageScope libPkgScope = this.getLibPkgScope();
            LibraryPackageScope libraryPackageScope = entityPkgScope = entity != null && !entity.isImplicit() ? entity.getLibPkgScope() : libPkgScope;
            if (!instances.isEmpty()) {
                for (RfInstance instance : instances) {
                    Map portConnections = DesignUtils.mapInstancePortConnections((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instance), new HashMap(), (Set)DesignUtils.PORT_CONNECTION_HID_FLATTENING, (boolean)true, (boolean)false, null);
                    if (portConnections == null || portConnections.isEmpty()) continue;
                    RfBlock candidateGenerateScope = instance.getEnclosingScope(RfBlock.class);
                    boolean isInGenerateBlock = candidateGenerateScope != null && candidateGenerateScope.isGenerate();
                    for (Map.Entry portConnection : portConnections.entrySet()) {
                        IRfPortElement port = (IRfPortElement)portConnection.getKey();
                        Set connSignals = (Set)portConnection.getValue();
                        if (connSignals == null || connSignals.isEmpty()) continue;
                        for (TCConnSignal connSignal : connSignals) {
                            IHidObject signalHidObject;
                            Map<String, Object> attributes;
                            int endOffset;
                            int startOffset;
                            String name;
                            int line;
                            HidOccurrence occurrence;
                            UnusedCheck prevRefInfo;
                            boolean isHierarchical = false;
                            IHid signalHid = connSignal.getSignalHid();
                            if (signalHid == null) continue;
                            IHid parentHid = null;
                            while ((parentHid = signalHid.getParentHid()) != null && parentHid.getElement() != null && !(parentHid.getElement() instanceof RfInstance)) {
                                signalHid = parentHid;
                                isHierarchical = true;
                            }
                            IRfNamedElement element = signalHid.getElement();
                            if (element == null || (prevRefInfo = (UnusedCheck)referencesMap.get(element)) != null && prevRefInfo.getUsedStatus() == 3 && !port.isOutput()) continue;
                            if (isHierarchical) {
                                if (prevRefInfo == null) {
                                    referencesMap.put(element, new UnusedCheck(3));
                                    continue;
                                }
                                prevRefInfo.setUsedStatus(3);
                                continue;
                            }
                            if (port.isInput()) {
                                if (element instanceof RfPort && ((RfPort)element).isOutput()) {
                                    IBuildConfigParserConstants.LanguageSyntax languageSyntax = declaration.getLanguageSyntax();
                                    if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008) continue;
                                    if (prevRefInfo == null) {
                                        referencesMap.put(element, new UnusedCheck(4));
                                    } else {
                                        prevRefInfo.setUsedStatus(4);
                                    }
                                    occurrence = signalHid.getOccurrence();
                                    if (occurrence == null) continue;
                                    line = occurrence.getLine();
                                    name = element.getName();
                                    startOffset = occurrence.getOffset();
                                    endOffset = startOffset + name.length();
                                    attributes = null;
                                    rfProject.addSemanticError(1, "PORT_CONNECTION: Output port ''{0}'' connected to an input port", entityPkgScope, startOffset, endOffset, attributes, line, declaration.getParserPath(), name);
                                    continue;
                                }
                                if (prevRefInfo == null) {
                                    referencesMap.put(element, new UnusedCheck(2, null, null, false, true));
                                    continue;
                                }
                                if (prevRefInfo.getUsedStatus() != 1) continue;
                                prevRefInfo.setUsedStatus(3);
                                continue;
                            }
                            if (port.isInout()) {
                                if (prevRefInfo == null) {
                                    referencesMap.put(element, new UnusedCheck(3));
                                    continue;
                                }
                                prevRefInfo.setUsedStatus(3);
                                continue;
                            }
                            IHidObject iHidObject = signalHidObject = !HidUtils.isOperator((IHidObject)connSignal.signalObject) ? connSignal.signalObject : null;
                            if (element instanceof RfPort && ((RfPort)element).isInput()) {
                                if (prevRefInfo == null) {
                                    referencesMap.put(element, new UnusedCheck(4));
                                } else {
                                    prevRefInfo.setUsedStatus(4);
                                }
                                occurrence = signalHid.getOccurrence();
                                if (occurrence == null) continue;
                                line = occurrence.getLine();
                                name = element.getName();
                                startOffset = occurrence.getOffset();
                                endOffset = startOffset + name.length();
                                attributes = null;
                                rfProject.addSemanticError(1, "PORT_CONNECTION: Input port ''{0}'' connected to an output port", entityPkgScope, startOffset, endOffset, attributes, line, declaration.getParserPath(), name);
                                continue;
                            }
                            if (prevRefInfo == null) {
                                referencesMap.put(element, new UnusedCheck(1, instance, signalHidObject, true, false));
                                continue;
                            }
                            if (prevRefInfo.getUsedStatus() == 2) {
                                referencesMap.put(element, new UnusedCheck(3, instance, signalHidObject, true, prevRefInfo.readByPort));
                                continue;
                            }
                            if (prevRefInfo.getUsedStatus() != 1 && prevRefInfo.getUsedStatus() != 3 || prevRefInfo.hasMultipleDrivers() || isInGenerateBlock) continue;
                            if (prevRefInfo.scopeForDrivers != null && prevRefInfo.containsHid(signalHidObject)) {
                                prevRefInfo.setMultipleDrivers();
                                continue;
                            }
                            prevRefInfo.setUsedStatus(prevRefInfo.getUsedStatus(), instance, signalHidObject);
                        }
                    }
                }
            }
            this.visitHidObject(rfProject, new SignalReadVisitor(rfProject, referencesMap));
            List<? extends RfNamedElement> list = parameters = entity == null ? null : entity.getLocalParameters();
            if (entity != null && parameters != null && !parameters.isEmpty()) {
                entity.visitHidObject(rfProject, new SignalReadVisitor(rfProject, referencesMap));
            }
            if (fields != null && !fields.isEmpty()) {
                for (RfVariable field : fields) {
                    this.checkUnused(rfProject, field, referencesMap, libPkgScope);
                }
            }
            if (ports != null && !ports.isEmpty()) {
                for (RfPort port : ports) {
                    this.checkUnused(rfProject, port, referencesMap, entityPkgScope);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void getVariables(List<RfVariable> result) {
        List<? extends RfNamedElement> parameters;
        RfEntity entity = this.getEntity();
        List<? extends RfNamedElement> list = parameters = entity == null ? null : entity.getLocalParameters();
        if (parameters != null && !parameters.isEmpty()) {
            for (RfNamedElement rfNamedElement : parameters) {
                if (!(rfNamedElement instanceof RfVariable) || RfArchitecture.invalidVariable((RfVariable)rfNamedElement)) continue;
                result.add((RfVariable)rfNamedElement);
            }
        }
        RfArchitecture.getVariablesHelper(this, result);
    }

    private static void getVariablesHelper(RfNamedElement scope, List<RfVariable> result) {
        List<RfBlock> blocks;
        List<RfVariable> variables = scope.getLocalMembers(RfVariable.class);
        if (variables != null && !variables.isEmpty()) {
            for (RfVariable variable : variables) {
                if (RfArchitecture.invalidVariable(variable)) continue;
                result.add(variable);
            }
        }
        if ((blocks = scope.getLocalMembers(RfBlock.class)) != null && !blocks.isEmpty()) {
            for (RfBlock block : blocks) {
                RfArchitecture.getVariablesHelper(block, result);
            }
        }
    }

    private static boolean invalidVariable(RfVariable variable) {
        int fieldKind = variable.getFieldKind();
        return fieldKind == 524288 || fieldKind == 0x100000 || variable instanceof RfAlias;
    }

    private static void getInstances(RfNamedElement scope, List<RfInstance> result) {
        List<RfBlock> generates;
        List<RfInstance> instances = scope.getLocalMembers(RfInstance.class);
        if (instances != null && !instances.isEmpty()) {
            result.addAll(instances);
        }
        if ((generates = scope.getLocalMembers(RfBlock.class)) != null && !generates.isEmpty()) {
            for (RfBlock generate : generates) {
                RfArchitecture.getInstances(generate, result);
            }
        }
    }

    private void checkUnused(RfProject rfProject, RfVariable field, Map<IRfNamedElement, UnusedCheck> referencesMap, LibraryPackageScope libPkgScope) {
        RfDefElement declaration = field.getDeclaration();
        String name = field.getName();
        int startOffset = declaration.getStartOffset();
        int endOffset = startOffset + name.length();
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_ELEMENT_NAME", name);
        UnusedCheck referenced = referencesMap.get(field);
        if (referenced == null) {
            String pattern = "";
            if (field.isParameter()) {
                pattern = "GENERIC_NEVER_USED: Generic ''{0}'' is never used";
            } else {
                pattern = "SIGNAL_NEVER_USED: Signal ''{0}'' is never used";
                if (field.isSignal()) {
                    attributes.put("QUICKFIX_KIND", 48);
                }
            }
            rfProject.addSemanticError(2, pattern, libPkgScope, startOffset, endOffset, attributes, declaration.getStartLine(), declaration.getParserPath(), name);
        } else if (!(referenced.getUsedStatus() != 1 || field instanceof RfPort && ((RfPort)field).isOutput())) {
            rfProject.addSemanticError(2, referenced.isWrittenByPort() ? "SIGNAL_NEVER_READ: Signal ''{0}'' is never read (connected to sub-instance output port)" : "SIGNAL_NEVER_READ: Signal ''{0}'' is never read", libPkgScope, startOffset, endOffset, attributes, declaration.getStartLine(), declaration.getParserPath(), name);
        } else if (!(referenced.getUsedStatus() != 2 || field instanceof RfPort && ((RfPort)field).isInput() || field.isConstant())) {
            rfProject.addSemanticError(2, referenced.isReadByPort() ? "SIGNAL_NEVER_WRITTEN: Signal ''{0}'' is never written (connected to sub-instance input port)" : "SIGNAL_NEVER_WRITTEN: Signal ''{0}'' is never written", libPkgScope, startOffset, endOffset, attributes, declaration.getStartLine(), declaration.getParserPath(), name);
        }
        if (referenced != null && referenced.hasMultipleDrivers() && (field instanceof RfPort && field.isOutput() || !(field instanceof RfPort) && !field.isSharedVariable())) {
            rfProject.addSemanticError(2, "SIGNAL_MULTIPLE_DRIVERS: Signal ''{0}'' has multiple drivers", libPkgScope, startOffset, endOffset, attributes, declaration.getStartLine(), declaration.getParserPath(), name);
        }
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        RfComponent result = this.getComponentWithPrefix(prefix, 9, true);
        if (result != null) {
            return result;
        }
        return super.getDesignWithPrefix(prefix, matchType);
    }

    @Override
    public String getAssociatedTypeName() {
        return this.getName();
    }

    @Override
    public Set<IRfNamedElement> elabGetAllImportedPackages() {
        Set<IRfNamedElement> entityImports = this.getEntity().elabGetAllImportedPackages();
        if (entityImports.isEmpty()) {
            return super.elabGetAllImportedPackages();
        }
        entityImports.addAll(super.elabGetAllImportedPackages());
        return entityImports;
    }

    @Override
    protected List<RfPackage> getPackageUses() {
        List<RfPackage> result = super.getPackageUses();
        RfEntity entity = this.getEntity();
        if (entity != null) {
            result.addAll(entity.getPackageUses());
        }
        return result;
    }

    public String getNameAndEnclosing() {
        String entityNameAndLibrary = this.getEntity().getNameAndEnclosing();
        return entityNameAndLibrary + "(" + this.getName() + ")";
    }

    @Override
    public String elementPathName() {
        return this.getName();
    }

    @Override
    public String getCustomName() {
        return this.getName();
    }

    @Override
    public List<IRfActionBlockElement> xGetExecBlocks(HidOperator driveStrength, HidOperator delayControl, XInstValueHolder instanceValueHolder, boolean initialBlocksOnly) {
        if (initialBlocksOnly) {
            return null;
        }
        Collection<? extends IRfActionBlockElement> actionBlocks = this.getLocalActionBlocks();
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return null;
        }
        ArrayList<IRfActionBlockElement> result = new ArrayList<IRfActionBlockElement>();
        for (IRfActionBlockElement iRfActionBlockElement : actionBlocks) {
            result.add(iRfActionBlockElement);
        }
        return result;
    }

    static class SignalReadVisitor
    implements IHidVisitor<RfHid> {
        private Map<IRfNamedElement, UnusedCheck> referencesMap;
        private RfProject rfProject;
        private ParserPath parserPath;
        private IRfNamedElement holderScope;
        private BiConsumer<IRfNamedElement, Collection<IHid>> argConsumer = (functionArgument, rhHids) -> {
            if (!(functionArgument instanceof RfVariable)) {
                return;
            }
            if (((RfVariable)functionArgument).isOutput()) {
                RfArchitecture.markAsReadOrWrite(this.rfProject, null, null, null, this.referencesMap, rhHids, 1, true, this.parserPath);
            } else if (((RfVariable)functionArgument).isInout()) {
                RfArchitecture.markAsReadOrWrite(this.rfProject, null, null, null, this.referencesMap, rhHids, 3, false, this.parserPath);
            } else {
                RfArchitecture.markAsReadOrWrite(this.rfProject, null, null, null, this.referencesMap, rhHids, 2, false, this.parserPath);
            }
        };

        public SignalReadVisitor(RfProject rfProject, Map<IRfNamedElement, UnusedCheck> referencesMap) {
            this.referencesMap = referencesMap;
            this.rfProject = rfProject;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.holderScope = holder instanceof HidHolder ? ((HidHolder)holder).getScope() : null;
        }

        public boolean visit(RfHid hidObject) {
            RfHid hid = hidObject;
            IHid parentHid = null;
            boolean isHierarchical = false;
            while ((parentHid = hid.getParentHid()) != null && parentHid.getElement() != null && !(parentHid.getElement() instanceof RfInstance)) {
                hid = parentHid;
                isHierarchical = true;
            }
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return true;
            }
            UnusedCheck prevRefInfo = null;
            prevRefInfo = this.referencesMap.get(element);
            if (prevRefInfo == null) {
                if ((!hid.hasOccurrence(HidQualifier.HID_IS_ACTUAL_PART) || element instanceof RfVariable && ((RfVariable)element).isParameter()) && element instanceof RfVariable) {
                    if (isHierarchical) {
                        this.referencesMap.put(element, new UnusedCheck(3));
                    } else {
                        this.referencesMap.put(element, new UnusedCheck(2));
                    }
                }
            } else if (prevRefInfo.getUsedStatus() == 1 && element instanceof RfVariable && ((RfVariable)element).isConstant()) {
                prevRefInfo.setUsedStatus(3);
            }
            if (hidObject.isMethodCall(false)) {
                if (isHierarchical) {
                    if (prevRefInfo == null) {
                        this.referencesMap.put(element, new UnusedCheck(3));
                    } else {
                        prevRefInfo.setUsedStatus(3);
                    }
                }
                RfHidUtils.consumeMethodCallArguments((IHid)hidObject, this.argConsumer, false);
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    static class SignalReadWriteVisitor
    implements IHidVisitor<RfHidOperator> {
        private static final long ASSIGN_QUALIFIERS = HidUtils.toQualifiersSet((HidOperatorQualifier[])new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_EXPRESSION, HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN, HidOperatorQualifier.IS_SELECT_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_SELECT_BLOCKING_ASSIGN, HidOperatorQualifier.IS_SELECT_CONTINUOUS_ASSIGN});
        private Map<IRfNamedElement, UnusedCheck> referencesMap;
        private RfNamedElement enclosingScope;
        private ParserPath parserPath;
        private RfProject rfProject;
        private RfProcess alwaysScope;
        private boolean isInGenerate;

        public SignalReadWriteVisitor(RfProject rfProject, Map<IRfNamedElement, UnusedCheck> referencesMap, RfNamedElement enclosingScope) {
            this.referencesMap = referencesMap;
            this.enclosingScope = enclosingScope;
            this.rfProject = rfProject;
        }

        public void setHolder(IHidHolder holder) {
            IRfNamedElement scope;
            IRfNamedElement currentScope = scope = ((RfHidHolder)holder).getScope();
            this.alwaysScope = scope instanceof RfProcess ? (RfProcess)scope : (RfProcess)scope.getEnclosingScope(RfProcess.class);
            this.isInGenerate = SignalReadWriteVisitor.isInGenerate(this.alwaysScope, (IRfScopeElement)currentScope);
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        private static final boolean isInGenerate(IRfScopeElement alwaysScope, IRfScopeElement currentScope) {
            if (currentScope instanceof RfBlock && ((RfBlock)currentScope).isGenerate()) {
                return true;
            }
            if (alwaysScope == null) {
                return false;
            }
            while (!(alwaysScope instanceof RfBlock && ((RfBlock)alwaysScope).isGenerate() || (alwaysScope = alwaysScope.getEnclosingScope()) == null)) {
            }
            return alwaysScope != null;
        }

        public final boolean visit(RfHidOperator operator) {
            boolean isComplete = operator.isComplete();
            if (!isComplete) {
                return true;
            }
            boolean hasAssignQualifier = operator.hasOccurrence(ASSIGN_QUALIFIERS);
            boolean isContinuousAssign = operator.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN);
            boolean hasPortConnectionQualifier = operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION);
            if (!hasAssignQualifier && !hasPortConnectionQualifier) {
                Set lhHids = operator.getLHHids(FLATTENING_OPTIONS);
                RfArchitecture.markAsReadOrWrite(this.rfProject, null, null, this.enclosingScope, this.referencesMap, lhHids, 2, false, this.parserPath);
                Set rhHids = operator.getRHHids(FLATTENING_OPTIONS);
                RfArchitecture.markAsReadOrWrite(this.rfProject, null, null, this.enclosingScope, this.referencesMap, rhHids, 2, false, this.parserPath);
            } else if (hasAssignQualifier) {
                TCLogic logic = new TCLogic();
                DesignUtils.collectConcurrentDriversAndLoads((IHidOperator)operator, (TCLogic)logic, FLATTENING_OPTIONS);
                Collection commonDrivers = logic.getCommonDrivers();
                Map loadDrivers = logic.getLoadDrivers();
                Object scopeForDrivers = null;
                RfArchitecture.markAsReadOrWrite(this.rfProject, null, null, this.enclosingScope, this.referencesMap, commonDrivers, 2, false, this.parserPath);
                if (loadDrivers != null && !loadDrivers.isEmpty()) {
                    Set<IHid> loads = loadDrivers.keySet();
                    HidAccess loadHidAccess = null;
                    if (!this.isInGenerate) {
                        HidAccess possibleSelect;
                        if (HidUtils.isHidAccess((IHidObject)operator.getLHValue()) && (possibleSelect = (HidAccess)operator.getLHValue()).isSelect()) {
                            loadHidAccess = possibleSelect;
                        }
                        scopeForDrivers = isContinuousAssign ? operator.getOccurrence() : this.alwaysScope;
                    }
                    RfArchitecture.markAsReadOrWrite(this.rfProject, scopeForDrivers, loadHidAccess, this.enclosingScope, this.referencesMap, loads, 1, true, this.parserPath);
                    for (IHid load : loads) {
                        Collection drivers = (Collection)loadDrivers.get(load);
                        RfArchitecture.markAsReadOrWrite(this.rfProject, null, null, this.enclosingScope, this.referencesMap, drivers, 2, false, this.parserPath);
                    }
                }
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private static class UnusedCheck {
        private int usedStatus;
        private Object scopeForDrivers;
        private Set<IHidObject> hids;
        private boolean multipleDrivers = false;
        private boolean writtenByPort;
        private boolean readByPort;

        public UnusedCheck(int usedStatus, Object scopeForDrivers, IHidObject hid) {
            this.setUsedStatus(usedStatus, scopeForDrivers, hid);
        }

        public UnusedCheck(int usedStatus) {
            this(usedStatus, null, null);
        }

        public UnusedCheck(int usedStatus, Object scopeForDrivers, IHidObject hid, boolean writtenByPort, boolean readByPort) {
            this(usedStatus, scopeForDrivers, hid);
            this.writtenByPort |= writtenByPort;
            this.readByPort |= readByPort;
        }

        public boolean isWrittenByPort() {
            return this.writtenByPort;
        }

        public boolean isReadByPort() {
            return this.readByPort;
        }

        public void setUsedStatus(int usedStatus) {
            this.usedStatus = usedStatus;
        }

        public void setUsedStatus(int usedStatus, Object scopeForDrivers, IHidObject hid) {
            this.usedStatus = usedStatus;
            if (this.multipleDrivers) {
                return;
            }
            this.scopeForDrivers = scopeForDrivers;
            if (hid != null) {
                if (this.hids == null) {
                    this.hids = new HashSet<IHidObject>();
                }
                this.hids.add(hid);
            }
        }

        public int getUsedStatus() {
            return this.usedStatus;
        }

        public Object getScopeForDrivers() {
            return this.scopeForDrivers;
        }

        public boolean containsHid(IHidObject hid) {
            return this.hids != null && this.hids.contains(hid);
        }

        public void setMultipleDrivers() {
            this.multipleDrivers = true;
        }

        public boolean hasMultipleDrivers() {
            return this.multipleDrivers;
        }
    }
}

