/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDuplicate;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfRulesContainer;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfBlock
extends RfRulesContainer
implements IRfBlockElement {
    private static final long serialVersionUID = 5L;
    protected long blockQualifiers;
    private String expression;
    private boolean isOptionalBranch;
    private int generateConstructIndex;
    private String customName;
    private String alternativeLabel;
    private transient byte semanticEnable;
    private transient byte elabFlags;

    public RfBlock(String name, DataType dataType, IRfAssociatedType.AssocTypeKind kind, long qualifier, String alternativeLabel, boolean isOptionalBranch, int generateConstructIndex) {
        super(name, dataType, kind);
        this.blockQualifiers = qualifier;
        this.alternativeLabel = alternativeLabel;
        this.isOptionalBranch = isOptionalBranch;
        this.generateConstructIndex = generateConstructIndex;
    }

    public void init(String name, DataType dataType, IRfAssociatedType.AssocTypeKind kind, long qualifier, String alternativeLabel, boolean isOptionalBranch, int generateConstructIndex) {
        super.init(name, dataType, kind);
        this.blockQualifiers = qualifier;
        this.alternativeLabel = alternativeLabel;
        this.isOptionalBranch = isOptionalBranch;
        this.generateConstructIndex = generateConstructIndex;
        this.customName = null;
    }

    public void setExpression(String expression) {
        this.expression = expression != null ? expression.trim() : expression;
    }

    public IHidOperator getForLoopRangeExpression() {
        if (!this.isLoopGenerate()) {
            return null;
        }
        final IHidOperator[] result = new IHidOperator[1];
        IHidVisitor<RfHidOperator> visitor = new IHidVisitor<RfHidOperator>(){

            public boolean visit(RfHidOperator hidObject) {
                if (!hidObject.isForLoopExpression()) {
                    return true;
                }
                result[0] = hidObject;
                return false;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        };
        this.visitHidObject(null, visitor);
        return result[0];
    }

    @Override
    public String getSignature() {
        return String.valueOf(this.isGenerate() ? "generate " : "block ") + this.getName();
    }

    public boolean isGenerate() {
        return this.isConditionalGenerate() || this.isLoopGenerate() || this.isCaseItemGenerate();
    }

    public void setSemanticEnable(byte enable) {
        if (enable > this.semanticEnable) {
            this.semanticEnable = enable;
        }
    }

    public void cleanElaborationInfo() {
        this.semanticEnable = 0;
        this.elabFlags = 0;
    }

    public boolean getSemanticEnable() {
        return this.semanticEnable > 0;
    }

    public byte getSemanticEnableRaw() {
        return this.semanticEnable;
    }

    public void setElaborationFlag(byte flag) {
        this.elabFlags = (byte)(this.elabFlags | flag);
    }

    public boolean hasElaborationFlag(byte flag) {
        return (this.elabFlags & flag) == flag;
    }

    public Collection<RfBlock> getAllLocalBlocks() {
        NullProtectedList<RfBlock> result = new NullProtectedList<RfBlock>();
        List<RfBlock> blocks = this.getLocalMembers(RfBlock.class);
        if (blocks == null || blocks.isEmpty()) {
            return result;
        }
        result.addAll(blocks);
        for (RfBlock block : blocks) {
            result.addAll(block.getAllLocalBlocks());
        }
        return result;
    }

    public Collection<RfProcess> getAllLocalProcesses() {
        NullProtectedList<RfProcess> result = new NullProtectedList<RfProcess>();
        result.addAll(this.getLocalMembers(RfProcess.class));
        Collection<RfBlock> blocks = this.getAllLocalBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return result;
        }
        for (RfBlock block : blocks) {
            result.addAll(block.getLocalMembers(RfProcess.class));
        }
        return result;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.member";
    }

    @Override
    public Image getImage() {
        if (this.isGenerate()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONDITION);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_BLOCK);
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getNameForDiagram() {
        StringBuilder fullName = new StringBuilder().append(super.getNameForDiagram());
        if (!this.isGenerate()) {
            return fullName.toString();
        }
        String expression = this.getExpression();
        if (expression != null) {
            fullName.append(" [").append(expression).append("]");
        }
        return fullName.toString().toLowerCase();
    }

    public boolean isLoopGenerate() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.FOR.value()) != 0L;
    }

    public boolean isConditionalGenerate() {
        return (this.blockQualifiers & (IRfActionBlockElement.BlockQualifier.IF.value() | IRfActionBlockElement.BlockQualifier.ELSIF.value() | IRfActionBlockElement.BlockQualifier.ELSE.value())) != 0L;
    }

    public boolean isCaseItemGenerate() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.CASE_ITEM.value()) != 0L;
    }

    public boolean isIfGenerate() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.IF.value()) != 0L;
    }

    public boolean isElseGenerate() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ELSE.value()) != 0L;
    }

    public boolean isElsIfGenerate() {
        return (this.blockQualifiers & IRfActionBlockElement.BlockQualifier.ELSIF.value()) != 0L;
    }

    public boolean isCaseOthersGenerate() {
        String expressionText = this.getExpression();
        if (expressionText == null) {
            return false;
        }
        return expressionText.toLowerCase().endsWith(" others");
    }

    public boolean hasInstances() {
        List<RfInstance> instances = this.getLocalMembers(RfInstance.class);
        if (instances != null && !instances.isEmpty()) {
            return true;
        }
        List<RfBlock> innerBlocks = this.getLocalMembers(RfBlock.class);
        if (innerBlocks == null || innerBlocks.isEmpty()) {
            return false;
        }
        for (RfBlock innerBlock : innerBlocks) {
            if (!innerBlock.hasInstances()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_NAMED_BLOCK: Duplicate named block ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    public Collection<? extends IRfActionBlockElement> getLocalActionBlocks() {
        return this.getLocalMembers(RfProcess.class);
    }

    public Collection<? extends IRfInstanceElement> getLocalInstancesWithPrefix(String prefix, int matchType) {
        return this.getInstancesWithPrefix(prefix, matchType, true);
    }

    public IRfBlockElement getBlockWithPrefix(String prefix, int matchType) {
        return this.getBlockWithPrefix(prefix, matchType, true);
    }

    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VHDL_BLOCK;
    }

    @Override
    public IRfPortElement getPortWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getParameterWithPrefix(String prefix, int matchType) {
        return null;
    }

    public boolean isOptionalBranch() {
        return this.isOptionalBranch;
    }

    public int getGenerateConstructIndex() {
        return this.generateConstructIndex;
    }

    public String getAlternativeLabel() {
        return this.alternativeLabel;
    }

    @Override
    public Set<IRfNamedElement> elabGetAllImportedPackages() {
        if (this instanceof RfArchitecture) {
            return super.elabGetAllImportedPackages();
        }
        LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            NullProtectedList<ImportInfo> importDeclarations = namedElement.getAllImportDeclarations();
            if (importDeclarations == null || importDeclarations.isEmpty()) {
                return true;
            }
            for (ImportInfo importDeclaration : importDeclarations) {
                IRfNamedElement imported = importDeclaration.getImportedElement();
                if (imported == null) continue;
                result.add(imported);
            }
            return true;
        };
        this.accept(this.getRfProject(), visitor);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elaborateImportedPackages(ELManager manager) {
        if (manager.getSemanticEnableRaw() != 3) {
            return;
        }
        if (this.hasElaborationFlag((byte)2)) {
            return;
        }
        RfBlock rfBlock = this;
        synchronized (rfBlock) {
            if (this.hasElaborationFlag((byte)2)) {
                return;
            }
            Set<IRfNamedElement> pkgs = this.elabGetAllImportedPackages();
            if (pkgs != null && !pkgs.isEmpty()) {
                for (IRfNamedElement pkg : pkgs) {
                    if (!(pkg instanceof IRfConstantsHolder)) continue;
                    ((IRfConstantsHolder)pkg).elaborateConstants(manager);
                }
            }
            this.setElaborationFlag((byte)2);
        }
    }

    public List<IRfInstanceElement> elaborateBlockParameters(ELParamValues values, ElementPath hierarchyPath, ELManager manager) {
        if (this.isLoopGenerate()) {
            return this.elaborateLoopBlockParameters(values, hierarchyPath, manager);
        }
        if (this.isIfGenerate() || this.isElsIfGenerate() || this.isElseGenerate() || this.isCaseItemGenerate()) {
            return this.elaborateConditionalBlockParameters(values, hierarchyPath, manager);
        }
        return Collections.singletonList(ELConstants.GENERATE_BLOCK_DEFAULT_INSTANCE);
    }

    private List<IRfInstanceElement> elaborateConditionalBlockParameters(ELParamValues paramValues, ElementPath hierarchyPath, ELManager manager) {
        return ELUtils.elaborateConditionalBlockParameters((IRfBlockElement)this, (this.isIfGenerate() || this.isElsIfGenerate() ? 1 : 0) != 0, (ELParamValues)paramValues, (ElementPath)hierarchyPath, (ELManager)manager);
    }

    public static IHidOperator getRangeForCondition(IHidObject condition, IRfNamedElement enclosingScope, IHidEvaluator evaluator, IHidEvaluationGuardian guardian, Set<IRfNamedElement> visited) {
        List<IHidObject> constraints;
        Hid attributeHid = null;
        int dimensionIndex = 0;
        IHidObject dimensionHidObject = null;
        if (HidUtils.isHid((IHidObject)condition)) {
            attributeHid = (Hid)condition;
        } else if (HidUtils.isHidAccess((IHidObject)condition)) {
            if (evaluator == null || guardian == null) {
                return null;
            }
            attributeHid = ((HidAccess)condition).getParentHid();
            List selectsContainer = ((RfHidAccess)condition).getSelects();
            if (selectsContainer != null && !selectsContainer.isEmpty()) {
                dimensionHidObject = (IHidObject)selectsContainer.get(0);
                IELParamValue dimensionIndexValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)dimensionHidObject, (IHidEvaluator)evaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)enclosingScope, (boolean)false), (IHidEvaluationGuardian)guardian));
                if (!(dimensionIndexValue instanceof ELParamValues.ParamValueNumber)) {
                    return null;
                }
                dimensionIndex = dimensionIndexValue.bigIntegerValue().intValue() - 1;
            }
        }
        if (attributeHid == null || dimensionIndex < 0) {
            return null;
        }
        HidAccess parentAccess = attributeHid.getParentAccess();
        if (parentAccess == null || !parentAccess.isAttributeAccess()) {
            return null;
        }
        Hid parentHid = parentAccess.getParentHid();
        if (parentHid == null) {
            return null;
        }
        IRfNamedElement associatedType = parentHid.getElement();
        if (!(associatedType instanceof IRfAssociatedType)) {
            return null;
        }
        if (visited.contains(associatedType)) {
            return null;
        }
        visited.add(associatedType);
        DataType dataType = ((IRfAssociatedType)associatedType).getDataType();
        if (dataType == null) {
            return null;
        }
        List<IHidObject> list = constraints = associatedType instanceof RfListType ? dataType.getArrayConstraintHidObjects() : dataType.getElementConstraintHidObjects();
        if (constraints == null || constraints.isEmpty()) {
            Hid newParentHid = parentHid.upwardsCopy(true);
            RfHid leftAttrHid = STransformer.makeStandInHid("LEFT", null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            RfHidAccess lhAccess = STransformer.makeStandInAccess(newParentHid, leftAttrHid, 5, null);
            if (dimensionIndex > 0 && dimensionHidObject != null) {
                STransformer.makeStandInAccess(leftAttrHid, null, Integer.MIN_VALUE, Collections.singletonList(dimensionHidObject));
            }
            RfHid rightAttrHid = STransformer.makeStandInHid("RIGHT", null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            RfHidAccess rhAccess = STransformer.makeStandInAccess(newParentHid, rightAttrHid, 5, null);
            if (dimensionIndex > 0 && dimensionHidObject != null) {
                STransformer.makeStandInAccess(rightAttrHid, null, Integer.MIN_VALUE, Collections.singletonList(dimensionHidObject));
            }
            BitVectorContext defaultContext = BitVectorContext.of((IRfNamedElement)associatedType, (boolean)false);
            ELParamValueScope lhValue = ELUtils.evaluate((IHidObject)lhAccess, (IHidEvaluator)evaluator, (BitVectorContext)defaultContext, (IHidEvaluationGuardian)guardian);
            ELParamValueScope rhValue = ELUtils.evaluate((IHidObject)rhAccess, (IHidEvaluator)evaluator, (BitVectorContext)defaultContext, (IHidEvaluationGuardian)guardian);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)lhValue) || ELUtils.isUnsuccessfulEval((ELParamValueScope)rhValue)) {
                return STransformer.makeStandInOperator((IHidObject)leftAttrHid, Collections.singletonList(rightAttrHid), 145, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "to", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
            }
            if (lhValue.intValue() >= rhValue.intValue()) {
                return STransformer.makeStandInOperator((IHidObject)leftAttrHid, Collections.singletonList(rightAttrHid), 38, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "downto", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
            }
            return STransformer.makeStandInOperator((IHidObject)leftAttrHid, Collections.singletonList(rightAttrHid), 145, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "to", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
        }
        IHidObject constraint = constraints.get(0);
        if (constraint instanceof RfHid) {
            constraint = RfBlock.getRangeForCondition(constraint, enclosingScope, evaluator, guardian, visited);
        }
        if (constraint == null) {
            return null;
        }
        List dimensions = HidUtils.flattenSelect((IHidObject)constraint);
        if (dimensions.size() < dimensionIndex) {
            return null;
        }
        IHidObject dimensionOp = (IHidObject)dimensions.get(dimensionIndex);
        if (!HidUtils.isOperator((IHidObject)dimensionOp)) {
            return null;
        }
        return (IHidOperator)dimensionOp;
    }

    private List<IRfInstanceElement> elaborateLoopBlockParameters(ELParamValues originalParamValues, ElementPath hierarchyPath, ELManager manager) {
        int max_nof_tries;
        manager.checkBuildCanceled();
        String blockName = this.getName();
        RfHidHolder hidHolder = this.getHidHolder();
        if (hidHolder == null || hidHolder.isHidObjectsEmpty()) {
            manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNINITIALIZED_LOOP_GENERATE: Cannot initialize loop generate ''{0}''", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
            return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
        }
        final ELConstants.LoopGenerateIdentity identity = new ELConstants.LoopGenerateIdentity();
        ELParamValues paramValues = originalParamValues.copy();
        final ELParamValuesHidEvaluator evaluator = paramValues.getHidEvaluator(manager);
        final IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.GENERATE_BLOCK, (IRfNamedElement)this, (ElementPath)hierarchyPath, (boolean)false, (ELManager)manager);
        BitVectorContext noContext = BitVectorContext.of((IRfNamedElement)this, (boolean)false);
        hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IRfHidOperatorLayer>(){

            public boolean visit(IRfHidOperatorLayer hidObject) {
                if (hidObject.isForCondition()) {
                    guardian.markEvaluated((IHidOperator)hidObject);
                    IHidObject condition = hidObject.getLHValue();
                    if (HidUtils.isOperator((IHidObject)condition)) {
                        identity.loopCondition = (IHidOperator)condition;
                    } else if (HidUtils.isHid((IHidObject)condition) || HidUtils.isHidAccess((IHidObject)condition)) {
                        identity.loopCondition = RfBlock.getRangeForCondition(condition, RfBlock.this, (IHidEvaluator)evaluator, guardian, new HashSet<IRfNamedElement>());
                    }
                }
                return true;
            }

            public Class<IRfHidOperatorLayer> getType() {
                return IRfHidOperatorLayer.class;
            }
        });
        if (identity.loopCondition == null) {
            manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNINITIALIZED_LOOP_GENERATE: Cannot initialize loop generate ''{0}''", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
            return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
        }
        List<RfVariable> fieldMembers = this.getLocalMembers(RfVariable.class);
        if (fieldMembers == null) {
            manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNINITIALIZED_LOOP_GENERATE: Cannot initialize loop generate ''{0}''", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
            return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
        }
        String genvarName = null;
        RfVariable genvarParameter = null;
        IELParamValue genvarValue = null;
        for (RfVariable variable : fieldMembers) {
            if (variable.getFieldKind() != 524288) continue;
            genvarParameter = variable;
            genvarName = genvarParameter.getName();
            break;
        }
        if (genvarParameter == null) {
            manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNINITIALIZED_LOOP_GENERATE: Cannot initialize loop generate ''{0}''", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
            return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
        }
        HidOperator genvarStepOperator = null;
        HidOperator loopConditionOperator = null;
        HidImplicit oneImplicit = STransformer.BUILDERS.buildImplicit("1", 243);
        if (((IRfHidOperatorLayer)identity.loopCondition).isDirectionTo()) {
            guardian.updateElements((IRfNamedElement)genvarParameter, (IRfNamedElement)genvarParameter);
            context = ELUtils.makeEvaluatorContext((IHidEvaluator)evaluator, (IRfNamedElement)genvarParameter, (ElementPath)hierarchyPath, (ELManager)manager);
            genvarValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)identity.loopCondition.getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (!(genvarValue instanceof ELParamValues.ParamValueNumber)) {
                manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_LOOP_GENERATE_CONDITION: Cannot resolve loop generate ''{0}'' condition", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
                return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
            }
            genvarHid = STransformer.BUILDERS.buildHid(genvarName, (IRfNamedElement)genvarParameter, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            genvarStepOperator = STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(oneImplicit), 225, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "+", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
            loopConditionOperator = STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(identity.loopCondition.getFirstRHValue()), 190, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "<=", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
        } else if (((IRfHidOperatorLayer)identity.loopCondition).isDirectionDownto()) {
            guardian.updateElements((IRfNamedElement)genvarParameter, (IRfNamedElement)genvarParameter);
            context = ELUtils.makeEvaluatorContext((IHidEvaluator)evaluator, (IRfNamedElement)genvarParameter, (ElementPath)hierarchyPath, (ELManager)manager);
            genvarValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)identity.loopCondition.getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            if (!(genvarValue instanceof ELParamValues.ParamValueNumber)) {
                manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_LOOP_GENERATE_CONDITION: Cannot resolve loop generate ''{0}'' condition", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
                return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
            }
            genvarHid = STransformer.BUILDERS.buildHid(genvarName, (IRfNamedElement)genvarParameter, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            genvarStepOperator = STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(oneImplicit), 226, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "-", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
            loopConditionOperator = STransformer.BUILDERS.buildOperator((IHidObject)genvarHid, Collections.singletonList(identity.loopCondition.getFirstRHValue()), 191, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ">=", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
        } else {
            manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_LOOP_GENERATE_CONDITION: Cannot resolve loop generate ''{0}'' condition", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
            return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
        }
        paramValues.putDirectly(genvarName, genvarValue);
        guardian.updateElements((IRfNamedElement)this, (IRfNamedElement)this);
        if (loopConditionOperator != null) {
            IELParamValue loopResult = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)loopConditionOperator, (IHidEvaluator)evaluator, (BitVectorContext)noContext, (IHidEvaluationGuardian)guardian));
            if (!(loopResult instanceof ELParamValues.ParamValueNumber)) {
                manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_LOOP_GENERATE_CONDITION: Cannot resolve loop generate ''{0}'' condition", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
                return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
            }
            if (ELUtils.isFalse((IELParamValue)loopResult)) {
                return null;
            }
        } else {
            manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNRESTRICTED_LOOP_GENERATE: Loop generate ''{0}'' does not end", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
            return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
        }
        ArrayList<IRfInstanceElement> result = new ArrayList<IRfInstanceElement>();
        int loopCutoff = manager.getLoopBlockCutoff();
        boolean controlEachGenerateBlockOnce = manager.isControlEachGenerateBlockOnce();
        int n = max_nof_tries = controlEachGenerateBlockOnce ? 1 : loopCutoff;
        while (true) {
            if (max_nof_tries <= 0) {
                if (controlEachGenerateBlockOnce) break;
                manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "MAX_COUNT_LOOP_GENERATE: Max count ''{0}'' exceeded for loop generate ''{1}'' (increase limit with directive +dvt_elaboration_loop_block_cutoff)", (IRfNamedElement)this, hierarchyPath, new Object[]{loopCutoff, blockName});
                break;
            }
            manager.checkBuildCanceled();
            String newValueText = genvarValue.getDVTNumber().toString(10, false, false);
            IHidObject newValueHidObject = this.internalMakeGenvarValue(newValueText);
            String newElaboratedName = blockName + "(" + newValueText + ")";
            DummyInstance newElaborated = DummyInstance.of((String)newElaboratedName, (IRfDesignElement)this, (IRfFieldElement)genvarParameter, (IHidObject)newValueHidObject);
            result.add((IRfInstanceElement)newElaborated);
            genvarValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)genvarStepOperator, (IHidEvaluator)evaluator, (BitVectorContext)noContext, (IHidEvaluationGuardian)guardian));
            if (!(genvarValue instanceof ELParamValues.ParamValueNumber)) {
                manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_LOOP_GENERATE_STEP: Cannot resolve loop generate ''{0}'' step assignment", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
                return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
            }
            paramValues.putDirectly(genvarName, genvarValue);
            IELParamValue loopResult = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)loopConditionOperator, (IHidEvaluator)evaluator, (BitVectorContext)noContext, (IHidEvaluationGuardian)guardian));
            if (!(loopResult instanceof ELParamValues.ParamValueNumber)) {
                manager.reportProblemForElement(ElaborationDebugZone.SECOND_PASS, true, "UNRESOLVED_LOOP_GENERATE_CONDITION: Cannot resolve loop generate ''{0}'' condition", (IRfNamedElement)this, hierarchyPath, new Object[]{blockName});
                return Collections.singletonList(ELConstants.GENERATE_BLOCK_UNDEFINED_INSTANCE);
            }
            if (ELUtils.isFalse((IELParamValue)loopResult)) {
                return result;
            }
            --max_nof_tries;
        }
        return result;
    }

    private IHidObject internalMakeGenvarValue(String numberText) {
        if (numberText.charAt(0) != '-') {
            return STransformer.makeStandInImplicit(numberText, 243);
        }
        RfHidImplicit positive = STransformer.makeStandInImplicit(numberText.substring(1), 243);
        return STransformer.makeStandInOperator((IHidObject)positive, Collections.emptyList(), 226, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "-", HidOperatorOccurrence.DUMMY_OCCURRENCE, 0L);
    }

    public Map<String, HidOperatorWrapper> collectDefaultValueAssigns(boolean isCaseSensitive, boolean markElabOperators, ConcurrentHashMap<IRfNamedElement, Map<String, HidOperatorWrapper>> assignCache) {
        return RfBlock.collectDefaultValueAssigns((IRfDesignElement)this, isCaseSensitive, markElabOperators, assignCache);
    }

    protected static Map<String, HidOperatorWrapper> collectDefaultValueAssigns(IRfDesignElement design, boolean isCaseSensitive, boolean markElabOperators, ConcurrentHashMap<IRfNamedElement, Map<String, HidOperatorWrapper>> assignCache) {
        return assignCache.computeIfAbsent((IRfNamedElement)design, key -> {
            List<HidOperatorWrapper> initialAssigns;
            IRfDesignElement entity;
            List entityAssigns;
            ArrayList<HidOperatorWrapper> defaults = new ArrayList<HidOperatorWrapper>();
            if (design instanceof IRfEntityComplement && (entityAssigns = HidOperatorVisitorWithPaths.getSortedHidOperators((IRfNamedElement)(entity = ((IRfEntityComplement)design).getEntity()), (HidOperatorQualifier[])ELConstants.DECLARATION_OPERATOR_QUALIFIERS_ARRAY, (boolean)true)) != null) {
                defaults.addAll(entityAssigns);
            }
            if ((initialAssigns = ((RfNamedElement)design).getSortedAssignsToComputeConstants()) != null) {
                defaults.addAll(initialAssigns);
            }
            if (defaults.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, HidOperatorWrapper> result = new LinkedHashMap<String, HidOperatorWrapper>(defaults.size());
            for (HidOperatorWrapper defaultAssignWrapper : defaults) {
                HidOperator defaultAssign = (HidOperator)defaultAssignWrapper.hidObject;
                IHidObject lhSide = defaultAssign.getLHValue();
                if (!(lhSide instanceof IHid)) continue;
                if (markElabOperators) {
                    defaultAssign.addQualifier(HidQualifierCache.IS_ELABORATED_OPI_QUALIFIER);
                }
                String hidName = ((IHid)lhSide).getName();
                if (defaultAssign.hasQualifier(HidQualifierCache.IS_HIDDEN_QUALIFIER)) {
                    RfEnum candidate;
                    ISDataType dataType;
                    IRfNamedElement type;
                    ISDataAbstract resolvedType = defaultAssign.getOperatorResolvedType();
                    if (resolvedType == null || !((type = (dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType)).getType()) instanceof RfScalarType) || !((RfScalarType)type).isEnumType() || (candidate = ((RfScalarType)type).getEnclosingScope().getLocalEnum(hidName, type.getName(), false)) == null) continue;
                    result.put(candidate.getElabName(isCaseSensitive), defaultAssignWrapper);
                    continue;
                }
                String paramName = hidName;
                if (paramName == null) continue;
                result.put(isCaseSensitive ? paramName : paramName.toLowerCase(), defaultAssignWrapper);
            }
            return result.isEmpty() ? Collections.emptyMap() : result;
        });
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.blockQualifiers = 0L;
        this.expression = null;
        this.isOptionalBranch = false;
        this.generateConstructIndex = 0;
        this.customName = null;
        this.alternativeLabel = null;
        this.cleanElaborationInfo();
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.customName = null;
        this.alternativeLabel = null;
    }

    public static String getSimpleName(String fullName) {
        int index = fullName.indexOf("@g:");
        return index > 0 ? fullName.substring(0, index) : fullName;
    }

    @Override
    public String elementPathName() {
        return this.getCustomName();
    }

    @Override
    public String getCustomName() {
        if (this.customName == null) {
            this.customName = super.getCustomName() + "@g:" + this.generateConstructIndex + this.isImplicit() + this.isLoopGenerate() + this.isOptionalBranch() + (this.expression != null ? this.expression.replace(' ', '_') : "");
        }
        return this.customName;
    }

    public List<IRfActionBlockElement> xGetExecBlocks(HidOperator driveStrength, HidOperator delayControl, XInstValueHolder instanceValueHolder, boolean initialBlocksOnly) {
        if (initialBlocksOnly) {
            return null;
        }
        Collection<? extends IRfActionBlockElement> actionBlocks = this.getLocalActionBlocks();
        if (actionBlocks == null || actionBlocks.isEmpty()) {
            return null;
        }
        ArrayList<IRfActionBlockElement> result = new ArrayList<IRfActionBlockElement>();
        for (IRfActionBlockElement iRfActionBlockElement : actionBlocks) {
            result.add(iRfActionBlockElement);
        }
        return result;
    }
}

