/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfRulesContainer;

public class RfConfiguration
extends RfRulesContainer
implements IRfEntityComplement,
IRfDesignElement,
IRfConfiguration {
    private static final long serialVersionUID = 1L;

    public RfConfiguration(String name, DataType dataType) {
        super(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_ENTITY);
    }

    public void init(String name, DataType dataType) {
        super.init(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_ENTITY);
    }

    public String getQualifiedName() {
        if (this.getEnclosingScope() == null) {
            return "";
        }
        return String.valueOf(this.getName()) + " of " + this.getEnclosingLibrary().getName() + "." + this.getEntityName();
    }

    @Override
    public String getSignature() {
        return "configuration " + this.getQualifiedName();
    }

    @Override
    public RfNamedElement getEnclosingScope() {
        RfNamedElement enclosing = super.getEnclosingScope();
        if (enclosing != null && !enclosing.isImplicit()) {
            return enclosing;
        }
        IRfNamedElement associatedType = this.getAssociatedType();
        if (associatedType instanceof RfNamedElement) {
            return (RfNamedElement)associatedType;
        }
        return enclosing;
    }

    @Override
    protected IRfNamedElement internalComputeAssociatedType(DataType associatedDataType, IRfAssociatedType.AssocTypeKind associatedTypeKind, boolean returnDummyInfoType) {
        RfEntity entity = this.getEntity();
        if (!entity.isImplicit()) {
            return entity;
        }
        return super.internalComputeAssociatedType(associatedDataType, associatedTypeKind, returnDummyInfoType);
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        RfEntity entity = this.getEntity();
        if (entity == null || entity.isImplicit()) {
            return;
        }
        entity.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
    }

    @Override
    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        RfEntity entity = this.getEntity();
        if (entity == null || entity.isImplicit()) {
            return null;
        }
        return entity.getLocalMember((Set)classes, name, exclude);
    }

    public RfEntity getEntity() {
        return (RfEntity)this.getEnclosingScope();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONFIGURATION);
    }

    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VHDL_CONFIGURATION;
    }

    @Override
    public List<? extends IRfPortElement> getLocalPorts() {
        return this.getEntity().getLocalPorts();
    }

    @Override
    public List<? extends RfNamedElement> getLocalParameters() {
        return this.getEntity().getLocalParameters();
    }

    @Override
    public List<? extends RfNamedElement> getPortListParameters() {
        return this.getEntity().getPortListParameters();
    }

    @Override
    public List<? extends RfNamedElement> getLocalElabConstants() {
        return this.getEntity().getLocalElabConstants();
    }

    @Override
    public Collection<? extends IRfInstanceElement> getLocalInstances() {
        return null;
    }

    public Collection<? extends IRfActionBlockElement> getLocalActionBlocks() {
        return null;
    }

    @Override
    public List<RfPort> getPortsWithPrefix(String prefix, int matchType, boolean local) {
        return this.getEntity().getPortsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfPort getPortWithPrefix(String prefix, int matchType, boolean local) {
        return this.getEntity().getPortWithPrefix(prefix, matchType, local);
    }

    public IRfNamedElement getParameterWithPrefix(String prefix, int matchType) {
        return this.getEntity().getParameterWithPrefix(prefix, matchType);
    }

    @Override
    public RfInstance getInstanceWithPrefix(String prefix, int matchType, boolean local) {
        return null;
    }

    public Collection<? extends IRfInstanceElement> getLocalInstancesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfBlockElement getBlockWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfDesignElement getArchitecture() {
        RfEntity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getArchitecture();
    }

    public List<? extends IRfBlockElement> getArchitectures() {
        if (this.getEntity() == null) {
            return null;
        }
        return this.getEntity().getArchitectures();
    }

    public String getEntityName() {
        return this.getEnclosingScope().getName();
    }

    @Override
    public String getAssociatedTypeName() {
        return this.getName();
    }

    public boolean isDummyConfig() {
        return false;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_CONFIGURATION: Duplicate configuration ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    public List<IRfDesignElement> getDesignTops() {
        ArrayList<IRfDesignElement> result = new ArrayList<IRfDesignElement>();
        result.add(this.getEntity());
        return result;
    }

    public IRfDesignElement getFirstDesignTop() {
        return this.getEntity();
    }

    public List<IRfLibraryElement> getDefaultLiblist() {
        return null;
    }

    public IRfConfigurationRule getSelectedBlockConfigRule() {
        Collection<? extends IRfConfigurationRule> localRules = this.getLocalRules();
        if (localRules == null || localRules.size() != 1) {
            return null;
        }
        RfEntity entity = this.getEntity();
        IRfConfigurationRule blockRule = localRules.iterator().next();
        return blockRule.isValidForDesign((IRfDesignElement)entity) != null ? blockRule : null;
    }

    public IRfConfiguration getRelativeConfig(ElementPath path) {
        return this;
    }

    public void resolveConfiguration(IRfSingleLangProject rfProject) {
        if (!(rfProject instanceof RfProject)) {
            return;
        }
        RfLibrary enclosingLibrary = this.getEnclosingLibrary();
        ConfigInfo configInfo = new ConfigInfo(false, rfProject, enclosingLibrary, false, rfProject.getToolCompat());
        this.resolveHids(configInfo, true, false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
    }
}

