/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.Identifier;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfImplicitConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfRulesContainer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class RfConfigurationRule
extends RfRulesContainer
implements IRfConfigurationRule,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DataType DATA_TYPE_UNKNOWN = new DataType("");
    private IHidOperator specification;
    private IRfConfigurationRule.ConfigCoverage specificationCoverage;
    private IHidObject specificationTarget;
    private IRfNamedElement specificationTargetElement;
    private List<RfInstance> specificationInstances;

    public RfConfigurationRule(String name) {
        super(name, DATA_TYPE_UNKNOWN, IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN);
    }

    public IRfConfigurationRule.ConfigCoverage getRuleCoverage() {
        return this.internalGetCoverage();
    }

    public IRfConfigurationRule.ConfigKind getRuleKind() {
        return IRfConfigurationRule.ConfigKind.USE;
    }

    public IRfAssociatedType.AssocTypeKind getBindingKind() {
        return this.getAssociatedTypeKind();
    }

    public DataType getBindingDataType() {
        return this.getDataType();
    }

    public List<Identifier> list() {
        return null;
    }

    public void setResolvedLiblist(List<IRfLibraryElement> resolveLiblist) {
    }

    public void setResolvedDesignMapping(IRfNamedElement mapping) {
    }

    public IRfNamedElement getResolvedDesignMapping(ElementPath prefix) {
        RfArchitecture lastArchitecture;
        if (this.isBlockRule()) {
            return this.getBlockElement();
        }
        IRfNamedElement assocType = this.getAssociatedType();
        if (assocType instanceof RfEntity && (lastArchitecture = ((RfEntity)assocType).getArchitecture()) != null) {
            return lastArchitecture;
        }
        if (assocType instanceof IRfConfiguration) {
            return ((IRfConfiguration)assocType).getRelativeConfig(prefix);
        }
        return assocType;
    }

    public ElementPath getElementDescription() {
        return null;
    }

    public List<IRfLibraryElement> getResolvedLiblist() {
        return null;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.specification = null;
        this.specificationTarget = null;
        this.specificationTargetElement = null;
        this.specificationCoverage = null;
        this.specificationInstances = null;
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.specification = null;
        this.specificationTarget = null;
        this.specificationTargetElement = null;
        this.specificationCoverage = null;
        this.specificationInstances = null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder().append("<").append(this.getName());
        result.append(" ** ").append((Object)this.getBindingKind());
        DataType dataType = this.getBindingDataType();
        if (dataType != null) {
            result.append(" ** ").append(dataType);
        }
        result.append(">");
        return result.toString();
    }

    private void computeSpecification() {
        if (this.specification != null) {
            return;
        }
        RfHidHolder hidHolder = this.getHidHolder();
        if (hidHolder == null) {
            return;
        }
        hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<IRfHidOperatorLayer>(){

            public boolean visit(IRfHidOperatorLayer hidObject) {
                if (hidObject.isConfigRuleSpecification()) {
                    RfConfigurationRule.this.specification = hidObject;
                    return false;
                }
                return true;
            }

            public Class<IRfHidOperatorLayer> getType() {
                return IRfHidOperatorLayer.class;
            }
        });
        if (this.specification != null) {
            ListContainer rhSide;
            this.specificationTarget = null;
            this.specificationTargetElement = null;
            this.specificationCoverage = null;
            this.specificationInstances = null;
            if (this.specification.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                this.specificationCoverage = IRfConfigurationRule.ConfigCoverage.ALL;
                IHidObject hidObject = this.specification.getLHValue();
                switch (hidObject.getHidKind()) {
                    case HID: 
                    case ACCESS: {
                        this.specificationTarget = hidObject;
                        break;
                    }
                }
                return;
            }
            IHidObject lhSide = this.specification.getLHValue();
            if (lhSide != null) {
                switch (lhSide.getHidKind()) {
                    case IMPLICIT: {
                        RfHidImplicit implicit = (RfHidImplicit)lhSide;
                        if (implicit.isAll()) {
                            this.specificationCoverage = IRfConfigurationRule.ConfigCoverage.ALL;
                            break;
                        }
                        if (!implicit.isOthers()) break;
                        this.specificationCoverage = IRfConfigurationRule.ConfigCoverage.OTHERS;
                        break;
                    }
                    case HID: 
                    case OPERATOR: {
                        this.specificationCoverage = IRfConfigurationRule.ConfigCoverage.LIST;
                        ArrayList<RfInstance> specificationInstancesResult = new ArrayList<RfInstance>();
                        Set instanceHids = HidUtils.flattenToHids((IHidObject)lhSide, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                        for (IHid instanceHid : instanceHids) {
                            IRfNamedElement instance = instanceHid.getElement();
                            if (!(instance instanceof RfInstance)) continue;
                            specificationInstancesResult.add((RfInstance)instance);
                        }
                        this.specificationInstances = specificationInstancesResult;
                        break;
                    }
                }
            }
            if ((rhSide = this.specification.getRHValues()) != null && rhSide.size() == 1) {
                this.specificationTarget = (IHidObject)rhSide.get(0);
            }
        }
    }

    public List<RfInstance> getSpecificationInstances() {
        this.computeSpecification();
        return this.specificationInstances;
    }

    public IRfConfigurationRule.ConfigCoverage internalGetCoverage() {
        this.computeSpecification();
        return this.specificationCoverage;
    }

    public IHidOperator getSpecification() {
        this.computeSpecification();
        return this.specification;
    }

    public IRfNamedElement getSpecificationTargetElement() {
        this.computeSpecification();
        if (this.specificationTargetElement == null && this.specificationTarget != null) {
            switch (this.specificationTarget.getHidKind()) {
                case ACCESS: {
                    IRfNamedElement blockAlternative;
                    IHidObject firstSelect;
                    this.specificationTargetElement = ((HidAccess)this.specificationTarget).getParentHid().getElement();
                    List selects = ((HidAccess)this.specificationTarget).getSelects();
                    if (selects == null || selects.isEmpty() || !HidUtils.isHid((IHidObject)(firstSelect = (IHidObject)selects.get(0))) || !((blockAlternative = ((Hid)firstSelect).getElement()) instanceof RfBlock)) break;
                    this.specificationTargetElement = blockAlternative;
                    break;
                }
                case HID: {
                    this.specificationTargetElement = ((Hid)this.specificationTarget).getElement();
                    break;
                }
            }
        }
        return this.specificationTargetElement;
    }

    public IHidObject getSpecificationTarget() {
        this.computeSpecification();
        return this.specificationTarget;
    }

    protected void setSpecificationTargetElement(IRfNamedElement component) {
        this.specificationTargetElement = component;
    }

    public IRfBlockElement getBlockElement() {
        if (!this.isBlockRule()) {
            return null;
        }
        IRfNamedElement element = this.getSpecificationTargetElement();
        return element instanceof IRfBlockElement ? (IRfBlockElement)element : null;
    }

    public RfComponent getComponentElement() {
        if (this.isBlockRule()) {
            return null;
        }
        IRfNamedElement element = this.getSpecificationTargetElement();
        return DesignUtils.isVHDLComponent((Object)element) ? (RfComponent)element : null;
    }

    public RfNamedElement getSpecificationElement() {
        IRfBlockElement block = this.getBlockElement();
        if (block instanceof RfNamedElement) {
            return (RfNamedElement)block;
        }
        return this.getComponentElement();
    }

    public boolean isIncrementalConfiguration() {
        return this.getBindingDataType() == null && !this.isBlockRule();
    }

    public boolean isBlockRule() {
        return this.getBindingKind() == IRfAssociatedType.AssocTypeKind.ASSOC_BLOCK;
    }

    public IRfDesignElement isValidForDesign(IRfDesignElement entity) {
        if (!this.isBlockRule() || entity == null) {
            return null;
        }
        IRfBlockElement block = this.getBlockElement();
        if (block == null) {
            return entity.getLanguageKind() == LanguageKind.VLOG ? entity : null;
        }
        return DesignUtils.getDesignKind((Object)entity) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE && entity.equals(block) || DesignUtils.getDesignKind((Object)entity) == IRfNamedElement.ElementKind.VHDL_ENTITY && entity.equals(block.getEntity()) ? block : null;
    }

    public boolean isValidForIndex(int index, ELParamValues paramValues, ELManager manager) {
        if (!this.isBlockRule()) {
            return false;
        }
        IRfBlockElement block = this.getBlockElement();
        if (block == null) {
            return false;
        }
        if (this.specification.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
            IHidObject lhSide = this.specification.getLHValue();
            switch (lhSide.getHidKind()) {
                case OPERATOR: {
                    return false;
                }
                case ACCESS: {
                    HidAccess hidAccess = (HidAccess)lhSide;
                    List selects = hidAccess.getSelects();
                    if (selects != null && !selects.isEmpty()) {
                        IHidObject firstSelect = (IHidObject)selects.get(0);
                        if (HidUtils.isHid((IHidObject)firstSelect)) {
                            IRfNamedElement blockAlternative = ((Hid)firstSelect).getElement();
                            if (blockAlternative instanceof RfBlock) {
                                return false;
                            }
                        } else {
                            IHidEvaluationGuardian guardian;
                            ELParamValuesHidEvaluator evaluator = paramValues.getHidEvaluator(manager);
                            IELParamValue evalResult = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)firstSelect, (IHidEvaluator)evaluator, null, (IHidEvaluationGuardian)(guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.GENERATE_BLOCK, (IRfNamedElement)this, null, (boolean)false, (ELManager)manager))));
                            if (ELUtils.isUnsuccessfulEval((IELParamValue)evalResult)) {
                                return false;
                            }
                            DVTNumber result = evalResult.getDVTNumber();
                            if (DVTNumber.isUndefined((DVTNumber)result)) {
                                return false;
                            }
                            return result != null && result.intValue() == index;
                        }
                    }
                    return false;
                }
                case HID: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (clazz == RfConfigurationRule.class) {
            super.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
            return;
        }
        RfNamedElement element = this.getSpecificationElement();
        if (element == null) {
            return;
        }
        element.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
    }

    @Override
    public <T extends IRfNamedElement> List<T> getLocalMembers(boolean hideDuplicates, Class<T> clazz) {
        if (clazz == RfConfigurationRule.class) {
            return super.getLocalMembers(hideDuplicates, clazz);
        }
        RfNamedElement element = this.getSpecificationElement();
        if (element == null) {
            return null;
        }
        return element.getLocalMembers(hideDuplicates, clazz);
    }

    @Override
    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        RfNamedElement element = this.getSpecificationElement();
        if (element == null) {
            return null;
        }
        return element.getLocalMember((Set)classes, name, exclude);
    }

    @Override
    public List<ImportInfo> getWildcardUse() {
        IRfBlockElement blockElement;
        List<ImportInfo> blockResult;
        ArrayList<ImportInfo> result = new ArrayList<ImportInfo>(2);
        List<ImportInfo> superResult = super.getWildcardUse();
        if (superResult != null && !superResult.isEmpty()) {
            result.addAll(superResult);
        }
        List<ImportInfo> list = blockResult = (blockElement = this.getBlockElement()) instanceof RfBlock ? ((RfBlock)blockElement).getWildcardUse() : null;
        if (blockResult != null && !blockResult.isEmpty()) {
            result.addAll(blockResult);
        }
        return result;
    }

    @Override
    public List<ImportInfo> getExplicitUse() {
        IRfBlockElement blockElement;
        List<ImportInfo> blockResult;
        ArrayList<ImportInfo> result = new ArrayList<ImportInfo>(2);
        List<ImportInfo> superResult = super.getExplicitUse();
        if (superResult != null && !superResult.isEmpty()) {
            result.addAll(superResult);
        }
        List<ImportInfo> list = blockResult = (blockElement = this.getBlockElement()) instanceof RfBlock ? ((RfBlock)blockElement).getExplicitUse() : null;
        if (blockResult != null && !blockResult.isEmpty()) {
            result.addAll(blockResult);
        }
        return result;
    }

    public Map<String, HidOperatorWrapper> getParameterOverrides(boolean markElabOperators) {
        RfProject rfProject = this.getRfProject();
        ConfigInfo configInfo = new ConfigInfo(false, rfProject, this.getEnclosingLibrary(), true, IBuildConfigParserConstants.ToolCompat.DVT);
        return this.getAndTransformParameterOverrides(ELUtils.getEntityFromMapContainer((IRfNamedElement)this), markElabOperators, rfProject, configInfo);
    }

    public List<HidOperatorWrapper> getPortConnections(boolean triggerError, boolean checkTypeMatching) {
        return HidOperatorVisitorWithPaths.getHidOperators((IRfNamedElement)this, (HidOperatorQualifier[])ELConstants.PORT_CONNECTIONS_QUALIFIERS_ARRAY, (boolean)true);
    }

    @Override
    protected void internalResolveType(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        super.internalResolveType(configInfo, rfProject, report, onlyUnresolved, otherLanguage);
    }

    protected void checkImplicitPortConnections(IRfDesignElement design, Map<String, IRfPortElement> designPorts, ParserPath path, boolean triggerError, RfProject rfProject) {
        if (design == null || designPorts == null || path == null || rfProject == null) {
            return;
        }
        if (!triggerError) {
            return;
        }
        IRfDesignElement component = this.getComponentElement();
        if (component == null) {
            return;
        }
        HashSet<String> portNames = new HashSet<String>();
        List componentPorts = component.getLocalPortsNoAliases();
        if (componentPorts != null) {
            for (IRfNamedElement iRfNamedElement : componentPorts) {
                portNames.add(iRfNamedElement.getLowerCaseName());
            }
        }
        for (IRfNamedElement iRfNamedElement : designPorts.values()) {
            portNames.add(iRfNamedElement.getLowerCaseName());
        }
        int n = this.getOffset();
        int offsetEnd = n + (this instanceof RfImplicitConfigurationRule ? ((RfImplicitConfigurationRule)this).getName().length() : 3);
        int line = this.getLine();
        for (String portName : portNames) {
            String designPortMode;
            String componentPortMode;
            IRfPortElement entityPort = designPorts.get(portName);
            IRfPortElement componentPort = component.getPortWithPrefix(portName, 9);
            if (componentPort == null) {
                String initialValue = entityPort.getInitialValue(true);
                if (initialValue != null && !initialValue.isEmpty()) continue;
                String entityPortDirection = DVTStringUtil.toLowerCase((String)entityPort.getDirectionString());
                if (entityPort.isInput()) {
                    rfProject.addSemanticError(1, "INVALID_IMPLICIT_PORT_MAP: {0} {1} port ''{2}.{3}'' not in the list of {4} ''{5}'' ports", this.getLibPkgScope(), n, offsetEnd, null, line, path, "Entity", entityPortDirection, design.getName(), entityPort.getName(), "component", component.getName());
                    continue;
                }
                rfProject.addSemanticError(2, "IMPLICIT_PORT_MAP: {0} {1} port ''{2}.{3}'' not in the list of {4} ''{5}'' ports", this.getLibPkgScope(), n, offsetEnd, null, line, path, "Entity", entityPortDirection, design.getName(), entityPort.getName(), "component", component.getName());
                continue;
            }
            if (entityPort == null) {
                rfProject.addSemanticError(1, "INVALID_IMPLICIT_PORT_MAP: {0} {1} port ''{2}.{3}'' not in the list of {4} ''{5}'' ports", this.getLibPkgScope(), n, offsetEnd, null, line, path, "Component", DVTStringUtil.toLowerCase((String)componentPort.getDirectionString()), component.getName(), componentPort.getName(), "entity", design.getName());
                continue;
            }
            if (!RfInstance.internalCheckImplicitConfigurationCompatibility((IRfNamedElement)entityPort, (IRfNamedElement)componentPort)) {
                IRfNamedElement firstType = STransformer.INSTANCE.getBaseType((IRfNamedElement)entityPort, false);
                IRfNamedElement secondType = STransformer.INSTANCE.getBaseType((IRfNamedElement)componentPort, false);
                if (firstType instanceof RfAssociatedType.RfUnresolvedInfo || secondType instanceof RfAssociatedType.RfUnresolvedInfo) continue;
                rfProject.addSemanticError(1, "INVALID_IMPLICIT_PORT_MAP: Type mismatch between ''{0}'' of component port ''{1}.{2}'' and ''{3}'' of entity port ''{4}.{2}''", this.getLibPkgScope(), n, offsetEnd, null, line, path, ((RfAssociatedType)componentPort).getAssociatedTypeName(), component.getName(), entityPort.getName(), ((RfAssociatedType)entityPort).getAssociatedTypeName(), design.getName());
                continue;
            }
            if (componentPort.isInput() && !entityPort.isInput()) {
                componentPortMode = DVTStringUtil.toLowerCase((String)componentPort.getDirectionString());
                designPortMode = DVTStringUtil.toLowerCase((String)entityPort.getDirectionString());
                rfProject.addSemanticError(1, "INVALID_IMPLICIT_PORT_MAP: ''{0}'' component port ''{1}.{2}'' associated with ''{3}'' entity port ''{4}.{2}''", this.getLibPkgScope(), n, offsetEnd, null, line, path, componentPortMode, component.getName(), componentPort.getName(), designPortMode, design.getName());
                continue;
            }
            if (!componentPort.isOutput() || entityPort.isOutput()) continue;
            componentPortMode = DVTStringUtil.toLowerCase((String)componentPort.getDirectionString());
            designPortMode = DVTStringUtil.toLowerCase((String)entityPort.getDirectionString());
            rfProject.addSemanticError(1, "INVALID_IMPLICIT_PORT_MAP: ''{0}'' component port ''{1}.{2}'' associated with ''{3}'' entity port ''{4}.{2}''", this.getLibPkgScope(), n, offsetEnd, null, line, path, componentPortMode, component.getName(), componentPort.getName(), designPortMode, design.getName());
        }
    }
}

