/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfContext
extends RfNamedElement
implements IRfConstantsHolder {
    private static final long serialVersionUID = 1L;

    public RfContext(String name) {
        super(name);
    }

    public void elaborateConstants(ELManager manager) {
        this.elaborateImportedPackages(manager);
    }

    public void elaborateImportedPackages(ELManager manager) {
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        NullProtectedList<ImportInfo> importDeclarations = this.getAllImportDeclarations();
        if (importDeclarations == null || importDeclarations.isEmpty()) {
            return;
        }
        for (ImportInfo importDeclaration : importDeclarations) {
            IRfNamedElement imported = importDeclaration.getImportedElement();
            if (!(imported instanceof IRfConstantsHolder) || visited.contains(imported)) continue;
            visited.add(imported);
            ((IRfConstantsHolder)imported).elaborateConstants(manager);
        }
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.action";
    }

    public String getSignature() {
        return "context " + this.getName();
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONTEXT);
    }
}

